/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vvecmath;

import eu.mihosoft.vvecmath.Vector3d;
import java.util.Collection;
import java.util.List;

abstract class Spline {
    Spline() {
    }

    public void calcNaturalCubic(List<Vector3d> valueCollection, int coordIndex, Collection<Cubic> cubicCollection) {
        int i;
        int num = valueCollection.size() - 1;
        double[] gamma = new double[num + 1];
        double[] delta = new double[num + 1];
        double[] D = new double[num + 1];
        gamma[0] = 0.5;
        for (i = 1; i < num; ++i) {
            gamma[i] = 1.0 / (4.0 - gamma[i - 1]);
        }
        gamma[num] = 1.0 / (2.0 - gamma[num - 1]);
        double p0 = this.getByIndex(valueCollection.get(0), coordIndex);
        double p1 = this.getByIndex(valueCollection.get(1), coordIndex);
        delta[0] = 3.0 * (p1 - p0) * gamma[0];
        for (i = 1; i < num; ++i) {
            p0 = this.getByIndex(valueCollection.get(i - 1), coordIndex);
            p1 = this.getByIndex(valueCollection.get(i + 1), coordIndex);
            delta[i] = (3.0 * (p1 - p0) - delta[i - 1]) * gamma[i];
        }
        p0 = this.getByIndex(valueCollection.get(num - 1), coordIndex);
        p1 = this.getByIndex(valueCollection.get(num), coordIndex);
        delta[num] = (3.0 * (p1 - p0) - delta[num - 1]) * gamma[num];
        D[num] = delta[num];
        for (i = num - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        cubicCollection.clear();
        for (i = 0; i < num; ++i) {
            p0 = this.getByIndex(valueCollection.get(i), coordIndex);
            p1 = this.getByIndex(valueCollection.get(i + 1), coordIndex);
            cubicCollection.add(new Cubic(p0, D[i], 3.0 * (p1 - p0) - 2.0 * D[i] - D[i + 1], 2.0 * (p0 - p1) + D[i] + D[i + 1]));
        }
    }

    private double getByIndex(Object o, int index) {
        Vector3d v = (Vector3d)o;
        switch (index) {
            case 0: {
                return v.x();
            }
            case 1: {
                return v.y();
            }
            case 2: {
                return v.z();
            }
        }
        throw new RuntimeException("Illegal index specified: " + index);
    }

    static class Cubic {
        private final double a;
        private final double b;
        private final double c;
        private final double d;

        public Cubic(double a, double b, double c, double d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public double eval(double u) {
            return ((this.d * u + this.c) * u + this.b) * u + this.a;
        }
    }
}

