/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vvecmath;

import eu.mihosoft.vvecmath.Matrix4d;
import eu.mihosoft.vvecmath.ModifiableVector3d;
import eu.mihosoft.vvecmath.Plane;
import eu.mihosoft.vvecmath.Vector3d;

public class Transform {
    private final Matrix4d m;

    public Transform() {
        this.m = new Matrix4d();
        this.m.m00 = 1.0;
        this.m.m11 = 1.0;
        this.m.m22 = 1.0;
        this.m.m33 = 1.0;
    }

    public static Transform unity() {
        return new Transform();
    }

    private Transform(Matrix4d m) {
        this.m = m;
    }

    public Transform rotX(double degrees) {
        double radians = degrees * Math.PI * 0.005555555555555556;
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double[] elemenents = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, cos, sin, 0.0, 0.0, -sin, cos, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.m.mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform rotY(double degrees) {
        double radians = degrees * Math.PI * 0.005555555555555556;
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double[] elemenents = new double[]{cos, 0.0, -sin, 0.0, 0.0, 1.0, 0.0, 0.0, sin, 0.0, cos, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.m.mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform rotZ(double degrees) {
        double radians = degrees * Math.PI * 0.005555555555555556;
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double[] elemenents = new double[]{cos, sin, 0.0, 0.0, -sin, cos, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.m.mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform rot(double x, double y, double z) {
        return this.rotX(x).rotY(y).rotZ(z);
    }

    public Transform rot(Vector3d vec) {
        return this.rotX(vec.x()).rotY(vec.y()).rotZ(vec.z());
    }

    public Transform rot(Vector3d from, Vector3d to) {
        Vector3d b;
        Vector3d a = from.normalized();
        Vector3d c = a.cross(b = to.normalized());
        double l = c.magnitude();
        if (l > 1.0E-9) {
            Vector3d axis = c.normalized();
            double angle = a.angle(b);
            this.rot(Vector3d.ZERO, axis, angle);
        }
        return this;
    }

    public Transform rot(Vector3d axisPos, Vector3d axisDir, double degrees) {
        Transform tmp = Transform.unity();
        axisDir = axisDir.normalized();
        Vector3d dir2 = axisDir.times(axisDir);
        double posx = axisPos.x();
        double posy = axisPos.y();
        double posz = axisPos.z();
        double dirx = axisDir.x();
        double diry = axisDir.y();
        double dirz = axisDir.z();
        double dirxSquare = dir2.x();
        double dirySquare = dir2.y();
        double dirzSquare = dir2.z();
        double radians = degrees * Math.PI * 0.005555555555555556;
        double cosOfAngle = Math.cos(radians);
        double oneMinusCosOfangle = 1.0 - cosOfAngle;
        double sinOfangle = Math.sin(radians);
        tmp.m.m00 = dirxSquare + (dirySquare + dirzSquare) * cosOfAngle;
        tmp.m.m01 = dirx * diry * oneMinusCosOfangle - dirz * sinOfangle;
        tmp.m.m02 = dirx * dirz * oneMinusCosOfangle + diry * sinOfangle;
        tmp.m.m03 = (posx * (dirySquare + dirzSquare) - dirx * (posy * diry + posz * dirz)) * oneMinusCosOfangle + (posy * dirz - posz * diry) * sinOfangle;
        tmp.m.m10 = dirx * diry * oneMinusCosOfangle + dirz * sinOfangle;
        tmp.m.m11 = dirySquare + (dirxSquare + dirzSquare) * cosOfAngle;
        tmp.m.m12 = diry * dirz * oneMinusCosOfangle - dirx * sinOfangle;
        tmp.m.m13 = (posy * (dirxSquare + dirzSquare) - diry * (posx * dirx + posz * dirz)) * oneMinusCosOfangle + (posz * dirx - posx * dirz) * sinOfangle;
        tmp.m.m20 = dirx * dirz * oneMinusCosOfangle - diry * sinOfangle;
        tmp.m.m21 = diry * dirz * oneMinusCosOfangle + dirx * sinOfangle;
        tmp.m.m22 = dirzSquare + (dirxSquare + dirySquare) * cosOfAngle;
        tmp.m.m23 = (posz * (dirxSquare + dirySquare) - dirz * (posx * dirx + posy * diry)) * oneMinusCosOfangle + (posx * diry - posy * dirx) * sinOfangle;
        this.apply(tmp);
        return this;
    }

    public Transform translate(Vector3d vec) {
        return this.translate(vec.x(), vec.y(), vec.z());
    }

    public Transform translate(double x, double y, double z) {
        double[] elemenents = new double[]{1.0, 0.0, 0.0, x, 0.0, 1.0, 0.0, y, 0.0, 0.0, 1.0, z, 0.0, 0.0, 0.0, 1.0};
        this.m.mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform translateX(double value) {
        double[] elemenents = new double[]{1.0, 0.0, 0.0, value, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.m.mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform translateY(double value) {
        double[] elemenents = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, value, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.m.mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform translateZ(double value) {
        double[] elemenents = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, value, 0.0, 0.0, 0.0, 1.0};
        this.m.mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform mirror(Plane plane) {
        System.err.println("WARNING: I'm too dumb to implement the mirror() operation correctly. Please fix me!");
        double nx = plane.normal.x();
        double ny = plane.normal.y();
        double nz = plane.normal.z();
        double w = plane.getDist();
        double[] elemenents = new double[]{1.0 - 2.0 * nx * nx, -2.0 * ny * nx, -2.0 * nz * nx, 0.0, -2.0 * nx * ny, 1.0 - 2.0 * ny * ny, -2.0 * nz * ny, 0.0, -2.0 * nx * nz, -2.0 * ny * nz, 1.0 - 2.0 * nz * nz, 0.0, -2.0 * nx * w, -2.0 * ny * w, -2.0 * nz * w, 1.0};
        this.m.mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform scale(Vector3d vec) {
        if (vec.x() == 0.0 || vec.y() == 0.0 || vec.z() == 0.0) {
            throw new IllegalArgumentException("scale by 0 not allowed!");
        }
        double[] elemenents = new double[]{vec.x(), 0.0, 0.0, 0.0, 0.0, vec.y(), 0.0, 0.0, 0.0, 0.0, vec.z(), 0.0, 0.0, 0.0, 0.0, 1.0};
        this.m.mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform scale(double x, double y, double z) {
        if (x == 0.0 || y == 0.0 || z == 0.0) {
            throw new IllegalArgumentException("scale by 0 not allowed!");
        }
        double[] elemenents = new double[]{x, 0.0, 0.0, 0.0, 0.0, y, 0.0, 0.0, 0.0, 0.0, z, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.m.mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform scale(double s) {
        if (s == 0.0) {
            throw new IllegalArgumentException("scale by 0 not allowed!");
        }
        double[] elemenents = new double[]{s, 0.0, 0.0, 0.0, 0.0, s, 0.0, 0.0, 0.0, 0.0, s, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.m.mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform scaleX(double s) {
        if (s == 0.0) {
            throw new IllegalArgumentException("scale by 0 not allowed!");
        }
        double[] elemenents = new double[]{s, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.m.mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform scaleY(double s) {
        if (s == 0.0) {
            throw new IllegalArgumentException("scale by 0 not allowed!");
        }
        double[] elemenents = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, s, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.m.mul(new Matrix4d(elemenents));
        return this;
    }

    public Transform scaleZ(double s) {
        if (s == 0.0) {
            throw new IllegalArgumentException("scale by 0 not allowed!");
        }
        double[] elemenents = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, s, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.m.mul(new Matrix4d(elemenents));
        return this;
    }

    public ModifiableVector3d transform(ModifiableVector3d vec) {
        double x = this.m.m00 * vec.x() + this.m.m01 * vec.y() + this.m.m02 * vec.z() + this.m.m03;
        double y = this.m.m10 * vec.x() + this.m.m11 * vec.y() + this.m.m12 * vec.z() + this.m.m13;
        vec.setZ(this.m.m20 * vec.x() + this.m.m21 * vec.y() + this.m.m22 * vec.z() + this.m.m23);
        vec.setX(x);
        vec.setY(y);
        return vec;
    }

    public Vector3d transform(Vector3d vec) {
        ModifiableVector3d result = vec.asModifiable();
        double x = this.m.m00 * vec.x() + this.m.m01 * vec.y() + this.m.m02 * vec.z() + this.m.m03;
        double y = this.m.m10 * vec.x() + this.m.m11 * vec.y() + this.m.m12 * vec.z() + this.m.m13;
        result.setZ(this.m.m20 * vec.x() + this.m.m21 * vec.y() + this.m.m22 * vec.z() + this.m.m23);
        result.setX(x);
        result.setY(y);
        return vec;
    }

    public ModifiableVector3d transform(ModifiableVector3d vec, double amount) {
        double prevX = vec.x();
        double prevY = vec.y();
        double prevZ = vec.z();
        double x = this.m.m00 * vec.x() + this.m.m01 * vec.y() + this.m.m02 * vec.z() + this.m.m03;
        double y = this.m.m10 * vec.x() + this.m.m11 * vec.y() + this.m.m12 * vec.z() + this.m.m13;
        vec.setZ(this.m.m20 * vec.x() + this.m.m21 * vec.y() + this.m.m22 * vec.z() + this.m.m23);
        vec.setX(x);
        vec.setY(y);
        double diffX = vec.x() - prevX;
        double diffY = vec.y() - prevY;
        double diffZ = vec.z() - prevZ;
        vec.setX(prevX + diffX * amount);
        vec.setY(prevY + diffY * amount);
        vec.setZ(prevZ + diffZ * amount);
        return vec;
    }

    public boolean isMirror() {
        return this.m.determinant() < 0.0;
    }

    public Transform apply(Transform t) {
        this.m.mul(t.m);
        return this;
    }

    public String toString() {
        return this.m.toString();
    }
}

