/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vvecmath;

import eu.mihosoft.vvecmath.ModifiableVector3d;
import eu.mihosoft.vvecmath.Transform;
import eu.mihosoft.vvecmath.Vector3d;
import java.util.Random;

class Vector3dImpl
implements Vector3d {
    protected double x;
    protected double y;
    protected double z;

    public Vector3dImpl(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3dImpl(double x, double y) {
        this.x = x;
        this.y = y;
        this.z = 0.0;
    }

    @Override
    public Vector3d clone() {
        return new Vector3dImpl(this.x, this.y, this.z);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double[] get() {
        return new double[]{this.x, this.y, this.z};
    }

    @Override
    public double get(int i) {
        return this.get()[i];
    }

    Vector3d set(double ... xyz) {
        for (int i = 0; i < xyz.length; ++i) {
            this.set(i, xyz[i]);
        }
        return this;
    }

    void setX(double x) {
        this.x = x;
    }

    void setY(double y) {
        this.y = y;
    }

    void setZ(double z) {
        this.z = z;
    }

    Vector3d set(int i, double value) {
        switch (i) {
            case 0: {
                this.setX(value);
                break;
            }
            case 1: {
                this.setY(value);
                break;
            }
            case 2: {
                this.setZ(value);
            }
            default: {
                throw new RuntimeException("Illegal index: " + i);
            }
        }
        return this;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double z() {
        return this.z;
    }

    @Override
    public Vector3d negated() {
        return new Vector3dImpl(-this.x, -this.y, -this.z);
    }

    @Override
    public Vector3d plus(Vector3d v) {
        return new Vector3dImpl(this.x + v.x(), this.y + v.y(), this.z + v.z());
    }

    @Override
    public Vector3d minus(Vector3d v) {
        return new Vector3dImpl(this.x - v.x(), this.y - v.y(), this.z - v.z());
    }

    @Override
    public Vector3d times(double a) {
        return new Vector3dImpl(this.x * a, this.y * a, this.z * a);
    }

    @Override
    public Vector3d times(Vector3d a) {
        return new Vector3dImpl(this.x * a.x(), this.y * a.y(), this.z * a.z());
    }

    @Override
    public Vector3d dividedBy(double a) {
        return new Vector3dImpl(this.x / a, this.y / a, this.z / a);
    }

    @Override
    public double dot(Vector3d a) {
        return this.x * a.x() + this.y * a.y() + this.z * a.z();
    }

    @Override
    public Vector3d lerp(Vector3d a, double t) {
        return this.plus(a.minus(this).times(t));
    }

    @Override
    public double magnitude() {
        return Math.sqrt(this.dot(this));
    }

    @Override
    public Vector3d normalized() {
        return this.dividedBy(this.magnitude());
    }

    @Override
    public Vector3d cross(Vector3d a) {
        return new Vector3dImpl(this.y * a.z() - this.z * a.y(), this.z * a.x() - this.x * a.z(), this.x * a.y() - this.y * a.x());
    }

    @Override
    public String toStlString() {
        return this.toStlString(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder toStlString(StringBuilder sb) {
        return sb.append(this.x).append(" ").append(this.y).append(" ").append(this.z);
    }

    @Override
    public String toObjString() {
        return this.toObjString(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder toObjString(StringBuilder sb) {
        return sb.append(this.x).append(" ").append(this.y).append(" ").append(this.z);
    }

    @Override
    public Vector3d transformed(Transform transform, double amount) {
        return transform.transform(this.asModifiable(), amount);
    }

    @Override
    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3d other = (Vector3d)obj;
        if (Math.abs(this.x - other.x()) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.y - other.y()) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(this.z - other.z()) > 1.0E-12);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return hash;
    }

    @Override
    public double angle(Vector3d v) {
        double val = this.dot(v) / (this.magnitude() * v.magnitude());
        return Math.acos(Math.max(Math.min(val, 1.0), -1.0)) * 180.0 / Math.PI;
    }

    @Override
    public Vector3d orthogonal() {
        double o1 = 0.0;
        double o2 = 0.0;
        double o3 = 0.0;
        Random r = new Random();
        int numberOfZeroEntries = 0;
        if (this.x == 0.0) {
            ++numberOfZeroEntries;
            o1 = r.nextDouble();
        }
        if (this.y == 0.0) {
            ++numberOfZeroEntries;
            o2 = r.nextDouble();
        }
        if (this.z == 0.0) {
            ++numberOfZeroEntries;
            o3 = r.nextDouble();
        }
        switch (numberOfZeroEntries) {
            case 0: {
                while (o3 == 0.0) {
                    o3 = r.nextDouble();
                }
                while (o2 == 0.0) {
                    o2 = r.nextDouble();
                }
                o1 = (-this.y * o2 - this.z * o3) / this.x;
                break;
            }
            case 1: {
                if (this.x == 0.0) {
                    while (o3 == 0.0) {
                        o3 = r.nextDouble();
                    }
                    o2 = -this.z * o3 / this.y;
                    break;
                }
                if (this.y == 0.0) {
                    while (o3 == 0.0) {
                        o3 = r.nextDouble();
                    }
                    o1 = -this.z * o3 / this.x;
                    break;
                }
                if (this.z != 0.0) break;
                while (o1 == 0.0) {
                    o1 = r.nextDouble();
                }
                o2 = -this.z * o1 / this.y;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                System.err.println("This vector is equal to (0,0,0). ");
            }
            default: {
                System.err.println("The orthogonal one is set randomly.");
                o1 = r.nextDouble();
                o2 = r.nextDouble();
                o3 = r.nextDouble();
            }
        }
        Vector3d result = new Vector3dImpl(o1, o2, o3);
        while (this.dot(result) != 0.0) {
            result = this.orthogonal();
        }
        return result;
    }

    @Override
    public ModifiableVector3d asModifiable() {
        return new ModifiableVector3d(this.x, this.y, this.z);
    }

    @Override
    public Vector3d transformed(Transform transform) {
        return transform.transform(this.asModifiable());
    }
}

