/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.timing;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;
import org.apache.batik.anim.AnimationException;
import org.apache.batik.anim.timing.EventLikeTimingSpecifier;
import org.apache.batik.anim.timing.InstanceTime;
import org.apache.batik.anim.timing.Interval;
import org.apache.batik.anim.timing.TimeContainer;
import org.apache.batik.anim.timing.TimedDocumentRoot;
import org.apache.batik.anim.timing.TimingSpecifier;
import org.apache.batik.anim.timing.TimingSpecifierListProducer;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.parser.ClockHandler;
import org.apache.batik.parser.ClockParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.util.SMILConstants;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public abstract class TimedElement
implements SMILConstants {
    public static final int FILL_REMOVE = 0;
    public static final int FILL_FREEZE = 1;
    public static final int RESTART_ALWAYS = 0;
    public static final int RESTART_WHEN_NOT_ACTIVE = 1;
    public static final int RESTART_NEVER = 2;
    public static final float INDEFINITE = Float.POSITIVE_INFINITY;
    public static final float UNRESOLVED = Float.NaN;
    protected TimedDocumentRoot root;
    protected TimeContainer parent;
    protected TimingSpecifier[] beginTimes;
    protected TimingSpecifier[] endTimes;
    protected float simpleDur;
    protected boolean durMedia;
    protected float repeatCount;
    protected float repeatDur;
    protected int currentRepeatIteration;
    protected float lastRepeatTime;
    protected int fillMode;
    protected int restartMode;
    protected float min;
    protected boolean minMedia;
    protected float max;
    protected boolean maxMedia;
    protected boolean isActive;
    protected boolean isFrozen;
    protected float lastSampleTime;
    protected Vector beginInstanceTimes = new Vector();
    protected Vector endInstanceTimes = new Vector();
    protected Interval currentInterval;
    protected float lastIntervalEnd;
    protected LinkedList previousIntervals = new LinkedList();
    protected LinkedList beginDependents = new LinkedList();
    protected LinkedList endDependents = new LinkedList();
    protected boolean shouldUpdateCurrentInterval = true;
    protected boolean hasParsed;
    protected HashMap handledEvents = new HashMap();
    protected static final String RESOURCES = "org.apache.batik.anim.resources.Messages";
    protected static LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.anim.resources.Messages", (class$org$apache$batik$anim$timing$TimedElement == null ? (class$org$apache$batik$anim$timing$TimedElement = TimedElement.class$("org.apache.batik.anim.timing.TimedElement")) : class$org$apache$batik$anim$timing$TimedElement).getClassLoader());
    static /* synthetic */ Class class$org$apache$batik$anim$timing$TimedElement;

    public TimedElement() {
        this.beginTimes = new TimingSpecifier[0];
        this.endTimes = this.beginTimes;
        this.simpleDur = Float.NaN;
        this.repeatCount = Float.NaN;
        this.repeatDur = Float.NaN;
        this.lastRepeatTime = Float.NaN;
        this.max = Float.POSITIVE_INFINITY;
        this.lastSampleTime = Float.NaN;
        this.lastIntervalEnd = Float.NEGATIVE_INFINITY;
    }

    public TimedDocumentRoot getRoot() {
        return this.root;
    }

    public float getActiveTime() {
        return this.lastSampleTime;
    }

    public float getSimpleTime() {
        return this.lastSampleTime - this.lastRepeatTime;
    }

    protected void addInstanceTime(InstanceTime instanceTime, boolean bl) {
        Vector vector = bl ? this.beginInstanceTimes : this.endInstanceTimes;
        int n = Collections.binarySearch(vector, instanceTime);
        if (n < 0) {
            n = -(n + 1);
        }
        vector.insertElementAt(instanceTime, n);
        this.shouldUpdateCurrentInterval = true;
    }

    protected void removeInstanceTime(InstanceTime instanceTime, boolean bl) {
        int n;
        int n2;
        Vector vector = bl ? this.beginInstanceTimes : this.endInstanceTimes;
        for (n2 = n = Collections.binarySearch(vector, instanceTime); n2 >= 0; --n2) {
            InstanceTime instanceTime2 = (InstanceTime)vector.get(n2);
            if (instanceTime2 == instanceTime) {
                vector.remove(n2);
                return;
            }
            if (instanceTime2.compareTo(instanceTime) != 0) break;
        }
        n2 = vector.size();
        for (int i = n + 1; i < n2; ++i) {
            InstanceTime instanceTime3 = (InstanceTime)vector.get(i);
            if (instanceTime3 == instanceTime) {
                vector.remove(i);
                return;
            }
            if (instanceTime3.compareTo(instanceTime) != 0) break;
        }
        this.shouldUpdateCurrentInterval = true;
    }

    protected void instanceTimeChanged(InstanceTime instanceTime, boolean bl) {
        this.shouldUpdateCurrentInterval = true;
    }

    protected void addDependent(TimingSpecifier timingSpecifier, boolean bl) {
        if (bl) {
            this.beginDependents.add(timingSpecifier);
        } else {
            this.endDependents.add(timingSpecifier);
        }
    }

    protected void removeDependent(TimingSpecifier timingSpecifier, boolean bl) {
        if (bl) {
            this.beginDependents.remove(timingSpecifier);
        } else {
            this.endDependents.remove(timingSpecifier);
        }
    }

    public float getSimpleDur() {
        if (this.durMedia) {
            return this.getImplicitDur();
        }
        if (TimedElement.isUnresolved(this.simpleDur)) {
            if (TimedElement.isUnresolved(this.repeatCount) && TimedElement.isUnresolved(this.repeatDur) && this.endTimes.length > 0) {
                return Float.POSITIVE_INFINITY;
            }
            return this.getImplicitDur();
        }
        return this.simpleDur;
    }

    public static boolean isUnresolved(float f) {
        return Float.isNaN(f);
    }

    public float getActiveDur(float f, float f2) {
        float f3;
        float f4 = this.getSimpleDur();
        if (!TimedElement.isUnresolved(f2) && f4 == Float.POSITIVE_INFINITY) {
            f3 = this.minusTime(f2, f);
        } else {
            float f5;
            if (f4 == 0.0f) {
                f5 = 0.0f;
            } else if (TimedElement.isUnresolved(this.repeatDur) && TimedElement.isUnresolved(this.repeatCount)) {
                f5 = f4;
            } else {
                float f6 = TimedElement.isUnresolved(this.repeatCount) ? Float.POSITIVE_INFINITY : this.multiplyTime(f4, this.repeatCount);
                float f7 = TimedElement.isUnresolved(this.repeatDur) ? Float.POSITIVE_INFINITY : this.repeatDur;
                f5 = this.minTime(this.minTime(f6, f7), Float.POSITIVE_INFINITY);
            }
            f3 = TimedElement.isUnresolved(f2) || f2 == Float.POSITIVE_INFINITY ? f5 : this.minTime(f5, this.minusTime(f2, f));
        }
        return this.minTime(this.max, this.maxTime(this.min, f3));
    }

    protected float minusTime(float f, float f2) {
        if (TimedElement.isUnresolved(f) || TimedElement.isUnresolved(f2)) {
            return Float.NaN;
        }
        if (f == Float.POSITIVE_INFINITY || f2 == Float.POSITIVE_INFINITY) {
            return Float.POSITIVE_INFINITY;
        }
        return f - f2;
    }

    protected float multiplyTime(float f, float f2) {
        if (TimedElement.isUnresolved(f) || f == Float.POSITIVE_INFINITY) {
            return f;
        }
        return f * f2;
    }

    protected float minTime(float f, float f2) {
        if (f == 0.0f || f2 == 0.0f) {
            return 0.0f;
        }
        if ((f == Float.POSITIVE_INFINITY || TimedElement.isUnresolved(f)) && f2 != Float.POSITIVE_INFINITY && !TimedElement.isUnresolved(f2)) {
            return f2;
        }
        if ((f2 == Float.POSITIVE_INFINITY || TimedElement.isUnresolved(f2)) && f != Float.POSITIVE_INFINITY && !TimedElement.isUnresolved(f)) {
            return f;
        }
        if (f == Float.POSITIVE_INFINITY && TimedElement.isUnresolved(f2) || TimedElement.isUnresolved(f) && f2 == Float.POSITIVE_INFINITY) {
            return Float.POSITIVE_INFINITY;
        }
        if (f < f2) {
            return f;
        }
        return f2;
    }

    protected float maxTime(float f, float f2) {
        if ((f == Float.POSITIVE_INFINITY || TimedElement.isUnresolved(f)) && f2 != Float.POSITIVE_INFINITY && !TimedElement.isUnresolved(f2)) {
            return f;
        }
        if ((f2 == Float.POSITIVE_INFINITY || TimedElement.isUnresolved(f2)) && f != Float.POSITIVE_INFINITY && !TimedElement.isUnresolved(f)) {
            return f2;
        }
        if (f == Float.POSITIVE_INFINITY && TimedElement.isUnresolved(f2) || TimedElement.isUnresolved(f) && f2 == Float.POSITIVE_INFINITY) {
            return Float.NaN;
        }
        if (f > f2) {
            return f;
        }
        return f2;
    }

    protected float getImplicitDur() {
        return 0.0f;
    }

    protected void notifyNewInterval(Interval interval) {
        TimingSpecifier timingSpecifier;
        Iterator iterator = this.beginDependents.iterator();
        while (iterator.hasNext()) {
            timingSpecifier = (TimingSpecifier)iterator.next();
            if (!this.root.shouldPropagate(interval, timingSpecifier, true)) continue;
            timingSpecifier.newInterval(interval);
        }
        iterator = this.endDependents.iterator();
        while (iterator.hasNext()) {
            timingSpecifier = (TimingSpecifier)iterator.next();
            if (!this.root.shouldPropagate(interval, timingSpecifier, false)) continue;
            timingSpecifier.newInterval(interval);
        }
    }

    protected void notifyRemoveInterval(Interval interval) {
        TimingSpecifier timingSpecifier;
        Iterator iterator = this.beginDependents.iterator();
        while (iterator.hasNext()) {
            timingSpecifier = (TimingSpecifier)iterator.next();
            timingSpecifier.removeInterval(interval);
        }
        iterator = this.endDependents.iterator();
        while (iterator.hasNext()) {
            timingSpecifier = (TimingSpecifier)iterator.next();
            timingSpecifier.removeInterval(interval);
        }
    }

    protected float sampleAt(float f, boolean bl) {
        boolean bl2;
        float f2;
        float f3 = f;
        Iterator iterator = this.handledEvents.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            boolean bl3;
            Map.Entry entry = iterator.next();
            Event event = (Event)entry.getKey();
            Set set = (Set)entry.getValue();
            Iterator iterator2 = set.iterator();
            boolean bl4 = false;
            boolean bl5 = false;
            while (!(!iterator2.hasNext() || bl4 && bl5)) {
                EventLikeTimingSpecifier eventLikeTimingSpecifier = (EventLikeTimingSpecifier)iterator2.next();
                if (eventLikeTimingSpecifier.isBegin()) {
                    bl4 = true;
                    continue;
                }
                bl5 = true;
            }
            if (bl4 && bl5) {
                bl3 = !this.isActive || this.restartMode == 0;
            } else if (bl4 && (!this.isActive || this.restartMode == 0)) {
                bl3 = true;
            } else {
                if (!bl5 || !this.isActive) continue;
                bl3 = false;
            }
            iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                EventLikeTimingSpecifier eventLikeTimingSpecifier = (EventLikeTimingSpecifier)iterator2.next();
                if (eventLikeTimingSpecifier.isBegin() != bl3) continue;
                eventLikeTimingSpecifier.resolve(event);
                continue block0;
            }
        }
        this.handledEvents.clear();
        if (this.currentInterval != null && this.lastSampleTime < (f2 = this.currentInterval.getBegin()) && f3 >= f2) {
            if (!this.isActive) {
                this.toActive(f2);
            }
            this.isActive = true;
            this.lastRepeatTime = f2;
            this.fireTimeEvent("beginEvent", this.currentInterval.getBegin(), 0);
        }
        boolean bl6 = this.isActive;
        boolean bl7 = bl2 = this.currentInterval != null && f3 > this.currentInterval.getEnd();
        if (this.currentInterval != null && f3 >= this.currentInterval.getBegin()) {
            float f4 = this.getSimpleDur();
            while (f3 - this.lastRepeatTime >= f4 && this.lastRepeatTime + f4 < this.currentInterval.getEnd()) {
                this.lastRepeatTime += f4;
                ++this.currentRepeatIteration;
                this.fireTimeEvent(this.root.getRepeatEventName(), this.lastRepeatTime, this.currentRepeatIteration);
            }
        }
        if (bl) {
            this.shouldUpdateCurrentInterval = true;
        }
        while (this.shouldUpdateCurrentInterval || bl2) {
            float f5;
            float f6;
            boolean bl8;
            if (bl2) {
                this.previousIntervals.add(this.currentInterval);
                this.isActive = false;
                this.isFrozen = false;
                this.fireTimeEvent("endEvent", this.currentInterval.getEnd(), 0);
            }
            boolean bl9 = bl8 = this.currentInterval == null && this.previousIntervals.isEmpty();
            if (this.currentInterval == null || bl2) {
                if (bl8 || bl || this.restartMode != 2) {
                    f6 = bl8 || bl ? Float.NEGATIVE_INFINITY : ((Interval)this.previousIntervals.getLast()).getEnd();
                    this.currentInterval = this.computeInterval(bl8, false, f6);
                    if (this.currentInterval != null) {
                        this.notifyNewInterval(this.currentInterval);
                        float f7 = this.currentInterval.getBegin();
                        if (f3 >= f7) {
                            this.lastRepeatTime = f7;
                            if (f7 < 0.0f) {
                                f7 = 0.0f;
                            }
                            this.isActive = true;
                            this.isFrozen = false;
                            this.fireTimeEvent("beginEvent", f7, 0);
                            float f8 = this.getSimpleDur();
                            f5 = this.currentInterval.getEnd();
                            while (f3 - this.lastRepeatTime >= f8 && this.lastRepeatTime + f8 < f5) {
                                this.lastRepeatTime += f8;
                                ++this.currentRepeatIteration;
                                this.fireTimeEvent(this.root.getRepeatEventName(), this.lastRepeatTime, this.currentRepeatIteration);
                            }
                        }
                    }
                }
            } else {
                f6 = this.currentInterval.getBegin();
                if (f6 > f3) {
                    float f9 = this.previousIntervals.isEmpty() ? Float.NEGATIVE_INFINITY : ((Interval)this.previousIntervals.getLast()).getEnd();
                    Interval interval = this.computeInterval(false, false, f9);
                    if (interval == null) {
                        this.notifyRemoveInterval(this.currentInterval);
                        this.currentInterval = null;
                    } else {
                        f5 = interval.getBegin();
                        float f10 = interval.getEnd();
                        if (f6 != f5) {
                            this.currentInterval.setBegin(f5);
                        }
                        if (this.currentInterval.getEnd() != f10) {
                            this.currentInterval.setEnd(f10);
                        }
                    }
                } else {
                    Interval interval = this.computeInterval(false, true, f6);
                    float f11 = interval.getEnd();
                    if (this.currentInterval.getEnd() != f11) {
                        this.currentInterval.setEnd(f11);
                    }
                }
            }
            this.shouldUpdateCurrentInterval = false;
            bl = false;
            bl2 = this.currentInterval != null && f3 >= this.currentInterval.getEnd();
        }
        if (!bl6 && this.isActive) {
            this.isFrozen = false;
            this.toActive(this.currentInterval.getBegin());
        } else if (bl6 && !this.isActive) {
            this.isFrozen = this.fillMode == 1;
            this.toInactive(this.isFrozen);
        }
        float f12 = this.getSimpleDur();
        if (this.isActive) {
            this.sampledAt(f3 - this.lastRepeatTime, f12, this.currentRepeatIteration);
        } else if (this.isFrozen) {
            Interval interval = (Interval)this.previousIntervals.getLast();
            float f13 = interval.getEnd() - this.lastRepeatTime;
            if (f13 % f12 == 0.0f) {
                this.sampledLastValue(this.currentRepeatIteration);
            } else {
                this.sampledAt(f13 % f12, f12, this.currentRepeatIteration);
            }
        }
        this.lastSampleTime = f3;
        if (this.currentInterval != null) {
            float f14 = this.currentInterval.getBegin() - f3;
            if (f14 > 0.0f) {
                return f14;
            }
            return this.isConstantAnimation() ? this.currentInterval.getEnd() - f3 : 0.0f;
        }
        return Float.POSITIVE_INFINITY;
    }

    protected boolean endHasEventConditions() {
        for (int i = 0; i < this.endTimes.length; ++i) {
            if (!this.endTimes[i].isEventCondition()) continue;
            return true;
        }
        return false;
    }

    protected Interval computeInterval(boolean bl, boolean bl2, float f) {
        Iterator iterator = this.beginInstanceTimes.iterator();
        Iterator iterator2 = this.endInstanceTimes.iterator();
        float f2 = this.parent.getSimpleDur();
        InstanceTime instanceTime = iterator2.hasNext() ? (InstanceTime)iterator2.next() : null;
        boolean bl3 = true;
        InstanceTime instanceTime2 = null;
        InstanceTime instanceTime3 = null;
        while (true) {
            float f3;
            float f4;
            float f5;
            if (bl2) {
                f5 = f;
                while (iterator.hasNext() && !((instanceTime3 = (InstanceTime)iterator.next()).getTime() > f5)) {
                }
            } else {
                do {
                    if (iterator.hasNext()) continue;
                    return null;
                } while (!((f5 = (instanceTime2 = (InstanceTime)iterator.next()).getTime()) >= f));
                if (iterator.hasNext()) {
                    instanceTime3 = (InstanceTime)iterator.next();
                }
            }
            if (f5 >= f2) {
                return null;
            }
            if (this.endTimes.length == 0) {
                f4 = f5 + this.getActiveDur(f5, Float.POSITIVE_INFINITY);
            } else {
                if (this.endInstanceTimes.isEmpty()) {
                    f4 = Float.NaN;
                } else {
                    f4 = instanceTime.getTime();
                    if (bl && !bl3 && f4 == f5 || !bl && this.currentInterval != null && f4 == this.currentInterval.getEnd()) {
                        do {
                            if (iterator2.hasNext()) continue;
                            if (this.endHasEventConditions()) {
                                f4 = Float.NaN;
                                break;
                            }
                            return null;
                        } while (!((f4 = (instanceTime = (InstanceTime)iterator2.next()).getTime()) > f5));
                    }
                    bl3 = false;
                    while (!(f4 >= f5)) {
                        if (!iterator2.hasNext()) {
                            if (this.endHasEventConditions()) {
                                f4 = Float.NaN;
                                break;
                            }
                            return null;
                        }
                        instanceTime = (InstanceTime)iterator2.next();
                        f4 = instanceTime.getTime();
                    }
                }
                f3 = this.getActiveDur(f5, f4);
                if (f5 + f3 < f4 || TimedElement.isUnresolved(f4)) {
                    f4 = f5 + f3;
                }
            }
            if (!bl || f4 > 0.0f || f5 == 0.0f && f4 == 0.0f || TimedElement.isUnresolved(f4)) {
                if (this.restartMode == 0 && instanceTime3 != null && ((f3 = instanceTime3.getTime()) < f4 || TimedElement.isUnresolved(f4))) {
                    f4 = f3;
                    instanceTime = instanceTime3;
                }
                return new Interval(f5, f4, instanceTime2, instanceTime);
            }
            if (bl2) {
                return null;
            }
            f = f4;
        }
    }

    protected void reset(boolean bl) {
        InstanceTime instanceTime;
        Iterator iterator = this.beginInstanceTimes.iterator();
        while (iterator.hasNext()) {
            instanceTime = (InstanceTime)iterator.next();
            if (!instanceTime.getClearOnReset() || !bl && this.currentInterval != null && this.currentInterval.getBeginInstanceTime() == instanceTime) continue;
            iterator.remove();
        }
        iterator = this.endInstanceTimes.iterator();
        while (iterator.hasNext()) {
            instanceTime = (InstanceTime)iterator.next();
            if (!instanceTime.getClearOnReset()) continue;
            iterator.remove();
        }
        if (this.isFrozen) {
            this.removeFill();
        }
        this.currentRepeatIteration = 0;
        this.lastRepeatTime = Float.NaN;
        this.isActive = false;
        this.isFrozen = false;
        this.lastSampleTime = Float.NaN;
    }

    public void parseAttributes(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        if (!this.hasParsed) {
            this.parseBegin(string);
            this.parseDur(string2);
            this.parseEnd(string3);
            this.parseMin(string4);
            this.parseMax(string5);
            this.parseRepeatCount(string6);
            this.parseRepeatDur(string7);
            this.parseFill(string8);
            this.parseRestart(string9);
            this.hasParsed = true;
        }
    }

    protected void parseBegin(String string) {
        try {
            if (string.length() == 0) {
                string = "0";
            }
            this.beginTimes = TimingSpecifierListProducer.parseTimingSpecifierList(this, true, string, this.root.useSVG11AccessKeys, this.root.useSVG12AccessKeys);
        }
        catch (ParseException parseException) {
            throw this.createException("attribute.malformed", new Object[]{null, "begin"});
        }
    }

    protected void parseDur(String string) {
        if (string.equals("media")) {
            this.durMedia = true;
            this.simpleDur = Float.NaN;
        } else {
            this.durMedia = false;
            if (string.length() == 0 || string.equals("indefinite")) {
                this.simpleDur = Float.POSITIVE_INFINITY;
            } else {
                try {
                    this.simpleDur = this.parseClockValue(string);
                }
                catch (ParseException parseException) {
                    throw this.createException("attribute.malformed", new Object[]{null, "dur"});
                }
                if (this.simpleDur < 0.0f) {
                    this.simpleDur = Float.POSITIVE_INFINITY;
                }
            }
        }
    }

    protected float parseClockValue(String string) throws ParseException {
        ClockParser clockParser = new ClockParser();
        class Handler
        implements ClockHandler {
            protected float v = 0.0f;

            Handler() {
            }

            public void clockValue(float f) {
                this.v = f;
            }
        }
        Handler handler = new Handler();
        clockParser.setClockHandler(handler);
        clockParser.parse(string);
        return handler.v;
    }

    protected void parseEnd(String string) {
        try {
            this.endTimes = TimingSpecifierListProducer.parseTimingSpecifierList(this, false, string, this.root.useSVG11AccessKeys, this.root.useSVG12AccessKeys);
        }
        catch (ParseException parseException) {
            throw this.createException("attribute.malformed", new Object[]{null, "end"});
        }
    }

    protected void parseMin(String string) {
        if (string.equals("media")) {
            this.minMedia = true;
        } else {
            this.minMedia = false;
            if (string.length() == 0) {
                this.min = 0.0f;
            } else {
                try {
                    this.min = this.parseClockValue(string);
                }
                catch (ParseException parseException) {
                    throw this.createException("attribute.malformed", new Object[]{null, "min"});
                }
                if (this.min < 0.0f) {
                    this.min = 0.0f;
                }
            }
        }
    }

    protected void parseMax(String string) {
        if (string.equals("media")) {
            this.maxMedia = true;
        } else {
            this.maxMedia = false;
            if (string.length() == 0 || string.equals("indefinite")) {
                this.max = Float.POSITIVE_INFINITY;
            } else {
                try {
                    this.max = this.parseClockValue(string);
                }
                catch (ParseException parseException) {
                    throw this.createException("attribute.malformed", new Object[]{null, "max"});
                }
                if (this.max < 0.0f) {
                    this.max = 0.0f;
                }
            }
        }
    }

    protected void parseRepeatCount(String string) {
        if (string.length() == 0) {
            this.repeatCount = Float.NaN;
        } else if (string.equals("indefinite")) {
            this.repeatCount = Float.POSITIVE_INFINITY;
        } else {
            try {
                this.repeatCount = Float.parseFloat(string);
                if (this.repeatCount > 0.0f) {
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw this.createException("attribute.malformed", new Object[]{null, "repeatCount"});
            }
        }
    }

    protected void parseRepeatDur(String string) {
        try {
            this.repeatDur = string.length() == 0 ? Float.NaN : (string.equals("indefinite") ? Float.POSITIVE_INFINITY : this.parseClockValue(string));
        }
        catch (ParseException parseException) {
            throw this.createException("attribute.malformed", new Object[]{null, "repeatDur"});
        }
    }

    protected void parseFill(String string) {
        if (string.length() == 0 || string.equals("remove")) {
            this.fillMode = 0;
        } else if (string.equals("freeze")) {
            this.fillMode = 1;
        } else {
            throw this.createException("attribute.malformed", new Object[]{null, "fill"});
        }
    }

    protected void parseRestart(String string) {
        if (string.length() == 0 || string.equals("always")) {
            this.restartMode = 0;
        } else if (string.equals("whenNotActive")) {
            this.restartMode = 1;
        } else if (string.equals("never")) {
            this.restartMode = 2;
        } else {
            throw this.createException("attribute.malformed", new Object[]{null, "restart"});
        }
    }

    public void initialize() {
        int n;
        for (n = 0; n < this.beginTimes.length; ++n) {
            this.beginTimes[n].initialize();
        }
        for (n = 0; n < this.endTimes.length; ++n) {
            this.endTimes[n].initialize();
        }
    }

    public void deinitialize() {
        int n;
        for (n = 0; n < this.beginTimes.length; ++n) {
            this.beginTimes[n].deinitialize();
        }
        for (n = 0; n < this.endTimes.length; ++n) {
            this.beginTimes[n].deinitialize();
        }
    }

    public void beginElement() {
        this.beginElement(0.0f);
    }

    public void beginElement(float f) {
        float f2 = this.root.convertWallclockTime(Calendar.getInstance());
        InstanceTime instanceTime = new InstanceTime(null, f2 + f, null, true);
        this.addInstanceTime(instanceTime, true);
    }

    public void endElement() {
        this.endElement(0.0f);
    }

    public void endElement(float f) {
        float f2 = this.root.convertWallclockTime(Calendar.getInstance());
        InstanceTime instanceTime = new InstanceTime(null, f2 + f, null, true);
        this.addInstanceTime(instanceTime, false);
    }

    public float getLastSampleTime() {
        return this.lastSampleTime;
    }

    public float getCurrentBeginTime() {
        float f;
        block3: {
            block2: {
                float f2;
                if (this.currentInterval == null) break block2;
                f = this.currentInterval.getBegin();
                if (!(f2 < this.lastSampleTime)) break block3;
            }
            return Float.NaN;
        }
        return f;
    }

    public boolean canBegin() {
        return this.currentInterval == null || this.isActive && this.restartMode != 2;
    }

    public boolean canEnd() {
        return this.isActive;
    }

    protected void fireTimeEvent(String string, float f, int n) {
        Calendar calendar = (Calendar)this.root.getDocumentBeginTime().clone();
        calendar.add(14, (int)Math.round((double)f * 1000.0));
        this.fireTimeEvent(string, calendar, n);
    }

    void eventOccurred(TimingSpecifier timingSpecifier, Event event) {
        HashSet<TimingSpecifier> hashSet = (HashSet<TimingSpecifier>)this.handledEvents.get(event);
        if (hashSet == null) {
            hashSet = new HashSet<TimingSpecifier>();
            this.handledEvents.put(event, hashSet);
        }
        hashSet.add(timingSpecifier);
        this.root.currentIntervalWillUpdate();
    }

    protected abstract void fireTimeEvent(String var1, Calendar var2, int var3);

    protected abstract void toActive(float var1);

    protected abstract void toInactive(boolean var1);

    protected abstract void removeFill();

    protected abstract void sampledAt(float var1, float var2, int var3);

    protected abstract void sampledLastValue(int var1);

    protected abstract TimedElement getTimedElementById(String var1);

    protected abstract EventTarget getEventTargetById(String var1);

    protected abstract EventTarget getParentEventTarget(TimedElement var1);

    protected abstract EventTarget getRootEventTarget();

    public abstract Element getElement();

    public abstract boolean isBefore(TimedElement var1);

    protected abstract boolean isConstantAnimation();

    public AnimationException createException(String string, Object[] objectArray) {
        Element element = this.getElement();
        if (element != null) {
            objectArray[0] = element.getNodeName();
        }
        return new AnimationException(this, string, objectArray);
    }

    public static void setLocale(Locale locale) {
        localizableSupport.setLocale(locale);
    }

    public static Locale getLocale() {
        return localizableSupport.getLocale();
    }

    public static String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        return localizableSupport.formatMessage(string, objectArray);
    }

    public static String toString(float f) {
        if (Float.isNaN(f)) {
            return "UNRESOLVED";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "INDEFINITE";
        }
        return Float.toString(f);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

