/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGAnimatedValue;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedEnumeration;

public class SVGOMAnimatedEnumeration
extends AbstractSVGAnimatedValue
implements SVGAnimatedEnumeration {
    protected String[] values;
    protected short defaultValue;
    protected boolean valid;
    protected short baseVal;
    protected short animVal;
    protected boolean changing;

    public SVGOMAnimatedEnumeration(AbstractElement abstractElement, String string, String string2, String[] stringArray, short s) {
        super(abstractElement, string, string2);
        this.values = stringArray;
        this.defaultValue = s;
    }

    public short getBaseVal() {
        if (!this.valid) {
            this.update();
        }
        return this.baseVal;
    }

    public String getBaseValAsString() {
        if (!this.valid) {
            this.update();
        }
        return this.values[this.baseVal];
    }

    protected void update() {
        String string = this.element.getAttributeNS(this.namespaceURI, this.localName);
        this.baseVal = string.length() == 0 ? this.defaultValue : this.getEnumerationNumber(string);
        this.valid = true;
    }

    protected short getEnumerationNumber(String string) {
        for (short s = 0; s < this.values.length; s = (short)(s + 1)) {
            if (!string.equals(this.values[s])) continue;
            return s;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBaseVal(short s) throws DOMException {
        if (s >= 0 && s < this.values.length) {
            try {
                this.baseVal = s;
                this.valid = true;
                this.changing = true;
                this.element.setAttributeNS(this.namespaceURI, this.localName, this.values[s]);
            }
            finally {
                this.changing = false;
            }
        }
    }

    public short getAnimVal() {
        if (this.hasAnimVal) {
            return this.animVal;
        }
        if (!this.valid) {
            this.update();
        }
        return this.baseVal;
    }

    public void setAnimatedValue(short s) {
        this.hasAnimVal = true;
        this.animVal = s;
        this.fireAnimatedAttributeListeners();
    }

    public void setAnimatedValue(String string) {
        this.setAnimatedValue(this.getEnumerationNumber(string));
    }

    public void resetAnimatedValue() {
        this.hasAnimVal = false;
        this.fireAnimatedAttributeListeners();
    }

    public void attrAdded(Attr attr, String string) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr attr, String string) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }
}

