/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.ArrayList;
import java.util.Iterator;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;

public class DXFBlock {
    public static String TYPE = "BLOCK";
    private Point referencePoint;
    private String layerID = "0";
    private String name = "";
    private String description = "";
    private ArrayList entities = new ArrayList();
    private DXFDocument doc;

    public DXFBlock() {
        this.referencePoint = new Point();
    }

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        Iterator iterator = this.entities.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                DXFEntity dXFEntity = (DXFEntity)iterator.next();
                Bounds bounds2 = dXFEntity.getBounds();
                if (!bounds2.isValid()) continue;
                bounds.addToBounds(bounds2);
            }
        } else {
            bounds.setValid(false);
        }
        return bounds;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Point getReferencePoint() {
        return this.referencePoint;
    }

    public void setReferencePoint(Point point) {
        this.referencePoint = point;
    }

    public void addDXFEntity(DXFEntity dXFEntity) {
        this.entities.add(dXFEntity);
    }

    public Iterator getDXFEntitiesIterator() {
        return this.entities.iterator();
    }

    public String getLayerID() {
        return this.layerID;
    }

    public void setLayerID(String string) {
        this.layerID = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDXFDocument(DXFDocument dXFDocument) {
        this.doc = dXFDocument;
        Iterator iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            DXFEntity dXFEntity = (DXFEntity)iterator.next();
            dXFEntity.setDXFDocument(dXFDocument);
        }
    }

    public DXFDocument getDXFDocument() {
        return this.doc;
    }

    public double getLength() {
        double d = 0.0;
        Iterator iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            DXFEntity dXFEntity = (DXFEntity)iterator.next();
            d += dXFEntity.getLength();
        }
        return d;
    }

    public DXFEntity getDXFEntityByID(String string) {
        DXFEntity dXFEntity = null;
        Iterator iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            DXFEntity dXFEntity2 = (DXFEntity)iterator.next();
            if (!dXFEntity2.getID().equals(string)) continue;
            return dXFEntity2;
        }
        return dXFEntity;
    }
}

