/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLine;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFLineHandler
extends AbstractEntityHandler {
    public static final String ENTITY_NAME = "LINE";
    private DXFLine line;
    private DXFDocument doc;
    private String layerID = "";

    public String getDXFEntityName() {
        return ENTITY_NAME;
    }

    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 10: {
                this.line.getStartPoint().setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.line.getStartPoint().setY(dXFValue.getDoubleValue());
                break;
            }
            case 30: {
                this.line.getStartPoint().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 11: {
                this.line.getEndPoint().setX(dXFValue.getDoubleValue());
                break;
            }
            case 21: {
                this.line.getEndPoint().setY(dXFValue.getDoubleValue());
                break;
            }
            case 31: {
                this.line.getEndPoint().setZ(dXFValue.getDoubleValue());
            }
        }
        super.parseCommonProperty(n, dXFValue, this.line);
    }

    public DXFEntity getDXFEntity() {
        return this.line;
    }

    public void startDXFEntity() {
        this.line = new DXFLine();
        this.line.setStartPoint(new Point());
        this.line.setEndPoint(new Point());
    }

    public void endDXFEntity() {
    }

    public void setDXFDocument(DXFDocument dXFDocument) {
        this.doc = dXFDocument;
    }

    public boolean isFollowSequence() {
        return false;
    }
}

