/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.processing.AbstractPostProcessor;
import org.kabeja.processing.ProcessorException;
import org.kabeja.processing.scripting.ScriptEngine;
import org.kabeja.processing.scripting.ScriptException;
import org.kabeja.processing.scripting.impl.JavaScriptEngine;

public class ScriptablePostProcessor
extends AbstractPostProcessor {
    public static final String PROPERTY_SCRIPT_TYPE = "type";
    public static final String PROPERTY_SCRIPT_SRC = "src";
    public static final String PROPERTY_SCRIPT_INPUTSTREAM = "inputstream";
    protected ScriptEngine engine;
    protected InputStream scriptStream;

    public void process(DXFDocument doc, Map context) throws ProcessorException {
        JavaScriptEngine engine = new JavaScriptEngine();
        try {
            engine.eval(doc, this.scriptStream);
        }
        catch (ScriptException e) {
            throw new ProcessorException(e);
        }
    }

    public void setProperties(Map properties) {
        try {
            if (properties.containsKey(PROPERTY_SCRIPT_SRC)) {
                this.scriptStream = new FileInputStream((String)properties.get(PROPERTY_SCRIPT_SRC));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (properties.containsKey(PROPERTY_SCRIPT_INPUTSTREAM)) {
            this.scriptStream = (InputStream)properties.get(PROPERTY_SCRIPT_INPUTSTREAM);
        }
    }
}

