/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.parser.ParseException;
import org.kabeja.parser.Parser;
import org.kabeja.parser.ParserBuilder;
import org.kabeja.svg.SVGGenerator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class DXF2SVGReader
extends XMLFilterImpl {
    public static final String PROPERTY_DXF_ENCODING = "encoding";
    public static final String PROPERTY_PARSER_CONFIGURATION_FILENAME = "config-filename";
    public static final String PROPERTY_PARSER_CONFIGURATION_INPUTSTREAM = "config-inputstream";
    public static final String PROPERTY_SAX_XML_DOCUMENT_VERSION = "http://xml.org/sax/properties/document-xml-version";
    public static final String FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String FEATURE_NAMESPACES_PREFIX = "http://xml.org/sax/features/namespace-prefixes";
    public static final String FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    public static final String FEATURE_STRING_INTERNING = "http://xml.org/sax/features/string-interning";
    public static final String FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    public static final String FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    protected DTDHandler dtdhandler;
    protected EntityResolver resolver;
    protected InputSource source;
    protected ErrorHandler errorhandler;
    protected boolean namespaces = true;
    protected boolean namespacesPrefix = false;
    protected boolean stringInterning = false;
    protected boolean validation = false;
    protected boolean externalGeneralEntities = false;
    protected boolean externalParameterEntities = false;
    protected String encoding = null;
    protected String configURL;
    protected Parser parser = null;

    public void parse(String systemId) throws IOException, SAXException {
        this.initialize();
        try {
            this.parser.parse(systemId, this.encoding);
            DXFDocument doc = this.parser.getDocument();
            SVGGenerator generator = new SVGGenerator();
            generator.setProperties(new HashMap());
            generator.generate(doc, this.getContentHandler(), null);
            this.parser.releaseDXFDocument();
            doc = null;
        }
        catch (ParseException e) {
            this.errorhandler.error(new SAXParseException(e.getMessage(), null));
        }
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (FEATURE_NAMESPACES.equals(name)) {
            return this.namespaces;
        }
        if (FEATURE_NAMESPACES_PREFIX.equals(name)) {
            return this.namespacesPrefix;
        }
        if (FEATURE_VALIDATION.equals(name)) {
            return this.validation;
        }
        if (FEATURE_EXTERNAL_GENERAL_ENTITIES.equals(name)) {
            return this.externalGeneralEntities;
        }
        if (FEATURE_EXTERNAL_PARAMETER_ENTITIES.equals(name)) {
            return this.externalParameterEntities;
        }
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (FEATURE_NAMESPACES.equals(name)) {
            this.namespaces = value;
        } else if (FEATURE_NAMESPACES_PREFIX.equals(name)) {
            this.namespacesPrefix = value;
        } else if (FEATURE_VALIDATION.equals(name)) {
            this.validation = value;
        } else if (FEATURE_EXTERNAL_GENERAL_ENTITIES.equals(name)) {
            this.externalGeneralEntities = value;
        } else if (FEATURE_EXTERNAL_PARAMETER_ENTITIES.equals(name)) {
            this.externalParameterEntities = value;
        }
    }

    public ContentHandler getContentHandler() {
        return super.getContentHandler();
    }

    public void setContentHandler(ContentHandler handler) {
        super.setContentHandler(handler);
    }

    public DTDHandler getDTDHandler() {
        return this.dtdhandler;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdhandler = handler;
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorhandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorhandler = handler;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        this.initialize();
        try {
            String en = null;
            en = input.getEncoding() != null ? input.getEncoding() : this.encoding;
            this.parser.parse(input.getByteStream(), en);
            DXFDocument doc = this.parser.getDocument();
            SVGGenerator generator = new SVGGenerator();
            generator.setProperties(new HashMap());
            generator.generate(doc, this.getContentHandler(), null);
            this.parser.releaseDXFDocument();
            this.parser.releaseDXFDocument();
            Object var3_4 = null;
        }
        catch (ParseException e) {
            this.errorhandler.error(new SAXParseException(e.getMessage(), null));
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (PROPERTY_DXF_ENCODING.equals(name)) {
            return this.encoding;
        }
        if (PROPERTY_PARSER_CONFIGURATION_INPUTSTREAM.equals(name)) {
            return null;
        }
        if (PROPERTY_PARSER_CONFIGURATION_FILENAME.equals(name)) {
            return this.configURL;
        }
        if (PROPERTY_SAX_XML_DOCUMENT_VERSION.equals(name)) {
            return "1.0";
        }
        throw new SAXNotSupportedException("no feature: " + name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (PROPERTY_DXF_ENCODING.equals(name)) {
            this.encoding = (String)value;
        } else if (PROPERTY_PARSER_CONFIGURATION_INPUTSTREAM.equals(name)) {
            InputStream in = (InputStream)value;
            this.parser = ParserBuilder.buildFromXML(in);
        } else if (PROPERTY_PARSER_CONFIGURATION_FILENAME.equals(name)) {
            this.configURL = (String)value;
            this.parser = ParserBuilder.buildFromXML(this.configURL);
        }
    }

    protected void initialize() {
        if (this.parser == null) {
            this.parser = ParserBuilder.createDefaultParser();
        }
        if (this.encoding == null) {
            this.encoding = "";
        }
        if (!this.namespacesPrefix && !this.namespaces) {
            this.namespacesPrefix = true;
        }
        if (this.validation) {
            this.externalGeneralEntities = true;
            this.externalParameterEntities = true;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.namespacesPrefix) {
            AttributesImpl attributes = new AttributesImpl(atts);
            if (atts.getIndex("xmlns") == -1) {
                attributes.addAttribute("", "xmlns", "xmlns", "CDATA", "http://www.w3.org/2000/svg");
            }
            if (atts.getIndex("xmlns:xlink") == -1) {
                attributes.addAttribute("", "", "xmlns:xlink", "CDATA", "http://www.w3.org/1999/xlink");
            }
            super.startElement(uri, localName, qName, attributes);
        } else {
            super.startElement(uri, localName, qName, atts);
        }
    }
}

