/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.Map;
import org.kabeja.dxf.DXFColor;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLineType;
import org.kabeja.svg.SVGContext;
import org.kabeja.svg.SVGSAXGenerator;
import org.kabeja.svg.SVGUtils;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractSVGSAXGenerator
implements SVGSAXGenerator {
    public void setCommonAttributes(AttributesImpl atts, Map context, DXFEntity entity) {
        int color;
        if (!entity.isVisibile()) {
            SVGUtils.addAttribute(atts, "display", "none");
        }
        if ((color = entity.getColor()) != 0 && color != 256) {
            SVGUtils.addAttribute(atts, "color", "rgb(" + DXFColor.getRGBString(color) + ")");
            SVGUtils.addAttribute(atts, "stroke", "currentColor");
        }
        if (entity.getID().length() > 0) {
            SVGUtils.addAttribute(atts, "id", SVGUtils.validateID(entity.getID()));
        }
        if (entity.getLineWeight() > 0 && !context.containsKey(SVGContext.STROKE_WIDTH_IGNORE)) {
            SVGUtils.addAttribute(atts, "stroke-width", SVGUtils.lineWeightToStrokeWidth(entity.getLineWeight()));
        }
        DXFDocument doc = entity.getDXFDocument();
        double gscale = doc.getDXFHeader().getLinetypeScale();
        String lineType = entity.getLineType();
        if (!(lineType.length() <= 0 || "CONTINUOUS".equals(lineType) || "BYBLOCK".equals(lineType) || "BYLAYER".equals(lineType) || entity.isOmitLineType())) {
            DXFLineType ltype = doc.getDXFLineType(lineType);
            SVGUtils.addStrokeDashArrayAttribute(atts, ltype, gscale *= entity.getLinetypeScaleFactor());
        } else if (!entity.isOmitLineType()) {
            DXFLineType ltype = doc.getDXFLineType(doc.getDXFLayer(entity.getLayerName()).getLineType());
            if (ltype != null) {
                SVGUtils.addStrokeDashArrayAttribute(atts, ltype, entity.getLinetypeScaleFactor() * (gscale *= entity.getLinetypeScaleFactor()));
            } else if (entity.isOmitLineType()) {
                SVGUtils.addAttribute(atts, "stroke-dasharray", "");
            }
        }
    }
}

