/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.action;

import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.repository.ui.action.FileModelAction;
import de.miethxml.toolkit.repository.ui.action.RepositoryAction;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLFormatAction
implements RepositoryAction,
FileModelAction {
    public void doAction(String uri) {
        File f = new File(uri);
        if (f.exists()) {
            SAXBuilder builder = new SAXBuilder();
            builder.setValidation(false);
            Format format = null;
            XMLOutputter out = null;
            Document doc = null;
            try {
                doc = builder.build(f);
                format = Format.getPrettyFormat();
                out = new XMLOutputter(format);
                FileWriter writer = new FileWriter(f);
                out.output(doc, (Writer)writer);
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            builder = null;
            format = null;
            out = null;
            doc = null;
        }
    }

    public Icon getIcon() {
        return new ImageIcon("icons/indent.gif");
    }

    public boolean isSupported(String extention) {
        return true;
    }

    public boolean isHandleDirectory() {
        return false;
    }

    public boolean isHandleFile() {
        return true;
    }

    public String getToolTip(String lang) {
        return "XML Format";
    }

    public void doAction(FileModel model) {
        SAXBuilder builder = new SAXBuilder();
        Format format = null;
        XMLOutputter out = null;
        Document doc = null;
        BufferedInputStream in = null;
        FilterOutputStream writer = null;
        try {
            in = new BufferedInputStream(model.getContent().getInputStream());
            doc = builder.build((InputStream)in);
            format = Format.getPrettyFormat();
            out = new XMLOutputter(format);
            in.close();
            writer = new BufferedOutputStream(model.getContent().getOutputStream());
            out.output(doc, (OutputStream)writer);
            ((BufferedOutputStream)writer).flush();
            writer.close();
            in = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                in.close();
                writer.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), "Error", 2);
        }
        builder = null;
        format = null;
        out = null;
        doc = null;
        in = null;
        writer = null;
    }
}

