/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.ui.event;

import de.miethxml.toolkit.application.ApplicationShutdown;
import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.conf.LocaleListener;
import de.miethxml.toolkit.ui.ApplicationFrame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class DefaultApplicationShutdownAction
extends AbstractAction
implements Serviceable,
Initializable,
LocaleListener,
WindowListener {
    private ServiceManager manager;
    private ApplicationShutdown appShutdown;
    private ApplicationFrame frame;

    public DefaultApplicationShutdownAction() {
        super(LocaleImpl.getInstance().getString("menu.file.quit"), new ImageIcon("icons/exit.gif"));
        this.putValue("ShortDescription", LocaleImpl.getInstance().getString("menu.file.quit"));
        LocaleImpl.getInstance().addLocaleListener(this);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control Q"));
    }

    public DefaultApplicationShutdownAction(String name) {
        super(name);
    }

    public DefaultApplicationShutdownAction(String name, Icon icon) {
        super(name, icon);
    }

    public void actionPerformed(ActionEvent e) {
        this.shutdown();
    }

    public void initialize() {
        try {
            this.appShutdown = (ApplicationShutdown)this.manager.lookup(ApplicationShutdown.ROLE);
            this.frame = (ApplicationFrame)this.manager.lookup(ApplicationFrame.ROLE);
            this.frame.addWindowListener(this);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void langChanged() {
        this.putValue("ShortDescription", LocaleImpl.getInstance().getString("menu.file.quit"));
        this.putValue("Name", LocaleImpl.getInstance().getString("menu.file.quit"));
    }

    public void shutdown() {
        try {
            ApplicationShutdown app = (ApplicationShutdown)this.manager.lookup(ApplicationShutdown.ROLE);
            app.shutdownApplication();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.shutdown();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

