/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.Graphics2DImagePainter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.fop.render.pdf.PDFSVGHandler;
import org.apache.fop.svg.PDFGraphics2D;

public class PDFGraphics2DAdapter
implements Graphics2DAdapter {
    private PDFRenderer renderer;

    public PDFGraphics2DAdapter(PDFRenderer renderer) {
        this.renderer = renderer;
    }

    public void paintImage(Graphics2DImagePainter painter, RendererContext context, int x, int y, int width, int height) throws IOException {
        PDFSVGHandler.PDFInfo pdfInfo = PDFSVGHandler.getPDFInfo(context);
        float fwidth = (float)width / 1000.0f;
        float fheight = (float)height / 1000.0f;
        float fx = (float)x / 1000.0f;
        float fy = (float)y / 1000.0f;
        Dimension dim = painter.getImageSize();
        float imw = (float)dim.getWidth() / 1000.0f;
        float imh = (float)dim.getHeight() / 1000.0f;
        float sx = fwidth / imw;
        float sy = fheight / imh;
        this.renderer.saveGraphicsState();
        this.renderer.setColor(Color.black, false, null);
        this.renderer.setColor(Color.black, true, null);
        this.renderer.currentStream.add(sx + " 0 0 " + sy + " " + fx + " " + fy + " cm\n");
        boolean textAsShapes = false;
        PDFGraphics2D graphics = new PDFGraphics2D(false, pdfInfo.fi, pdfInfo.pdfDoc, pdfInfo.pdfContext, pdfInfo.pdfPage.referencePDF(), this.renderer.currentFontName, this.renderer.currentFontSize);
        graphics.setGraphicContext(new GraphicContext());
        AffineTransform transform = new AffineTransform();
        transform.translate(fx, fy);
        pdfInfo.pdfState.setTransform(transform);
        graphics.setPDFState(pdfInfo.pdfState);
        graphics.setOutputStream(pdfInfo.outputStream);
        Rectangle2D.Double area = new Rectangle2D.Double(0.0, 0.0, imw, imh);
        painter.paint((Graphics2D)((Object)graphics), (Rectangle2D)area);
        pdfInfo.currentStream.add(graphics.getString());
        this.renderer.restoreGraphicsState();
        pdfInfo.pdfState.pop();
    }
}

