/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.CursorManager;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGAElement;

public class SVGAElementBridge
extends SVGGElementBridge {
    protected AnchorListener al;
    protected CursorMouseOverListener bl;
    protected CursorMouseOutListener cl;

    public String getLocalName() {
        return "a";
    }

    public Bridge getInstance() {
        return new SVGAElementBridge();
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.buildGraphicsNode(bridgeContext, element, graphicsNode);
        if (bridgeContext.isInteractive()) {
            NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)element);
            this.al = new AnchorListener(bridgeContext.getUserAgent());
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.al, false, null);
            bridgeContext.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "click", this.al, false);
            this.bl = new CursorMouseOverListener(bridgeContext.getUserAgent());
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.bl, false, null);
            bridgeContext.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "mouseover", this.bl, false);
            this.cl = new CursorMouseOutListener(bridgeContext.getUserAgent());
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.cl, false, null);
            bridgeContext.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "mouseout", this.cl, false);
        }
    }

    public void dispose() {
        NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)this.e);
        if (this.al != null) {
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.al, false);
            this.al = null;
        }
        if (this.bl != null) {
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.bl, false);
            this.bl = null;
        }
        if (this.cl != null) {
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.cl, false);
            this.cl = null;
        }
        super.dispose();
    }

    public boolean isComposite() {
        return true;
    }

    public static class CursorMouseOutListener
    implements EventListener {
        protected UserAgent userAgent;

        public CursorMouseOutListener(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        public void handleEvent(Event event) {
            if (event.getDefaultPrevented()) {
                return;
            }
            SVGAElement sVGAElement = (SVGAElement)event.getCurrentTarget();
            if (sVGAElement != null) {
                this.userAgent.displayMessage("");
            }
        }
    }

    public static class CursorMouseOverListener
    implements EventListener {
        protected UserAgent userAgent;

        public CursorMouseOverListener(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        public void handleEvent(Event event) {
            SVGAElement sVGAElement;
            if (event.getDefaultPrevented()) {
                return;
            }
            Element element = (Element)((Object)event.getTarget());
            if (CSSUtilities.isAutoCursor(element)) {
                this.userAgent.setSVGCursor(CursorManager.ANCHOR_CURSOR);
            }
            if ((sVGAElement = (SVGAElement)event.getCurrentTarget()) != null) {
                String string = XLinkSupport.getXLinkHref((Element)sVGAElement);
                this.userAgent.displayMessage(string);
            }
        }
    }

    public static class AnchorListener
    implements EventListener {
        protected UserAgent userAgent;

        public AnchorListener(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        public void handleEvent(Event event) {
            if (event.getDefaultPrevented()) {
                return;
            }
            SVGAElement sVGAElement = (SVGAElement)event.getCurrentTarget();
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.userAgent.setSVGCursor(cursor);
            this.userAgent.openLink(sVGAElement);
            event.stopPropagation();
        }
    }
}

