/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.anim.values.AnimatableMotionPointValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.SVGExternalResourcesRequiredSupport;
import org.apache.batik.dom.svg.SVGLocatableSupport;
import org.apache.batik.dom.svg.SVGMotionAnimatableElement;
import org.apache.batik.dom.svg.SVGOMAttributeInfo;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGStylableElement;
import org.apache.batik.dom.svg.SVGTestsSupport;
import org.apache.batik.dom.svg.SVGTransformableSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedTransformList;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGStringList;

public abstract class SVGGraphicsElement
extends SVGStylableElement
implements SVGMotionAnimatableElement {
    private static final Map typeMap = new HashMap();
    protected AffineTransform motionTransform;

    protected SVGGraphicsElement() {
    }

    protected SVGGraphicsElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    public SVGElement getNearestViewportElement() {
        return SVGLocatableSupport.getNearestViewportElement(this);
    }

    public SVGElement getFarthestViewportElement() {
        return SVGLocatableSupport.getFarthestViewportElement(this);
    }

    public SVGRect getBBox() {
        return SVGLocatableSupport.getBBox(this);
    }

    public SVGMatrix getCTM() {
        return SVGLocatableSupport.getCTM(this);
    }

    public SVGMatrix getScreenCTM() {
        return SVGLocatableSupport.getScreenCTM(this);
    }

    public SVGMatrix getTransformToElement(SVGElement sVGElement) throws SVGException {
        return SVGLocatableSupport.getTransformToElement(this, sVGElement);
    }

    public SVGAnimatedTransformList getTransform() {
        return SVGTransformableSupport.getTransform(this);
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return SVGExternalResourcesRequiredSupport.getExternalResourcesRequired(this);
    }

    public String getXMLlang() {
        return XMLSupport.getXMLLang(this);
    }

    public void setXMLlang(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", string);
    }

    public String getXMLspace() {
        return XMLSupport.getXMLSpace(this);
    }

    public void setXMLspace(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", string);
    }

    public SVGStringList getRequiredFeatures() {
        return SVGTestsSupport.getRequiredFeatures(this);
    }

    public SVGStringList getRequiredExtensions() {
        return SVGTestsSupport.getRequiredExtensions(this);
    }

    public SVGStringList getSystemLanguage() {
        return SVGTestsSupport.getSystemLanguage(this);
    }

    public boolean hasExtension(String string) {
        return SVGTestsSupport.hasExtension(this, string);
    }

    public AffineTransform getMotionTransform() {
        return this.motionTransform;
    }

    public boolean isAttributeAnimatable(String string, String string2) {
        if (string == null && (string2.equals("externalResourcesRequired") || string2.equals("transform"))) {
            return true;
        }
        return super.isAttributeAnimatable(string, string2);
    }

    public int OLDgetAttributeType(String string, String string2) {
        if (string == null) {
            if (string2.equals("transform")) {
                return 9;
            }
            if (string2.equals("externalResourcesRequired")) {
                return 15;
            }
            if (string2.equals("requiredExtensions") || string2.equals("requiredFeatures")) {
                return 33;
            }
            if (string2.equals("systemLanguage")) {
                return 46;
            }
        }
        return super.getAttributeType(string, string2);
    }

    public int getAttributeType(String string, String string2) {
        SVGOMAttributeInfo sVGOMAttributeInfo;
        if (string == null && (sVGOMAttributeInfo = (SVGOMAttributeInfo)typeMap.get(string2)) != null) {
            return sVGOMAttributeInfo.getSVGType();
        }
        return super.getAttributeType(string, string2);
    }

    public void updateAttributeValue(String string, String string2, AnimatableValue animatableValue) {
        if (string == null) {
            if (string2.equals("externalResourcesRequired")) {
                this.updateBooleanAttributeValue(this.getExternalResourcesRequired(), animatableValue);
                return;
            }
            if (string2.equals("transform")) {
                this.updateTransformListAttributeValue(this.getTransform(), animatableValue);
                return;
            }
        }
        super.updateAttributeValue(string, string2, animatableValue);
    }

    public void updateOtherValue(String string, AnimatableValue animatableValue) {
        if (string.equals("motion")) {
            Object object;
            if (this.motionTransform == null) {
                this.motionTransform = new AffineTransform();
            }
            if (animatableValue == null) {
                this.motionTransform.setToIdentity();
            } else {
                object = (AnimatableMotionPointValue)animatableValue;
                this.motionTransform.setToTranslation(((AnimatableMotionPointValue)object).getX(), ((AnimatableMotionPointValue)object).getY());
                this.motionTransform.rotate(((AnimatableMotionPointValue)object).getAngle());
            }
            object = (SVGOMDocument)this.ownerDocument;
            ((SVGOMDocument)object).getAnimatedAttributeListener().otherAnimationChanged(this, string);
        } else {
            super.updateOtherValue(string, animatableValue);
        }
    }

    public AnimatableValue getUnderlyingValue(String string, String string2) {
        if (string == null) {
            if (string2.equals("externalResourcesRequired")) {
                return this.getBaseValue(this.getExternalResourcesRequired());
            }
            if (string2.equals("transform")) {
                return this.getBaseValue(this.getTransform());
            }
        }
        return super.getUnderlyingValue(string, string2);
    }

    static {
        Map map = typeMap;
        SVGOMAttributeInfo sVGOMAttributeInfo = new SVGOMAttributeInfo(9, true);
        map.put("transform", sVGOMAttributeInfo);
        sVGOMAttributeInfo = new SVGOMAttributeInfo(15, true);
        map.put("externalResourcesRequired", sVGOMAttributeInfo);
        sVGOMAttributeInfo = new SVGOMAttributeInfo(33, false);
        map.put("requiredExtensions", sVGOMAttributeInfo);
        map.put("requiredFeatures", sVGOMAttributeInfo);
        sVGOMAttributeInfo = new SVGOMAttributeInfo(46, false);
        map.put("systemLanguage", sVGOMAttributeInfo);
    }
}

