/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.tiff;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFField;
import org.apache.batik.ext.awt.image.codec.util.SeekableStream;

public class TIFFDirectory
implements Serializable {
    boolean isBigEndian;
    int numEntries;
    TIFFField[] fields;
    Map fieldIndex = new HashMap();
    long IFDOffset = 8L;
    long nextIFDOffset = 0L;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    TIFFDirectory() {
    }

    private static boolean isValidEndianTag(int n) {
        return n == 18761 || n == 19789;
    }

    public TIFFDirectory(SeekableStream seekableStream, int n) throws IOException {
        long l = seekableStream.getFilePointer();
        seekableStream.seek(0L);
        int n2 = seekableStream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n2)) {
            throw new IllegalArgumentException("TIFFDirectory1");
        }
        this.isBigEndian = n2 == 19789;
        int n3 = this.readUnsignedShort(seekableStream);
        if (n3 != 42) {
            throw new IllegalArgumentException("TIFFDirectory2");
        }
        long l2 = this.readUnsignedInt(seekableStream);
        for (int i = 0; i < n; ++i) {
            if (l2 == 0L) {
                throw new IllegalArgumentException("TIFFDirectory3");
            }
            seekableStream.seek(l2);
            int n4 = this.readUnsignedShort(seekableStream);
            seekableStream.skip(12 * n4);
            l2 = this.readUnsignedInt(seekableStream);
        }
        seekableStream.seek(l2);
        this.initialize(seekableStream);
        seekableStream.seek(l);
    }

    public TIFFDirectory(SeekableStream seekableStream, long l, int n) throws IOException {
        long l2 = seekableStream.getFilePointer();
        seekableStream.seek(0L);
        int n2 = seekableStream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n2)) {
            throw new IllegalArgumentException("TIFFDirectory1");
        }
        this.isBigEndian = n2 == 19789;
        seekableStream.seek(l);
        for (int i = 0; i < n; ++i) {
            int n3 = this.readUnsignedShort(seekableStream);
            seekableStream.seek(l + (long)(12 * n3));
            l = this.readUnsignedInt(seekableStream);
            seekableStream.seek(l);
        }
        this.initialize(seekableStream);
        seekableStream.seek(l2);
    }

    private void initialize(SeekableStream seekableStream) throws IOException {
        this.IFDOffset = seekableStream.getFilePointer();
        this.numEntries = this.readUnsignedShort(seekableStream);
        this.fields = new TIFFField[this.numEntries];
        for (int i = 0; i < this.numEntries; ++i) {
            long l;
            int n;
            int n2;
            int n3;
            block25: {
                n3 = this.readUnsignedShort(seekableStream);
                n2 = this.readUnsignedShort(seekableStream);
                n = (int)this.readUnsignedInt(seekableStream);
                int n4 = 0;
                l = seekableStream.getFilePointer() + 4L;
                try {
                    if (n * sizeOfType[n2] <= 4) break block25;
                    n4 = (int)this.readUnsignedInt(seekableStream);
                    seekableStream.seek(n4);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.err.println(n3 + " " + "TIFFDirectory4");
                    seekableStream.seek(l);
                    continue;
                }
            }
            this.fieldIndex.put(new Integer(n3), new Integer(i));
            Object object = null;
            switch (n2) {
                case 1: 
                case 2: 
                case 6: 
                case 7: {
                    Object[] objectArray;
                    Object object2;
                    byte[] byArray = new byte[n];
                    seekableStream.readFully(byArray, 0, n);
                    if (n2 == 2) {
                        int n5 = 0;
                        int n6 = 0;
                        object2 = new ArrayList();
                        while (n5 < n) {
                            while (n5 < n && byArray[n5++] != 0) {
                            }
                            object2.add(new String(byArray, n6, n5 - n6));
                            n6 = n5;
                        }
                        n = object2.size();
                        objectArray = new String[n];
                        object2.toArray(objectArray);
                        object = objectArray;
                        break;
                    }
                    object = byArray;
                    break;
                }
                case 3: {
                    int n7;
                    char[] cArray = new char[n];
                    for (n7 = 0; n7 < n; ++n7) {
                        cArray[n7] = (char)this.readUnsignedShort(seekableStream);
                    }
                    object = cArray;
                    break;
                }
                case 4: {
                    int n7;
                    long[] lArray = new long[n];
                    for (n7 = 0; n7 < n; ++n7) {
                        lArray[n7] = this.readUnsignedInt(seekableStream);
                    }
                    object = lArray;
                    break;
                }
                case 5: {
                    int n7;
                    Object object2 = new long[n][2];
                    for (n7 = 0; n7 < n; ++n7) {
                        object2[n7][0] = this.readUnsignedInt(seekableStream);
                        object2[n7][1] = this.readUnsignedInt(seekableStream);
                    }
                    object = object2;
                    break;
                }
                case 8: {
                    int n7;
                    Object[] objectArray = new short[n];
                    for (n7 = 0; n7 < n; ++n7) {
                        objectArray[n7] = this.readShort(seekableStream);
                    }
                    object = objectArray;
                    break;
                }
                case 9: {
                    int n7;
                    int[] nArray = new int[n];
                    for (n7 = 0; n7 < n; ++n7) {
                        nArray[n7] = this.readInt(seekableStream);
                    }
                    object = nArray;
                    break;
                }
                case 10: {
                    int n7;
                    int[][] nArray = new int[n][2];
                    for (n7 = 0; n7 < n; ++n7) {
                        nArray[n7][0] = this.readInt(seekableStream);
                        nArray[n7][1] = this.readInt(seekableStream);
                    }
                    object = nArray;
                    break;
                }
                case 11: {
                    int n7;
                    float[] fArray = new float[n];
                    for (n7 = 0; n7 < n; ++n7) {
                        fArray[n7] = this.readFloat(seekableStream);
                    }
                    object = fArray;
                    break;
                }
                case 12: {
                    int n7;
                    double[] dArray = new double[n];
                    for (n7 = 0; n7 < n; ++n7) {
                        dArray[n7] = this.readDouble(seekableStream);
                    }
                    object = dArray;
                    break;
                }
                default: {
                    System.err.println("TIFFDirectory0");
                }
            }
            this.fields[i] = new TIFFField(n3, n2, n, object);
            seekableStream.seek(l);
        }
        this.nextIFDOffset = this.readUnsignedInt(seekableStream);
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public TIFFField getField(int n) {
        Integer n2 = (Integer)this.fieldIndex.get(new Integer(n));
        if (n2 == null) {
            return null;
        }
        return this.fields[n2];
    }

    public boolean isTagPresent(int n) {
        return this.fieldIndex.containsKey(new Integer(n));
    }

    public int[] getTags() {
        int[] nArray = new int[this.fieldIndex.size()];
        Iterator iterator = this.fieldIndex.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            nArray[n++] = (Integer)iterator.next();
        }
        return nArray;
    }

    public TIFFField[] getFields() {
        return this.fields;
    }

    public byte getFieldAsByte(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        byte[] byArray = this.fields[n3].getAsBytes();
        return byArray[n2];
    }

    public byte getFieldAsByte(int n) {
        return this.getFieldAsByte(n, 0);
    }

    public long getFieldAsLong(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        return this.fields[n3].getAsLong(n2);
    }

    public long getFieldAsLong(int n) {
        return this.getFieldAsLong(n, 0);
    }

    public float getFieldAsFloat(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        return this.fields[n3].getAsFloat(n2);
    }

    public float getFieldAsFloat(int n) {
        return this.getFieldAsFloat(n, 0);
    }

    public double getFieldAsDouble(int n, int n2) {
        Integer n3 = (Integer)this.fieldIndex.get(new Integer(n));
        return this.fields[n3].getAsDouble(n2);
    }

    public double getFieldAsDouble(int n) {
        return this.getFieldAsDouble(n, 0);
    }

    private short readShort(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readShort();
        }
        return seekableStream.readShortLE();
    }

    private int readUnsignedShort(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readUnsignedShort();
        }
        return seekableStream.readUnsignedShortLE();
    }

    private int readInt(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readInt();
        }
        return seekableStream.readIntLE();
    }

    private long readUnsignedInt(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readUnsignedInt();
        }
        return seekableStream.readUnsignedIntLE();
    }

    private long readLong(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readLong();
        }
        return seekableStream.readLongLE();
    }

    private float readFloat(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readFloat();
        }
        return seekableStream.readFloatLE();
    }

    private double readDouble(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readDouble();
        }
        return seekableStream.readDoubleLE();
    }

    private static int readUnsignedShort(SeekableStream seekableStream, boolean bl) throws IOException {
        if (bl) {
            return seekableStream.readUnsignedShort();
        }
        return seekableStream.readUnsignedShortLE();
    }

    private static long readUnsignedInt(SeekableStream seekableStream, boolean bl) throws IOException {
        if (bl) {
            return seekableStream.readUnsignedInt();
        }
        return seekableStream.readUnsignedIntLE();
    }

    public static int getNumDirectories(SeekableStream seekableStream) throws IOException {
        long l = seekableStream.getFilePointer();
        seekableStream.seek(0L);
        int n = seekableStream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(n)) {
            throw new IllegalArgumentException("TIFFDirectory1");
        }
        boolean bl = n == 19789;
        int n2 = TIFFDirectory.readUnsignedShort(seekableStream, bl);
        if (n2 != 42) {
            throw new IllegalArgumentException("TIFFDirectory2");
        }
        seekableStream.seek(4L);
        long l2 = TIFFDirectory.readUnsignedInt(seekableStream, bl);
        int n3 = 0;
        while (l2 != 0L) {
            ++n3;
            seekableStream.seek(l2);
            int n4 = TIFFDirectory.readUnsignedShort(seekableStream, bl);
            seekableStream.skip(12 * n4);
            l2 = TIFFDirectory.readUnsignedInt(seekableStream, bl);
        }
        seekableStream.seek(l);
        return n3;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public long getIFDOffset() {
        return this.IFDOffset;
    }

    public long getNextIFDOffset() {
        return this.nextIFDOffset;
    }
}

