/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.math;

import org.kabeja.dxf.helpers.Point;

public class NURBS {
    protected Point[] controlPoints;
    protected double[] knots;
    protected double[] weights;
    protected int degree;
    protected boolean closed = false;

    public NURBS(Point[] pointArray, double[] dArray, double[] dArray2, int n) {
        this.controlPoints = pointArray;
        this.knots = dArray;
        this.weights = dArray2;
        this.degree = n;
        if (this.weights.length == 0) {
            this.weights = new double[this.controlPoints.length];
        }
        for (int i = 0; i < dArray2.length; ++i) {
            if (dArray2[i] != 0.0) continue;
            dArray2[i] = 1.0;
        }
    }

    public double[] getBasicFunctions(int n, double d) {
        double[] dArray = new double[this.degree + 1];
        dArray[0] = 1.0;
        double[] dArray2 = new double[this.degree + 1];
        double[] dArray3 = new double[this.degree + 1];
        for (int i = 1; i <= this.degree; ++i) {
            dArray2[i] = d - this.knots[n + 1 - i];
            dArray3[i] = this.knots[n + i] - d;
            double d2 = 0.0;
            for (int j = 0; j < i; ++j) {
                double d3 = dArray[j] / (dArray3[j + 1] + dArray2[i - j]);
                dArray[j] = d2 + dArray3[j + 1] * d3;
                d2 = dArray2[i - j] * d3;
            }
            dArray[i] = d2;
        }
        return dArray;
    }

    public Point getPointAt(int n, double d) {
        Point point = new Point();
        double[] dArray = this.getBasicFunctions(n, d);
        double d2 = 0.0;
        for (int i = 0; i <= this.degree; ++i) {
            int n2 = n - this.degree + i;
            double d3 = this.weights[n2];
            point.setX(point.getX() + dArray[i] * this.controlPoints[n2].getX() * d3);
            point.setY(point.getY() + dArray[i] * this.controlPoints[n2].getY() * d3);
            point.setZ(point.getZ() + dArray[i] * this.controlPoints[n2].getZ() * d3);
            d2 += dArray[i] * d3;
        }
        point.setX(point.getX() / d2);
        point.setY(point.getY() / d2);
        point.setZ(point.getZ() / d2);
        return point;
    }

    public Point getPointAt(double d) {
        int n = this.findSpawnIndex(d);
        return this.getPointAt(n, d);
    }

    public int findSpawnIndex(double d) {
        if (d == this.knots[this.controlPoints.length + 1]) {
            return this.controlPoints.length;
        }
        int n = this.degree;
        int n2 = this.controlPoints.length + 1;
        int n3 = (n + n2) / 2;
        while (d < this.knots[n3] || d >= this.knots[n3 + 1]) {
            if (d < this.knots[n3]) {
                n2 = n3;
            } else {
                n = n3;
            }
            n3 = (n + n2) / 2;
        }
        return n3;
    }

    public Point[] getControlPoints() {
        return this.controlPoints;
    }

    public void setControlPoints(Point[] pointArray) {
        this.controlPoints = pointArray;
    }

    public double[] getKnots() {
        return this.knots;
    }

    public void setKnots(double[] dArray) {
        this.knots = dArray;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] dArray) {
        this.weights = dArray;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int n) {
        this.degree = n;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean bl) {
        this.closed = bl;
    }
}

