/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.dxf.filter;

import org.kabeja.parser.DXFValue;
import org.kabeja.parser.ParseException;
import org.kabeja.parser.dxf.filter.DXFStreamSectionFilter;

abstract class DXFStreamEntityFilter
extends DXFStreamSectionFilter {
    private static String SECTION_KEY = "ENTITIES";
    public static final int ENTITY_START = 0;
    protected boolean entitySection = false;
    protected boolean parseEntity = false;
    protected boolean parseHeader = false;

    DXFStreamEntityFilter() {
    }

    protected void parseSection(int n, DXFValue dXFValue) throws ParseException {
        if (this.parseHeader) {
            if (dXFValue.getValue().equals(SECTION_KEY)) {
                this.entitySection = true;
                this.parseHeader = false;
            }
        } else if (this.entitySection) {
            if (n == 0) {
                if (this.parseEntity) {
                    this.endEntity();
                } else {
                    this.parseEntity = true;
                }
                this.startEntity(dXFValue.getValue());
            }
            this.parseEntity(n, dXFValue);
            return;
        }
        this.handler.parseGroup(n, dXFValue);
    }

    protected void sectionEnd(String string) throws ParseException {
        if (this.section.equals(SECTION_KEY)) {
            this.entitySection = false;
        }
    }

    protected void sectionStart(String string) throws ParseException {
        if (this.section.equals(SECTION_KEY)) {
            this.parseHeader = true;
        }
    }

    protected abstract void startEntity(String var1) throws ParseException;

    protected abstract void endEntity() throws ParseException;

    protected abstract void parseEntity(int var1, DXFValue var2) throws ParseException;
}

