/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.miethxml.toolkit.component.GuiConfigurable;
import de.miethxml.toolkit.gui.ImagePreviewer;
import de.miethxml.toolkit.gui.LocaleButton;
import de.miethxml.toolkit.gui.StringListView;
import de.miethxml.toolkit.gui.StringListViewImpl;
import de.miethxml.toolkit.repository.ui.editor.ExternalEditor;
import de.miethxml.toolkit.repository.ui.editor.ExternalEditorManager;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.avalon.framework.activity.Initializable;

public class ExternalEditorSetup
implements GuiConfigurable,
Initializable,
ActionListener {
    private static String ACTION_SETTINGS_OK = "settings.ok";
    private static String ACTION_SETTINGS_CANCEL = "settings.cancel";
    public static String DEFAUL_ICON = "icons/text_edit.gif";
    private JList handles;
    private JList editors;
    private JTextField name;
    private JTextField icon;
    private JTextField command;
    private JTextField handle;
    private DefaultListModel handlesdata = new DefaultListModel();
    private JPanel setup;
    private ExternalEditorManager em;
    private DefaultListModel editordata = new DefaultListModel();
    private StringListView suffices;
    private JFileChooser commandChooser;
    private JDialog dialog;
    private boolean isNew = false;
    private int editviewer = -1;

    public String getLabel() {
        return "External Editor Setup";
    }

    public JComponent getSetupComponent() {
        if (this.setup == null) {
            this.setup = this.createSetupPanel();
        }
        return this.setup;
    }

    public void setup() {
        this.em.save();
    }

    public void initialize() {
        this.setEditors();
    }

    private JPanel createSetupPanel() {
        FormLayout panellayout = new FormLayout("3dlu,pref,3dlu,pref:grow,3dlu,pref,3dlu,pref:grow,3dlu", "3dlu,p,3dlu,p,2dlu,p,2dlu,p,fill:3dlu:grow,3dlu");
        PanelBuilder builder = new PanelBuilder(panellayout);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("All Editors", cc.xywh(2, 2, 5, 1));
        this.editors = new JList(this.editordata);
        this.editors.setSelectionMode(0);
        JScrollPane sp = new JScrollPane(this.editors);
        builder.add((Component)sp, cc.xywh(4, 4, 1, 6));
        JButton button = new JButton("add");
        button.setActionCommand("add.editor");
        button.addActionListener(this);
        builder.add((Component)button, cc.xy(6, 4));
        button = new JButton("edit");
        button.setActionCommand("edit.editor");
        button.addActionListener(this);
        builder.add((Component)button, cc.xy(6, 6));
        button = new JButton("remove");
        button.setActionCommand("remove.editor");
        button.addActionListener(this);
        builder.add((Component)button, cc.xy(6, 8));
        this.createDialog();
        return builder.getPanel();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("remove.editor")) {
            this.em.removeEditor(this.editors.getSelectedIndex());
            this.editordata.removeElementAt(this.editors.getSelectedIndex());
        } else if (e.getActionCommand().equals("edit.editor")) {
            this.isNew = false;
            this.setEditor(this.editors.getSelectedIndex());
            this.dialog.setVisible(true);
        } else if (e.getActionCommand().equals("add.editor")) {
            this.isNew = true;
            this.setBlankFields();
            this.dialog.setVisible(true);
        } else if (e.getActionCommand().equals("choose.icon")) {
            JFileChooser fs = new JFileChooser("icons/");
            ImagePreviewer ip = new ImagePreviewer(36, 36);
            fs.setAccessory(ip);
            fs.addPropertyChangeListener(ip);
            if (fs.showOpenDialog(null) == 0) {
                this.icon.setText(fs.getSelectedFile().getPath());
            }
        } else if (e.getActionCommand().equals("choose.command")) {
            this.commandChooser.setFileSelectionMode(0);
            int value = this.commandChooser.showDialog(null, "Choose Program");
            if (value == 0) {
                this.command.setText(String.valueOf(this.commandChooser.getSelectedFile().getAbsolutePath()) + "  %s");
            }
        } else if (e.getActionCommand().equals(ACTION_SETTINGS_CANCEL)) {
            this.dialog.setVisible(false);
        } else if (e.getActionCommand().equals(ACTION_SETTINGS_OK)) {
            if (!this.isNew) {
                this.em.removeEditor(this.editviewer);
            }
            this.addNewEditor();
            this.dialog.setVisible(false);
        }
    }

    public boolean isSetup() {
        return false;
    }

    private void setEditors() {
        int i = 0;
        while (i < this.em.getEditorCount()) {
            this.editordata.addElement(this.em.getEditor(i).getName());
            ++i;
        }
    }

    private void addNewEditor() {
        ExternalEditor edit = new ExternalEditor();
        edit.init();
        edit.setName(this.name.getText());
        edit.setCommand(this.command.getText());
        edit.setIcon(this.icon.getText());
        edit.setHandles(this.suffices.getStringList());
        this.em.addEditor(edit);
        this.editordata.addElement(this.name.getText());
        this.setBlankFields();
    }

    private void setBlankFields() {
        this.name.setText("");
        this.command.setText("");
        this.icon.setText(DEFAUL_ICON);
        ArrayList<String> list = new ArrayList<String>();
        list.add("*");
        this.suffices.setStringList(list);
    }

    private void setEditor(int index) {
        this.setBlankFields();
        ExternalEditor edit = this.em.getEditor(index);
        this.name.setText(edit.getName());
        this.command.setText(edit.getCommand());
        this.icon.setText(edit.getIconURL());
        this.suffices.setStringList(edit.getHandles());
    }

    public void setExternalEditorManager(ExternalEditorManager manager) {
        this.em = manager;
    }

    private void createDialog() {
        FormLayout panellayout = new FormLayout("3dlu,pref,3dlu,pref:grow,3dlu,pref,3dlu,pref:grow,3dlu", "3dlu,p,3dlu,p,2dlu,p,2dlu,p,2dlu,p,2dlu,p,20dlu:grow,3dlu");
        PanelBuilder builder = new PanelBuilder(panellayout);
        CellConstraints cc = new CellConstraints();
        this.dialog = new JDialog();
        this.dialog.setTitle("Editor Settings");
        builder.addLabel("Name", cc.xy(2, 4));
        this.name = new JTextField(20);
        builder.add((Component)this.name, cc.xy(4, 4));
        builder.addLabel("Command ", cc.xy(2, 6));
        this.command = new JTextField(20);
        builder.add((Component)this.command, cc.xy(4, 6));
        JButton button = new JButton("...");
        button.setActionCommand("choose.command");
        button.addActionListener(this);
        builder.add((Component)button, cc.xy(6, 6));
        this.commandChooser = new JFileChooser();
        builder.addLabel("%s for file ", cc.xy(8, 6));
        builder.addLabel("Icon", cc.xy(2, 8));
        this.icon = new JTextField(20);
        builder.add((Component)this.icon, cc.xy(4, 8));
        button = new JButton("...");
        button.setActionCommand("choose.icon");
        button.addActionListener(this);
        builder.add((Component)button, cc.xy(6, 8));
        builder.addSeparator("Extensions", cc.xywh(2, 10, 7, 1));
        this.suffices = new StringListViewImpl();
        this.suffices.init();
        builder.add((Component)this.suffices.getView(), cc.xywh(2, 12, 5, 2));
        this.dialog.getContentPane().add((Component)builder.getPanel(), "Center");
        JPanel buttonpanel = new JPanel(new FlowLayout(2, 5, 5));
        button = new LocaleButton("common.button.cancel");
        button.addActionListener(this);
        button.setActionCommand(ACTION_SETTINGS_CANCEL);
        buttonpanel.add(button);
        button = new LocaleButton("common.button.ok");
        button.addActionListener(this);
        button.setActionCommand(ACTION_SETTINGS_OK);
        buttonpanel.add(button);
        this.dialog.getContentPane().add((Component)buttonpanel, "South");
        this.dialog.pack();
    }
}

