/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.setup;

import de.miethxml.toolkit.component.GuiConfigurable;
import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.setup.SetupNode;
import de.miethxml.toolkit.setup.SetupProcessListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ApplicationSetup
implements TreeModel,
Serviceable,
Initializable {
    public static final String ROLE;
    private ServiceManager manager;
    private SetupNode root;
    private ArrayList treelistener = new ArrayList();
    private ArrayList setupProcessListener;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.miethxml.toolkit.setup.ApplicationSetup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ROLE = clazz.getName();
    }

    public ApplicationSetup() {
        this.root = new SetupNode();
        this.root.setLabel(LocaleImpl.getInstance().getString("setup.tree.root"));
        this.root.setKey("setup");
        this.setupProcessListener = new ArrayList();
    }

    public Object getRoot() {
        return this.root;
    }

    public int getChildCount(Object parent) {
        SetupNode node = (SetupNode)parent;
        return node.getChildCount();
    }

    public boolean isLeaf(Object obj) {
        SetupNode node = (SetupNode)obj;
        return node.getChildCount() == 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treelistener.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        int i = 0;
        while (i < this.treelistener.size()) {
            TreeModelListener tml = (TreeModelListener)this.treelistener.get(i);
            if (tml.equals(l)) {
                this.treelistener.remove(i);
                return;
            }
            ++i;
        }
    }

    public Object getChild(Object parent, int index) {
        SetupNode node = (SetupNode)parent;
        if (node.hasChildren() && index >= 0 && index < node.getChildCount()) {
            return node.getChild(index);
        }
        return null;
    }

    public int getIndexOfChild(Object parent, Object child) {
        SetupNode node = (SetupNode)parent;
        SetupNode childnode = (SetupNode)child;
        if (node.hasChildren()) {
            int i = 0;
            while (i < node.getChildCount()) {
                SetupNode setupchild = node.getChild(i);
                if (setupchild.equals(childnode)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void initialize() {
    }

    public void disposeComponent(ServiceManager newParam) {
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void addGuiConfigurable(String key, GuiConfigurable config) {
        String[] path = key.split("\\.");
        SetupNode node = this.root;
        if (path[0].equals("setup")) {
            StringBuffer buf = new StringBuffer();
            buf.append("setup.tree.root");
            int i = 1;
            while (i < path.length) {
                SetupNode child = node.getChild(path[i]);
                buf.append("." + path[i]);
                if (child == null) {
                    child = new SetupNode();
                    child.setKey(path[i]);
                    child.setLabel(LocaleImpl.getInstance().getString(buf.toString()));
                    node.addSetupNode(child);
                }
                node = child;
                ++i;
            }
            SetupNode child = new SetupNode();
            child.setKey("" + node.getChildCount());
            child.setLabel(config.getLabel());
            child.setGuiConfigurable(config);
            node.addSetupNode(child);
            this.fireTreeEvent();
        }
    }

    private void fireTreeEvent() {
        int i = 0;
        while (i < this.treelistener.size()) {
            TreeModelListener tml = (TreeModelListener)this.treelistener.get(i);
            Object[] node = new SetupNode[]{this.root};
            tml.treeStructureChanged(new TreeModelEvent((Object)this, node));
            ++i;
        }
    }

    public void setupNodes() {
        this.fireSetupProcessStart();
        this.root.setup();
        this.fireSetupProcessEnd();
    }

    public void addSetupProcessListener(SetupProcessListener l) {
        this.setupProcessListener.add(l);
    }

    public void removeSetupProcessListener(SetupProcessListener l) {
        this.setupProcessListener.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSetupProcessStart() {
        ArrayList arrayList = this.setupProcessListener;
        synchronized (arrayList) {
            Iterator i = this.setupProcessListener.iterator();
            while (i.hasNext()) {
                SetupProcessListener l = (SetupProcessListener)i.next();
                l.startSetup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSetupProcessEnd() {
        ArrayList arrayList = this.setupProcessListener;
        synchronized (arrayList) {
            Iterator i = this.setupProcessListener.iterator();
            while (i.hasNext()) {
                SetupProcessListener l = (SetupProcessListener)i.next();
                l.endSetup();
            }
        }
    }
}

