/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;

public class PopUpButton
extends JButton {
    private JPopupMenu popupmenu;
    private int[] px = new int[3];
    private int[] py = new int[3];

    public PopUpButton(JPopupMenu menu, String text) {
        super(text);
        this.popupmenu = menu;
        this.setOpaque(false);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component c = (Component)e.getSource();
                PopUpButton.this.popupmenu.show(c, 0, c.getHeight());
            }
        });
        ItemListener l = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getItem();
                    PopUpButton.this.setIcon(item.getIcon());
                }
            }
        };
        for (int i = 0; i < menu.getComponentCount(); ++i) {
            Component c = menu.getComponent(i);
            if (!(c instanceof JCheckBoxMenuItem)) continue;
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)c;
            item.addItemListener(l);
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension dim = this.getSize();
        int[] px = new int[3];
        px[0] = (int)(dim.getWidth() - 7.0);
        this.py[0] = (int)(dim.getHeight() - 2.0);
        px[1] = px[0] + 5;
        this.py[1] = this.py[0];
        px[2] = px[1];
        this.py[2] = this.py[0] - 5;
        g.setColor(Color.BLACK);
        g.fillPolygon(px, this.py, 3);
    }
}

