/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.cache;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class ImageCache {
    private HashMap map = new HashMap();

    private void addImageToCache(BufferedImage img, String uri) {
        this.map.put(uri, new SoftReference<BufferedImage>(img));
    }

    public BufferedImage getImage(String uri) {
        return this.getImage(uri, false);
    }

    public BufferedImage getImage(String uri, boolean update) {
        if (!update && this.map.containsKey(uri)) {
            SoftReference ref = (SoftReference)this.map.get(uri);
            Object obj = ref.get();
            if (obj != null) {
                return (BufferedImage)obj;
            }
            this.map.remove(uri);
        }
        try {
            File f = new File(uri);
            URL url = f.exists() ? f.toURL() : new URL(uri);
            BufferedImage img = this.getImage(url);
            this.addImageToCache(img, uri);
            return img;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private BufferedImage getImage(URL url) {
        try {
            return ImageIO.read(url);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

