/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.conf;

import de.miethxml.toolkit.conf.ConfigListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public class ConfigManager {
    static ConfigManager instance;
    public static String DEFAULT_CONFIGNAME;
    private Properties props;
    private ArrayList listeners = new ArrayList();
    private String confFile;

    static {
        DEFAULT_CONFIGNAME = "conf/main.conf";
    }

    private ConfigManager() {
        this.props = new Properties();
        this.confFile = DEFAULT_CONFIGNAME;
        this.load();
    }

    private void load() {
        try {
            this.props.load(new FileInputStream(this.confFile));
        }
        catch (IOException ioe) {
            System.out.println("Error: no config-file found, try default.");
            try {
                this.props.load(new FileInputStream(DEFAULT_CONFIGNAME));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fireAllChanged();
    }

    public void storeConfiguration() {
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(this.confFile));
            pw.println("#Main Config File");
            Enumeration<Object> e = this.props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)this.props.get(key);
                pw.println(String.valueOf(key) + " = " + value);
            }
            pw.flush();
            pw.close();
        }
        catch (IOException ioe) {
            System.out.println("Could not write config-File!");
            ioe.printStackTrace();
        }
    }

    public static synchronized ConfigManager getInstance() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    public String getProperty(String key) {
        if (this.props.containsKey(key)) {
            return this.props.getProperty(key);
        }
        return "";
    }

    public String getProperty(String key, String defaultvalue) {
        if (this.props.containsKey(key)) {
            return this.props.getProperty(key);
        }
        return defaultvalue;
    }

    public boolean hasProperty(String key) {
        return this.props.containsKey(key);
    }

    public void setProperty(String key, String value) {
        this.props.put(key, value);
        this.storeConfiguration();
        this.fireConfigChange(key);
    }

    public void addConfigListener(ConfigListener l) {
        this.listeners.add(l);
    }

    public void removeConfigListener(ConfigListener l) {
        this.listeners.remove(l);
    }

    private void fireConfigChange(String configKey) {
        Iterator i = ((ArrayList)this.listeners.clone()).iterator();
        while (i.hasNext()) {
            ConfigListener cl = (ConfigListener)i.next();
            cl.configChanged(configKey);
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setConfigFile(String file) {
        this.confFile = file;
        this.load();
    }

    private void fireAllChanged() {
        Enumeration<Object> e = ((Properties)this.props.clone()).keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.fireConfigChange(key);
        }
    }
}

