/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository;

import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.io.FileModelException;
import de.miethxml.toolkit.io.FileModelFilter;
import de.miethxml.toolkit.io.FileModelManager;
import de.miethxml.toolkit.io.FileModelSorter;
import de.miethxml.toolkit.repository.Reloadable;
import de.miethxml.toolkit.repository.RepositoryModel;
import de.miethxml.toolkit.repository.RepositorySelectionListener;
import java.lang.ref.SoftReference;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RepositoryModelImpl
implements TreeSelectionListener,
RepositoryModel,
ListSelectionListener,
Reloadable {
    private FileModel base;
    private FileModel currentModel;
    private FileModel selectedModel;
    private ArrayList fsmListener = new ArrayList();
    private ArrayList filters = new ArrayList();
    private ArrayList sorters = new ArrayList();
    private boolean showMixed = false;
    private RepositoryTreeModel treeModel = new RepositoryTreeModel();
    private RepositoryTableModel tableModel = new RepositoryTableModel();
    private FileModel[] currentList = new FileModel[0];
    private FileModelManager manager;
    private HashMap cache = new HashMap();

    public RepositoryModelImpl(FileModelManager manager) {
        this.manager = manager;
    }

    public void setBase(String base) throws FileModelException {
        this.base = this.manager.createFileModel(base);
        this.fireUnselectEvent();
        this.currentModel = this.base;
        this.currentList = !this.currentModel.isFile() ? this.currentModel.getChildren() : new FileModel[0];
        this.treeModel.fireTreeUpdate();
        this.tableModel.fireTableUpdate();
    }

    public TreeModel getTreeModel(boolean showMixed) {
        this.showMixed = showMixed;
        return this.treeModel;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void addRepositorySelectionListener(RepositorySelectionListener l) {
        this.fsmListener.add(l);
    }

    public void removeRepositorySelectionListener(RepositorySelectionListener l) {
        this.fsmListener.remove(l);
    }

    public void reload() {
        if (!this.currentModel.exists()) {
            this.currentList = new FileModel[0];
        } else {
            try {
                this.currentList = this.currentModel.getChildren();
            }
            catch (FileModelException e) {
                this.currentList = new FileModel[0];
            }
        }
        this.treeModel.clearCache();
        this.tableModel.fireTableUpdate();
        this.treeModel.fireSelectedNodeUpdate();
    }

    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        int first = lsm.getMinSelectionIndex();
        if (first == 0) {
            try {
                this.selectedModel = this.currentModel.getParent();
            }
            catch (FileModelException e1) {
                e1.printStackTrace();
            }
            return;
        }
        if (first > 0) {
            this.selectedModel = this.currentList[first - 1];
            if (!this.currentList[first - 1].isFile()) {
                this.fireDirectorySelectedEvent(this.currentList[first - 1]);
            } else {
                this.fireFileSelectedEvent(this.currentList[first - 1]);
            }
        } else {
            this.fireUnselectEvent();
        }
    }

    public void valueChanged(TreeSelectionEvent arg0) {
        FileModel fm;
        TreePath tp = arg0.getPath();
        this.currentModel = fm = (FileModel)tp.getLastPathComponent();
        this.selectedModel = fm;
        if (!this.currentModel.isFile()) {
            try {
                this.currentList = this.currentModel.getChildren();
            }
            catch (FileModelException e) {
                this.currentList = new FileModel[0];
            }
            this.fireDirectorySelectedEvent(fm);
        } else {
            this.currentList = new FileModel[0];
            this.fireFileSelectedEvent(fm);
        }
        this.tableModel.fireTableUpdate();
    }

    private void fireDirectorySelectedEvent(FileModel directory) {
        int i = 0;
        while (i < this.fsmListener.size()) {
            RepositorySelectionListener l = (RepositorySelectionListener)this.fsmListener.get(i);
            l.directorySelected(this, directory);
            ++i;
        }
    }

    private void fireUnselectEvent() {
        int i = 0;
        while (i < this.fsmListener.size()) {
            RepositorySelectionListener l = (RepositorySelectionListener)this.fsmListener.get(i);
            l.unselect();
            ++i;
        }
    }

    private void fireFileSelectedEvent(FileModel file) {
        int i = 0;
        while (i < this.fsmListener.size()) {
            RepositorySelectionListener l = (RepositorySelectionListener)this.fsmListener.get(i);
            l.fileSelected(this, file);
            ++i;
        }
    }

    public void expandSelectedFileModel() {
        if (this.selectedModel != null && !this.selectedModel.isFile()) {
            this.currentModel = this.selectedModel;
            try {
                this.currentList = this.currentModel.getChildren();
            }
            catch (FileModelException e) {
                e.printStackTrace();
                this.currentList = new FileModel[0];
            }
            this.tableModel.fireTableUpdate();
            if (this.currentModel.getPath().length() < this.base.getPath().length()) {
                this.base = this.currentModel;
            }
        }
    }

    private FileModel[] filterAndSortFileModelList(FileModel[] list) {
        list = this.applyFilters(list);
        this.applySorters(list);
        return list;
    }

    public void addFileModelFilter(FileModelFilter filter) {
        this.filters.add(filter);
    }

    public void removeFileModelFilter(FileModelFilter filter) {
        this.filters.remove(filter);
    }

    private FileModel[] applyFilters(FileModel[] data) {
        if (this.filters.size() > 0) {
            int x;
            int count = data.length;
            Iterator i = this.filters.iterator();
            while (i.hasNext()) {
                FileModelFilter filter = (FileModelFilter)i.next();
                x = 0;
                while (x < data.length) {
                    if (data[x] != null && !filter.accept(data[x])) {
                        --count;
                        data[x] = null;
                    }
                    ++x;
                }
            }
            FileModel[] filtered = new FileModel[count];
            count = 0;
            x = 0;
            while (x < data.length) {
                if (data[x] != null) {
                    filtered[count] = data[x];
                    ++count;
                }
                ++x;
            }
            return filtered;
        }
        return data;
    }

    public FileModel getBase() {
        return this.base;
    }

    public void addFileModelSorter(FileModelSorter sorter) {
        this.sorters.add(sorter);
    }

    public void removeFileModelSorter(FileModelSorter sorter) {
        this.sorters.remove(sorter);
    }

    private void applySorters(FileModel[] list) {
        Iterator i = this.sorters.iterator();
        FileModel[] result = list;
        while (i.hasNext()) {
            FileModelSorter sorter = (FileModelSorter)i.next();
            sorter.sort(list);
        }
    }

    public class RepositoryTreeModel
    implements TreeModel {
        private ArrayList treelistener = new ArrayList();
        private FileModel cachedModel;
        private FileModel[] cachedList;
        private FileModel[][] totalCachedLists = new FileModel[this.cacheSize][];
        private FileModel[] totalCachedModels = new FileModel[this.cacheSize];
        private int cacheSize = 3;
        private int lastCacheInsert = -1;

        public void addTreeModelListener(TreeModelListener arg0) {
            this.treelistener.add(arg0);
        }

        public Object getChild(Object obj, int index) {
            FileModel fm = (FileModel)obj;
            this.updateCache(fm);
            if (RepositoryModelImpl.this.showMixed) {
                if (index < this.cachedList.length) {
                    return this.cachedList[index];
                }
            } else {
                int count = 0;
                int i = 0;
                while (i < this.cachedList.length) {
                    if (!this.cachedList[i].isFile()) {
                        if (count == index) {
                            return this.cachedList[i];
                        }
                        ++count;
                    }
                    ++i;
                }
            }
            return null;
        }

        public int getChildCount(Object obj) {
            FileModel fm = (FileModel)obj;
            this.updateCache(fm);
            if (RepositoryModelImpl.this.showMixed) {
                return this.cachedList.length;
            }
            int count = 0;
            int i = 0;
            while (i < this.cachedList.length) {
                if (!this.cachedList[i].isFile()) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        public int getIndexOfChild(Object p, Object c) {
            FileModel parent = (FileModel)p;
            FileModel child = (FileModel)c;
            this.updateCache(parent);
            if (RepositoryModelImpl.this.showMixed) {
                int i = 0;
                while (i < this.cachedList.length) {
                    if (this.cachedList[i].getName().equals(child.getName())) {
                        return i;
                    }
                    ++i;
                }
            } else {
                int index = 0;
                int i = 0;
                while (i < this.cachedList.length) {
                    if (!this.cachedList[i].isFile()) {
                        if (this.cachedList[i].getName().equals(child.getName())) {
                            return index;
                        }
                        ++index;
                    }
                    ++i;
                }
            }
            return 0;
        }

        public Object getRoot() {
            return RepositoryModelImpl.this.base;
        }

        public boolean isLeaf(Object obj) {
            FileModel fm = (FileModel)obj;
            if (RepositoryModelImpl.this.showMixed) {
                return fm.isFile();
            }
            return false;
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this.treelistener.remove(l);
        }

        public void valueForPathChanged(TreePath arg0, Object arg1) {
        }

        public void fireTreeUpdate() {
            this.clearCache();
            Iterator i = ((ArrayList)this.treelistener.clone()).iterator();
            while (i.hasNext()) {
                TreeModelListener tml = (TreeModelListener)i.next();
                Object[] fm = new FileModel[]{RepositoryModelImpl.this.base};
                tml.treeStructureChanged(new TreeModelEvent((Object)this, fm));
            }
        }

        private void updateCache(FileModel fm) {
            int i = 0;
            while (i < this.cacheSize) {
                if (this.totalCachedModels[i] == fm) {
                    this.cachedModel = fm;
                    this.cachedList = this.totalCachedLists[i];
                    return;
                }
                ++i;
            }
            ++this.lastCacheInsert;
            if (this.lastCacheInsert >= this.cacheSize) {
                this.lastCacheInsert = 0;
            }
            this.totalCachedModels[this.lastCacheInsert] = fm;
            if (!fm.isFile()) {
                try {
                    this.totalCachedLists[this.lastCacheInsert] = RepositoryModelImpl.this.filterAndSortFileModelList(fm.getChildren());
                }
                catch (FileModelException e) {
                    this.totalCachedLists[this.lastCacheInsert] = new FileModel[0];
                }
            } else {
                this.totalCachedLists[this.lastCacheInsert] = new FileModel[0];
            }
            this.cachedList = this.totalCachedLists[this.lastCacheInsert];
            this.cachedModel = fm;
            this.cachedList = this.totalCachedLists[this.lastCacheInsert];
        }

        public void clearCache() {
            int i = 0;
            while (i < this.cacheSize) {
                this.totalCachedLists[i] = null;
                this.totalCachedModels[i] = null;
                ++i;
            }
        }

        public void fireSelectedNodeUpdate() {
            ArrayList<FileModel> list = new ArrayList<FileModel>();
            FileModel p = RepositoryModelImpl.this.selectedModel;
            if (!p.exists()) {
                try {
                    p = p.getParent();
                }
                catch (FileModelException e) {
                    e.printStackTrace();
                }
            }
            while (p != null && p != RepositoryModelImpl.this.base) {
                list.add(p);
                try {
                    p = p.getParent();
                }
                catch (FileModelException e) {
                    e.printStackTrace();
                }
            }
            list.add(RepositoryModelImpl.this.base);
            Collections.reverse(list);
            Object[] path = list.toArray();
            TreeModelEvent event = new TreeModelEvent((Object)this, path);
            Iterator i = this.treelistener.iterator();
            while (i.hasNext()) {
                TreeModelListener l = (TreeModelListener)i.next();
                l.treeStructureChanged(event);
            }
        }
    }

    public class RepositoryTableModel
    implements TableModel {
        private Boolean isFile = new Boolean(true);
        private Boolean isDirectory = new Boolean(false);
        private ArrayList tablelistener = new ArrayList();
        private NumberFormat sizeformat = NumberFormat.getInstance();
        private SimpleDateFormat dateformat = this.dateformat = new SimpleDateFormat(" EEE, dd. MMM yyyy hh:mm:ss");
        private Date date = new Date();
        private String parentDir = "..";

        public void addTableModelListener(TableModelListener arg0) {
            this.tablelistener.add(arg0);
        }

        public Class getColumnClass(int arg0) {
            return "".getClass();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int arg0) {
            switch (arg0) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return LocaleImpl.getInstance().getString("panel.filesystem.table.column.name");
                }
                case 2: {
                    return LocaleImpl.getInstance().getString("panel.filesystem.table.column.size");
                }
                case 3: {
                    return LocaleImpl.getInstance().getString("panel.filesystem.table.column.modifieddate");
                }
            }
            return "";
        }

        public int getRowCount() {
            return RepositoryModelImpl.this.currentList.length + 1;
        }

        public Object getValueAt(int row, int column) {
            if (row == 0) {
                switch (column) {
                    case 0: {
                        return this.isDirectory;
                    }
                    case 1: {
                        return this.parentDir;
                    }
                    case 2: {
                        return "";
                    }
                    case 3: {
                        return "";
                    }
                }
            }
            FileModel fm = RepositoryModelImpl.this.currentList[row - 1];
            switch (column) {
                case 0: {
                    if (fm.isFile()) {
                        return this.isFile;
                    }
                    return this.isDirectory;
                }
                case 1: {
                    return fm.getName();
                }
                case 2: {
                    if (fm.isFile()) {
                        return this.sizeformat.format(fm.getLength());
                    }
                    return "";
                }
                case 3: {
                    this.date.setTime(fm.lastModified());
                    return this.dateformat.format(this.date);
                }
            }
            return "";
        }

        public boolean isCellEditable(int row, int column) {
            return column == 1 && row > 0;
        }

        public void removeTableModelListener(TableModelListener l) {
            this.tablelistener.remove(l);
        }

        public void setValueAt(Object obj, int arg1, int arg2) {
            if (arg2 == 1 && obj != null) {
                String name = (String)obj;
                FileModel fm = RepositoryModelImpl.this.currentList[arg1 - 1];
                fm.renameTo(name);
            }
        }

        public void fireTableUpdate() {
            RepositoryModelImpl.this.filterAndSortFileModelList(RepositoryModelImpl.this.currentList);
            Iterator i = ((ArrayList)this.tablelistener.clone()).iterator();
            while (i.hasNext()) {
                TableModelListener l = (TableModelListener)i.next();
                l.tableChanged(new TableModelEvent(this));
            }
        }
    }

    private class CacheEntry {
        long timestamp;
        private SoftReference modelList;
        private SoftReference model;

        public CacheEntry(FileModel parent) {
            this.setFileModel(parent);
        }

        public boolean valid(long timestamp) {
            Object obj = this.model.get();
            return timestamp == this.timestamp && obj != null;
        }

        public FileModel[] getChildren() {
            Object obj = this.modelList.get();
            if (obj != null) {
                return (FileModel[])obj;
            }
            obj = this.model.get();
            if (obj != null) {
                try {
                    FileModel[] children = ((FileModel)obj).getChildren();
                    this.modelList = new SoftReference<FileModel[]>(children);
                    return children;
                }
                catch (FileModelException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public void setFileModel(FileModel parent) {
            this.model = new SoftReference<FileModel>(parent);
            this.timestamp = parent.lastModified();
            if (!parent.isFile()) {
                try {
                    this.modelList = new SoftReference<FileModel[]>(parent.getChildren());
                }
                catch (FileModelException fileModelException) {}
            } else {
                this.modelList = new SoftReference<FileModel[]>(new FileModel[0]);
            }
        }
    }
}

