/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class GradientLabel
extends JComponent {
    private String text = "";
    private int margin = 15;
    private int paddingLeft = 30;
    private int fontHeight = 28;
    private int textLength = 0;
    private int descent = 0;
    private Font font;
    private GradientPaint gradient;
    private Dimension dim;
    private Color startColor = new Color(66, 66, 66);
    private Color endColor = new Color(230, 230, 230);
    private Color textColor = Color.WHITE;
    private Color blue = new Color(91, 110, 179);

    public GradientLabel(String text) {
        this.font = new Font("SansSerif", 1, this.fontHeight);
        this.setText(text);
    }

    public GradientLabel() {
        this("");
    }

    public void setText(String text) {
        this.text = text;
        this.layoutText();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.dim;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        int gy = height / 2;
        this.gradient = new GradientPaint(0.0f, gy, this.startColor, (int)((double)width * 0.8), gy, this.endColor);
        g2.setPaint(this.gradient);
        g2.fillRect(0, 0, width, height);
        g2.setFont(this.font);
        g2.setColor(this.textColor);
        g2.drawString(this.text, this.margin, gy + this.fontHeight / 2 - this.descent);
        int y = this.fontHeight + this.margin * 2 - 1;
        g2.setColor(Color.GRAY);
        g2.drawLine(0, height - 1, width - 1, height - 1);
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setEndColor(Color endColor) {
        this.endColor = endColor;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public void setFontHeight(int fontHeight) {
        this.fontHeight = fontHeight;
        this.font = new Font("SansSerif", 1, fontHeight);
        this.layoutText();
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public void setStartColor(Color startColor) {
        this.startColor = startColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    private void layoutText() {
        FontMetrics fm = this.getFontMetrics(this.font);
        this.fontHeight = fm.getHeight();
        this.textLength = fm.stringWidth(this.text);
        this.descent = fm.getDescent();
        this.dim = new Dimension(this.paddingLeft + this.textLength + this.margin, this.fontHeight + this.margin * 2);
    }

    public void setMargin(int margin) {
        this.margin = margin;
        this.layoutText();
    }

    public void setLeftPadding(int padding) {
        this.paddingLeft = padding;
    }
}

