/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import com.neuronrobotics.interaction.CadInteractionEvent;
import eu.mihosoft.vrl.v3d.Bounds;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.ICSGProgress;
import eu.mihosoft.vrl.v3d.MeshContainer;
import eu.mihosoft.vrl.v3d.Modifier;
import eu.mihosoft.vrl.v3d.Node;
import eu.mihosoft.vrl.v3d.ObjFile;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.PrepForManufacturing;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.WeightFunction;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.HullUtil;
import eu.mihosoft.vrl.v3d.parametrics.CSGDatabase;
import eu.mihosoft.vrl.v3d.parametrics.IParametric;
import eu.mihosoft.vrl.v3d.parametrics.IRegenerate;
import eu.mihosoft.vrl.v3d.parametrics.LengthParameter;
import eu.mihosoft.vrl.v3d.parametrics.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Affine;

public class CSG {
    private List<Polygon> polygons;
    private static OptType defaultOptType = OptType.CSG_BOUND;
    private OptType optType = null;
    private PropertyStorage storage;
    private MeshView current;
    private static Color defaultcolor = Color.web((String)"#007956");
    private Color color = CSG.getDefaultColor();
    private Affine manipulator;
    private Bounds bounds;
    private final Exception creationEventStackTrace = new Exception();
    public static final int INDEX_OF_PARAMETRIC_DEFAULT = 0;
    public static final int INDEX_OF_PARAMETRIC_LOWER = 1;
    public static final int INDEX_OF_PARAMETRIC_UPPER = 2;
    private ArrayList<String> groovyFileLines = new ArrayList();
    private PrepForManufacturing manufactuing = null;
    private HashMap<String, IParametric> mapOfparametrics = null;
    private IRegenerate regenerate = null;
    private boolean markForRegeneration = false;
    private String name = "";
    private ArrayList<Transform> slicePlanes = null;
    private ArrayList<String> exportFormats = null;
    private static ICSGProgress progressMoniter = new ICSGProgress(){

        @Override
        public void progressUpdate(int currentIndex, int finalIndex, String type, CSG intermediateShape) {
            System.out.println(type + "ing " + currentIndex + " of " + finalIndex);
        }
    };

    public CSG() {
        this.storage = new PropertyStorage();
        this.addStackTrace(this.creationEventStackTrace);
    }

    public Color getColor() {
        return this.color;
    }

    public CSG setColor(Color color) {
        this.color = color;
        if (this.current != null) {
            PhongMaterial m = new PhongMaterial(this.getColor());
            this.current.setMaterial((Material)m);
        }
        return this;
    }

    public CSG setManipulator(Affine manipulator) {
        if (manipulator == null) {
            return this;
        }
        Affine old = manipulator;
        this.manipulator = manipulator;
        if (this.current != null) {
            this.current.getTransforms().clear();
            this.current.getTransforms().add((Object)manipulator);
        }
        return this;
    }

    public MeshView getMesh() {
        if (this.current != null) {
            return this.current;
        }
        MeshContainer meshContainer = this.toJavaFXMesh(null);
        this.current = meshContainer.getAsMeshViews().get(0);
        PhongMaterial m = new PhongMaterial(this.getColor());
        this.current.setMaterial((Material)m);
        if (this.getManipulator() != null) {
            this.current.getTransforms().clear();
            this.current.getTransforms().add((Object)this.getManipulator());
        }
        this.current.setCullFace(CullFace.NONE);
        return this.current;
    }

    public CSG toZMin(CSG target) {
        return this.transformed(new Transform().translateZ(-target.getBounds().getMin().z));
    }

    public CSG toZMax(CSG target) {
        return this.transformed(new Transform().translateZ(-target.getBounds().getMax().z));
    }

    public CSG toXMin(CSG target) {
        return this.transformed(new Transform().translateX(-target.getBounds().getMin().x));
    }

    public CSG toXMax(CSG target) {
        return this.transformed(new Transform().translateX(-target.getBounds().getMax().x));
    }

    public CSG toYMin(CSG target) {
        return this.transformed(new Transform().translateY(-target.getBounds().getMin().y));
    }

    public CSG toYMax(CSG target) {
        return this.transformed(new Transform().translateY(-target.getBounds().getMax().y));
    }

    public CSG toZMin() {
        return this.toZMin(this);
    }

    public CSG toZMax() {
        return this.toZMax(this);
    }

    public CSG toXMin() {
        return this.toXMin(this);
    }

    public CSG toXMax() {
        return this.toXMax(this);
    }

    public CSG toYMin() {
        return this.toYMin(this);
    }

    public CSG toYMax() {
        return this.toYMax(this);
    }

    public CSG move(double x, double y, double z) {
        return this.transformed(new Transform().translate(x, y, z));
    }

    public CSG move(Vertex v) {
        return this.transformed(new Transform().translate(v.getX(), v.getY(), v.getZ()));
    }

    public CSG move(Vector3d v) {
        return this.transformed(new Transform().translate(v.x, v.y, v.z));
    }

    public CSG move(double[] posVector) {
        return this.move(posVector[0], posVector[1], posVector[2]);
    }

    public CSG movey(double howFarToMove) {
        return this.transformed(Transform.unity().translateY(howFarToMove));
    }

    public CSG movez(double howFarToMove) {
        return this.transformed(Transform.unity().translateZ(howFarToMove));
    }

    public CSG movex(double howFarToMove) {
        return this.transformed(Transform.unity().translateX(howFarToMove));
    }

    public CSG mirrory() {
        return this.scaley(-1.0);
    }

    public CSG mirrorz() {
        return this.scalez(-1.0);
    }

    public CSG mirrorx() {
        return this.scalex(-1.0);
    }

    public CSG rot(double x, double y, double z) {
        return this.rotx(x).roty(y).rotz(z);
    }

    public CSG rot(double[] posVector) {
        return this.rot(posVector[0], posVector[1], posVector[2]);
    }

    public CSG rotz(double degreesToRotate) {
        return this.transformed(new Transform().rotZ(degreesToRotate));
    }

    public CSG roty(double degreesToRotate) {
        return this.transformed(new Transform().rotY(degreesToRotate));
    }

    public CSG rotx(double degreesToRotate) {
        return this.transformed(new Transform().rotX(degreesToRotate));
    }

    public CSG scalez(double scaleValue) {
        return this.transformed(new Transform().scaleZ(scaleValue));
    }

    public CSG scaley(double scaleValue) {
        return this.transformed(new Transform().scaleY(scaleValue));
    }

    public CSG scalex(double scaleValue) {
        return this.transformed(new Transform().scaleX(scaleValue));
    }

    public CSG scale(double scaleValue) {
        return this.transformed(new Transform().scale(scaleValue));
    }

    public static CSG fromPolygons(List<Polygon> polygons) {
        CSG csg = new CSG();
        csg.setPolygons(polygons);
        return csg;
    }

    public static CSG fromPolygons(Polygon ... polygons) {
        return CSG.fromPolygons(Arrays.asList(polygons));
    }

    public static CSG fromPolygons(PropertyStorage storage, List<Polygon> polygons) {
        CSG csg = new CSG();
        csg.setPolygons(polygons);
        csg.storage = storage;
        for (Polygon polygon : polygons) {
            polygon.setStorage(storage);
        }
        return csg;
    }

    public static CSG fromPolygons(PropertyStorage storage, Polygon ... polygons) {
        return CSG.fromPolygons(storage, Arrays.asList(polygons));
    }

    public CSG clone() {
        CSG csg = new CSG();
        csg.setOptType(this.getOptType());
        Stream polygonStream = this.getPolygons().size() > 200 ? this.getPolygons().parallelStream() : this.getPolygons().stream();
        csg.setPolygons(polygonStream.map(p -> p.clone()).collect(Collectors.toList()));
        return csg.historySync(this);
    }

    public List<Polygon> getPolygons() {
        return this.polygons;
    }

    public CSG optimization(OptType type) {
        this.setOptType(type);
        return this;
    }

    public CSG union(CSG csg) {
        switch (this.getOptType()) {
            case CSG_BOUND: {
                return this._unionCSGBoundsOpt(csg).historySync(this).historySync(csg);
            }
            case POLYGON_BOUND: {
                return this._unionPolygonBoundsOpt(csg).historySync(this).historySync(csg);
            }
        }
        return this._unionNoOpt(csg).historySync(this).historySync(csg);
    }

    public CSG dumbUnion(CSG csg) {
        CSG result = this.clone();
        CSG other = csg.clone();
        result.getPolygons().addAll(other.getPolygons());
        this.bounds = null;
        return result.historySync(other);
    }

    public CSG union(List<CSG> csgs) {
        CSG result = this;
        for (int i = 0; i < csgs.size(); ++i) {
            CSG csg = csgs.get(i);
            result = result.union(csg);
            progressMoniter.progressUpdate(i, csgs.size(), "Union", result);
        }
        return result;
    }

    public CSG union(CSG ... csgs) {
        return this.union(Arrays.asList(csgs));
    }

    public CSG hull() {
        return HullUtil.hull(this, this.storage).historySync(this);
    }

    public static CSG unionAll(CSG ... csgs) {
        return CSG.unionAll(Arrays.asList(csgs));
    }

    public static CSG unionAll(List<CSG> csgs) {
        CSG first = csgs.remove(0);
        return first.union(csgs);
    }

    public static CSG hullAll(CSG ... csgs) {
        return CSG.hullAll(Arrays.asList(csgs));
    }

    public static CSG hullAll(List<CSG> csgs) {
        CSG first = csgs.remove(0);
        return first.hull(csgs);
    }

    public CSG hull(List<CSG> csgs) {
        CSG csgsUnion = new CSG();
        csgsUnion.storage = this.storage;
        csgsUnion.optType = this.optType;
        csgsUnion.setPolygons(this.clone().getPolygons());
        csgs.stream().forEach(csg -> {
            csgsUnion.getPolygons().addAll(csg.clone().getPolygons());
            csgsUnion.historySync((CSG)csg);
        });
        csgsUnion.getPolygons().forEach(p -> p.setStorage(this.storage));
        this.bounds = null;
        return csgsUnion.hull();
    }

    public CSG hull(CSG ... csgs) {
        return this.hull(Arrays.asList(csgs));
    }

    private CSG _unionCSGBoundsOpt(CSG csg) {
        return this._unionIntersectOpt(csg);
    }

    private CSG _unionPolygonBoundsOpt(CSG csg) {
        ArrayList<Polygon> inner = new ArrayList<Polygon>();
        ArrayList outer = new ArrayList();
        Bounds b = csg.getBounds();
        this.getPolygons().stream().forEach(p -> {
            if (b.intersects(p.getBounds())) {
                inner.add((Polygon)p);
            } else {
                outer.add(p);
            }
        });
        ArrayList<Polygon> allPolygons = new ArrayList<Polygon>();
        if (!inner.isEmpty()) {
            CSG innerCSG = CSG.fromPolygons(inner);
            allPolygons.addAll(outer);
            allPolygons.addAll(innerCSG._unionNoOpt(csg).getPolygons());
        } else {
            allPolygons.addAll(this.getPolygons());
            allPolygons.addAll(csg.getPolygons());
        }
        this.bounds = null;
        return CSG.fromPolygons(allPolygons).optimization(this.getOptType());
    }

    private CSG _unionIntersectOpt(CSG csg) {
        boolean intersects = false;
        Bounds bounds = csg.getBounds();
        for (Polygon p : this.getPolygons()) {
            if (!bounds.intersects(p.getBounds())) continue;
            intersects = true;
            break;
        }
        ArrayList<Polygon> allPolygons = new ArrayList<Polygon>();
        if (intersects) {
            return this._unionNoOpt(csg);
        }
        allPolygons.addAll(this.getPolygons());
        allPolygons.addAll(csg.getPolygons());
        return CSG.fromPolygons(allPolygons).optimization(this.getOptType());
    }

    private CSG _unionNoOpt(CSG csg) {
        Node a = new Node(this.clone().getPolygons());
        Node b = new Node(csg.clone().getPolygons());
        a.clipTo(b);
        b.clipTo(a);
        b.invert();
        b.clipTo(a);
        b.invert();
        a.build(b.allPolygons());
        return CSG.fromPolygons(a.allPolygons()).optimization(this.getOptType());
    }

    public CSG difference(List<CSG> csgs) {
        if (csgs.isEmpty()) {
            return this.clone();
        }
        CSG csgsUnion = csgs.get(0);
        for (int i = 1; i < csgs.size(); ++i) {
            csgsUnion = csgsUnion.union(csgs.get(i));
            progressMoniter.progressUpdate(i, csgs.size(), "Difference", csgsUnion);
            csgsUnion.historySync(csgs.get(i));
        }
        return this.difference(csgsUnion);
    }

    public CSG difference(CSG ... csgs) {
        return this.difference(Arrays.asList(csgs));
    }

    public CSG difference(CSG csg) {
        try {
            if (this.getPolygons().size() > 0 && csg.getPolygons().size() > 0) {
                switch (this.getOptType()) {
                    case CSG_BOUND: {
                        return this._differenceCSGBoundsOpt(csg).historySync(this).historySync(csg);
                    }
                    case POLYGON_BOUND: {
                        return this._differencePolygonBoundsOpt(csg).historySync(this).historySync(csg);
                    }
                }
                return this._differenceNoOpt(csg).historySync(this).historySync(csg);
            }
            return this;
        }
        catch (Exception ex) {
            System.err.println("CSG difference failed, performing workaround");
            CSG intersectingParts = csg.intersect(this);
            if (intersectingParts.getPolygons().size() > 0) {
                switch (this.getOptType()) {
                    case CSG_BOUND: {
                        return this._differenceCSGBoundsOpt(intersectingParts).historySync(this).historySync(intersectingParts);
                    }
                    case POLYGON_BOUND: {
                        return this._differencePolygonBoundsOpt(intersectingParts).historySync(this).historySync(intersectingParts);
                    }
                }
                return this._differenceNoOpt(intersectingParts).historySync(this).historySync(intersectingParts);
            }
            return this;
        }
    }

    private CSG _differenceCSGBoundsOpt(CSG csg) {
        CSG b = csg;
        CSG a1 = this._differenceNoOpt(csg.getBounds().toCSG());
        CSG a2 = this.intersect(csg.getBounds().toCSG());
        return a2._differenceNoOpt(b)._unionIntersectOpt(a1).optimization(this.getOptType());
    }

    private CSG _differencePolygonBoundsOpt(CSG csg) {
        ArrayList<Polygon> inner = new ArrayList<Polygon>();
        ArrayList outer = new ArrayList();
        Bounds bounds = csg.getBounds();
        this.getPolygons().stream().forEach(p -> {
            if (bounds.intersects(p.getBounds())) {
                inner.add((Polygon)p);
            } else {
                outer.add(p);
            }
        });
        CSG innerCSG = CSG.fromPolygons(inner);
        ArrayList<Polygon> allPolygons = new ArrayList<Polygon>();
        allPolygons.addAll(outer);
        allPolygons.addAll(innerCSG._differenceNoOpt(csg).getPolygons());
        return CSG.fromPolygons(allPolygons).optimization(this.getOptType());
    }

    private CSG _differenceNoOpt(CSG csg) {
        Node a = new Node(this.clone().getPolygons());
        Node b = new Node(csg.clone().getPolygons());
        a.invert();
        a.clipTo(b);
        b.clipTo(a);
        b.invert();
        b.clipTo(a);
        b.invert();
        a.build(b.allPolygons());
        a.invert();
        CSG csgA = CSG.fromPolygons(a.allPolygons()).optimization(this.getOptType());
        return csgA;
    }

    public CSG intersect(CSG csg) {
        Node a = new Node(this.clone().getPolygons());
        Node b = new Node(csg.clone().getPolygons());
        a.invert();
        b.clipTo(a);
        b.invert();
        a.clipTo(b);
        b.clipTo(a);
        a.build(b.allPolygons());
        a.invert();
        return CSG.fromPolygons(a.allPolygons()).optimization(this.getOptType()).historySync(csg).historySync(this);
    }

    public CSG intersect(List<CSG> csgs) {
        if (csgs.isEmpty()) {
            return this.clone();
        }
        CSG csgsUnion = csgs.get(0);
        for (int i = 1; i < csgs.size(); ++i) {
            csgsUnion = csgsUnion.union(csgs.get(i));
            progressMoniter.progressUpdate(i, csgs.size(), "Intersect", csgsUnion);
            csgsUnion.historySync(csgs.get(i));
        }
        return this.intersect(csgsUnion);
    }

    public CSG intersect(CSG ... csgs) {
        return this.intersect(Arrays.asList(csgs));
    }

    public String toStlString() {
        StringBuilder sb = new StringBuilder();
        this.toStlString(sb);
        return sb.toString();
    }

    public StringBuilder toStlString(StringBuilder sb) {
        sb.append("solid v3d.csg\n");
        this.getPolygons().stream().forEach(p -> p.toStlString(sb));
        sb.append("endsolid v3d.csg\n");
        return sb;
    }

    public CSG color(Color c) {
        this.storage.set("material:color", "" + c.getRed() + " " + c.getGreen() + " " + c.getBlue());
        return this;
    }

    public ObjFile toObj() {
        StringBuilder objSb = new StringBuilder();
        objSb.append("mtllib $JCSG_MTL_NAME$");
        objSb.append("# Group").append("\n");
        objSb.append("g v3d.csg\n");
        ArrayList vertices = new ArrayList();
        class PolygonStruct {
            PropertyStorage storage;
            List<Integer> indices;
            String materialName;

            public PolygonStruct(PropertyStorage storage, List<Integer> indices, String materialName) {
                this.storage = storage;
                this.indices = indices;
                this.materialName = materialName;
            }
        }
        ArrayList<PolygonStruct> indices = new ArrayList<PolygonStruct>();
        objSb.append("\n# Vertices\n");
        HashMap<PropertyStorage, Integer> materialNames = new HashMap<PropertyStorage, Integer>();
        int materialIndex = 0;
        for (Polygon p : this.getPolygons()) {
            ArrayList<Integer> polyIndices = new ArrayList<Integer>();
            p.vertices.stream().forEach(v -> {
                if (!vertices.contains(v)) {
                    vertices.add(v);
                    v.toObjString(objSb);
                    polyIndices.add(vertices.size());
                } else {
                    polyIndices.add(vertices.indexOf(v) + 1);
                }
            });
            if (!materialNames.containsKey(p.getStorage())) {
                materialNames.put(p.getStorage(), ++materialIndex);
                p.getStorage().set("material:name", materialIndex);
            }
            indices.add(new PolygonStruct(p.getStorage(), polyIndices, "material-" + materialNames.get(p.getStorage())));
        }
        objSb.append("\n# Faces").append("\n");
        for (PolygonStruct ps : indices) {
            ps.storage.getValue("material:color").ifPresent(v -> objSb.append("usemtl ").append(ps.materialName).append("\n"));
            List<Integer> pVerts = ps.indices;
            int index1 = pVerts.get(0);
            for (int i = 0; i < pVerts.size() - 2; ++i) {
                int index2 = pVerts.get(i + 1);
                int index3 = pVerts.get(i + 2);
                objSb.append("f ").append(index1).append(" ").append(index2).append(" ").append(index3).append("\n");
            }
        }
        objSb.append("\n# End Group v3d.csg").append("\n");
        StringBuilder mtlSb = new StringBuilder();
        materialNames.keySet().forEach(s -> {
            if (s.contains("material:color")) {
                mtlSb.append("newmtl material-").append(s.getValue("material:name").get()).append("\n");
                mtlSb.append("Kd ").append(s.getValue("material:color").get()).append("\n");
            }
        });
        return new ObjFile(objSb.toString(), mtlSb.toString());
    }

    public StringBuilder toObjString(StringBuilder sb) {
        sb.append("# Group").append("\n");
        sb.append("g v3d.csg\n");
        ArrayList vertices = new ArrayList();
        ArrayList indices = new ArrayList();
        sb.append("\n# Vertices\n");
        for (Polygon p : this.getPolygons()) {
            ArrayList polyIndices = new ArrayList();
            p.vertices.stream().forEach(v -> {
                if (!vertices.contains(v)) {
                    vertices.add(v);
                    v.toObjString(sb);
                    polyIndices.add(vertices.size());
                } else {
                    polyIndices.add(vertices.indexOf(v) + 1);
                }
            });
        }
        sb.append("\n# Faces").append("\n");
        class PolygonStruct {
            PropertyStorage storage;
            List<Integer> indices;
            String materialName;

            public PolygonStruct(PropertyStorage storage, List<Integer> indices, String materialName) {
                this.storage = storage;
                this.indices = indices;
                this.materialName = materialName;
            }
        }
        for (PolygonStruct ps : indices) {
            List<Integer> pVerts = ps.indices;
            int index1 = pVerts.get(0);
            for (int i = 0; i < pVerts.size() - 2; ++i) {
                int index2 = pVerts.get(i + 1);
                int index3 = pVerts.get(i + 2);
                sb.append("f ").append(index1).append(" ").append(index2).append(" ").append(index3).append("\n");
            }
        }
        sb.append("\n# End Group v3d.csg").append("\n");
        return sb;
    }

    public String toObjString() {
        StringBuilder sb = new StringBuilder();
        return this.toObjString(sb).toString();
    }

    public CSG weighted(WeightFunction f) {
        return new Modifier(f).modified(this);
    }

    public CSG transformed(Transform transform) {
        if (this.getPolygons().isEmpty()) {
            return this.clone();
        }
        List<Polygon> newpolygons = this.getPolygons().stream().map(p -> p.transformed(transform)).collect(Collectors.toList());
        CSG result = CSG.fromPolygons(newpolygons).optimization(this.getOptType());
        result.storage = this.storage;
        return result.historySync(this);
    }

    public MeshContainer toJavaFXMesh(CadInteractionEvent interact) {
        return this.toJavaFXMeshSimple(interact);
    }

    public MeshContainer toJavaFXMeshSimple(CadInteractionEvent interact) {
        TriangleMesh mesh = new TriangleMesh();
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        int counter = 0;
        for (Polygon p : this.getPolygons()) {
            if (p.vertices.size() < 3) continue;
            Vertex firstVertex = p.vertices.get(0);
            for (int i = 0; i < p.vertices.size() - 2; ++i) {
                if (firstVertex.pos.x < minX) {
                    minX = firstVertex.pos.x;
                }
                if (firstVertex.pos.y < minY) {
                    minY = firstVertex.pos.y;
                }
                if (firstVertex.pos.z < minZ) {
                    minZ = firstVertex.pos.z;
                }
                if (firstVertex.pos.x > maxX) {
                    maxX = firstVertex.pos.x;
                }
                if (firstVertex.pos.y > maxY) {
                    maxY = firstVertex.pos.y;
                }
                if (firstVertex.pos.z > maxZ) {
                    maxZ = firstVertex.pos.z;
                }
                mesh.getPoints().addAll(new float[]{(float)firstVertex.pos.x, (float)firstVertex.pos.y, (float)firstVertex.pos.z});
                mesh.getTexCoords().addAll(new float[]{0.0f});
                mesh.getTexCoords().addAll(new float[]{0.0f});
                Vertex secondVertex = p.vertices.get(i + 1);
                if (secondVertex.pos.x < minX) {
                    minX = secondVertex.pos.x;
                }
                if (secondVertex.pos.y < minY) {
                    minY = secondVertex.pos.y;
                }
                if (secondVertex.pos.z < minZ) {
                    minZ = secondVertex.pos.z;
                }
                if (secondVertex.pos.x > maxX) {
                    maxX = firstVertex.pos.x;
                }
                if (secondVertex.pos.y > maxY) {
                    maxY = firstVertex.pos.y;
                }
                if (secondVertex.pos.z > maxZ) {
                    maxZ = firstVertex.pos.z;
                }
                mesh.getPoints().addAll(new float[]{(float)secondVertex.pos.x, (float)secondVertex.pos.y, (float)secondVertex.pos.z});
                mesh.getTexCoords().addAll(new float[]{0.0f});
                mesh.getTexCoords().addAll(new float[]{0.0f});
                Vertex thirdVertex = p.vertices.get(i + 2);
                mesh.getPoints().addAll(new float[]{(float)thirdVertex.pos.x, (float)thirdVertex.pos.y, (float)thirdVertex.pos.z});
                if (thirdVertex.pos.x < minX) {
                    minX = thirdVertex.pos.x;
                }
                if (thirdVertex.pos.y < minY) {
                    minY = thirdVertex.pos.y;
                }
                if (thirdVertex.pos.z < minZ) {
                    minZ = thirdVertex.pos.z;
                }
                if (thirdVertex.pos.x > maxX) {
                    maxX = firstVertex.pos.x;
                }
                if (thirdVertex.pos.y > maxY) {
                    maxY = firstVertex.pos.y;
                }
                if (thirdVertex.pos.z > maxZ) {
                    maxZ = firstVertex.pos.z;
                }
                mesh.getTexCoords().addAll(new float[]{0.0f});
                mesh.getTexCoords().addAll(new float[]{0.0f});
                mesh.getFaces().addAll(new int[]{counter, 0, counter + 1, 0, counter + 2, 0});
                counter += 3;
            }
        }
        return new MeshContainer(new Vector3d(minX, minY, minZ), new Vector3d(maxX, maxY, maxZ), new Mesh[]{mesh});
    }

    public Bounds getBounds() {
        if (this.bounds != null) {
            return this.bounds;
        }
        if (this.getPolygons().isEmpty()) {
            this.bounds = new Bounds(Vector3d.ZERO, Vector3d.ZERO);
            return this.bounds;
        }
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (Polygon p : this.getPolygons()) {
            for (int i = 0; i < p.vertices.size(); ++i) {
                Vertex vert = p.vertices.get(i);
                if (vert.pos.x < minX) {
                    minX = vert.pos.x;
                }
                if (vert.pos.y < minY) {
                    minY = vert.pos.y;
                }
                if (vert.pos.z < minZ) {
                    minZ = vert.pos.z;
                }
                if (vert.pos.x > maxX) {
                    maxX = vert.pos.x;
                }
                if (vert.pos.y > maxY) {
                    maxY = vert.pos.y;
                }
                if (!(vert.pos.z > maxZ)) continue;
                maxZ = vert.pos.z;
            }
        }
        this.bounds = new Bounds(new Vector3d(minX, minY, minZ), new Vector3d(maxX, maxY, maxZ));
        return this.bounds;
    }

    public Vector3d getCenter() {
        return new Vector3d(this.getCenterX(), this.getCenterY(), this.getCenterZ());
    }

    public double getCenterX() {
        return this.getMinX() / 2.0 + this.getMaxX() / 2.0;
    }

    public double getCenterY() {
        return this.getMinY() / 2.0 + this.getMaxY() / 2.0;
    }

    public double getCenterZ() {
        return this.getMinZ() / 2.0 + this.getMaxZ() / 2.0;
    }

    public double getMaxX() {
        return this.getBounds().getMax().x;
    }

    public double getMaxY() {
        return this.getBounds().getMax().y;
    }

    public double getMaxZ() {
        return this.getBounds().getMax().z;
    }

    public double getMinX() {
        return this.getBounds().getMin().x;
    }

    public double getMinY() {
        return this.getBounds().getMin().y;
    }

    public double getMinZ() {
        return this.getBounds().getMin().z;
    }

    public double getTotalX() {
        return -this.getMinX() + this.getMaxX();
    }

    public double getTotalY() {
        return -this.getMinY() + this.getMaxY();
    }

    public double getTotalZ() {
        return -this.getMinZ() + this.getMaxZ();
    }

    private OptType getOptType() {
        return this.optType != null ? this.optType : defaultOptType;
    }

    public static void setDefaultOptType(OptType optType) {
        defaultOptType = optType;
    }

    public void setOptType(OptType optType) {
        this.optType = optType;
    }

    public void setPolygons(List<Polygon> polygons) {
        this.bounds = null;
        this.polygons = polygons;
    }

    @Deprecated
    public ArrayList<CSG> minovsky(CSG travelingShape) {
        System.out.println("Hail Zeon!");
        return this.minkowski(travelingShape);
    }

    public ArrayList<CSG> mink(CSG travelingShape) {
        return this.minkowski(travelingShape);
    }

    public ArrayList<CSG> minkowski(CSG travelingShape) {
        HashMap<Vertex, CSG> map = new HashMap<Vertex, CSG>();
        for (Polygon p : travelingShape.getPolygons()) {
            for (Vertex v : p.vertices) {
                if (map.get(v) != null) continue;
                map.put(v, this.move(v));
            }
        }
        return new ArrayList<CSG>(map.values());
    }

    public CSG minkowskiDifference(CSG itemToDifference, CSG minkowskiObject) {
        CSG intersection = this.intersect(itemToDifference);
        ArrayList<CSG> csgDiff = intersection.mink(minkowskiObject);
        CSG result = this;
        for (int i = 0; i < csgDiff.size(); ++i) {
            result = result.difference(csgDiff.get(i));
            progressMoniter.progressUpdate(i, csgDiff.size(), "Minkowski difference", result);
        }
        return result;
    }

    public CSG minkowskiDifference(CSG itemToDifference, double tolerance) {
        double shellThickness = Math.abs(tolerance);
        if (shellThickness < 0.001) {
            return this;
        }
        return this.minkowskiDifference(itemToDifference, new Cube(shellThickness).toCSG());
    }

    public CSG toolOffset(double shellThickness) {
        boolean cut = shellThickness < 0.0;
        if ((shellThickness = Math.abs(shellThickness)) < 0.001) {
            return this;
        }
        CSG printNozzel = new Cube(shellThickness).toCSG();
        if (cut) {
            ArrayList<CSG> mikObjs = this.minkowski(printNozzel);
            CSG remaining = this;
            for (CSG bit : mikObjs) {
                remaining = remaining.intersect(bit);
            }
            return remaining;
        }
        return this.union(this.minkowski(printNozzel));
    }

    public CSG makeKeepaway(double shellThickness) {
        double x = Math.abs(this.getBounds().getMax().x) + Math.abs(this.getBounds().getMin().x);
        double y = Math.abs(this.getBounds().getMax().y) + Math.abs(this.getBounds().getMin().y);
        double z = Math.abs(this.getBounds().getMax().z) + Math.abs(this.getBounds().getMin().z);
        double xtol = (x + shellThickness) / x;
        double ytol = (y + shellThickness) / y;
        double ztol = (z + shellThickness) / z;
        double xPer = -(Math.abs(this.getBounds().getMax().x) - Math.abs(this.getBounds().getMin().x)) / x;
        double yPer = -(Math.abs(this.getBounds().getMax().y) - Math.abs(this.getBounds().getMin().y)) / y;
        double zPer = -(Math.abs(this.getBounds().getMax().z) - Math.abs(this.getBounds().getMin().z)) / z;
        return this.transformed(new Transform().scale(xtol, ytol, ztol)).transformed(new Transform().translateX(shellThickness * xPer)).transformed(new Transform().translateY(shellThickness * yPer)).transformed(new Transform().translateZ(shellThickness * zPer)).historySync(this);
    }

    public Affine getManipulator() {
        if (this.manipulator == null) {
            this.manipulator = new Affine();
        }
        return this.manipulator;
    }

    public CSG addCreationEventStackTraceList(ArrayList<Exception> incoming) {
        for (Exception ex : incoming) {
            this.addStackTrace(ex);
        }
        return this;
    }

    private void addStackTrace(Exception creationEventStackTrace2) {
        for (StackTraceElement el : creationEventStackTrace2.getStackTrace()) {
            try {
                if (el.getFileName().contains(".java") || el.getLineNumber() <= 0) continue;
                boolean dupLine = false;
                String thisline = el.getFileName() + ":" + el.getLineNumber();
                for (String s : this.groovyFileLines) {
                    if (!s.contentEquals(thisline)) continue;
                    dupLine = true;
                    break;
                }
                if (dupLine) continue;
                this.groovyFileLines.add(thisline);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public CSG historySync(CSG dyingCSG) {
        this.addCreationEventStringList(dyingCSG.getCreationEventStackTraceList());
        Set<String> params = dyingCSG.getParameters();
        for (String param : params) {
            Parameter vals;
            boolean existing = false;
            for (String s : this.getParameters()) {
                if (!s.contentEquals(param)) continue;
                existing = true;
            }
            if (existing || (vals = CSGDatabase.get(param)) == null) continue;
            this.setParameter(vals, dyingCSG.getMapOfparametrics().get(param));
        }
        this.setColor(dyingCSG.getColor());
        return this;
    }

    public CSG addCreationEventStringList(ArrayList<String> incoming) {
        for (String s : incoming) {
            this.addCreationEventString(s);
        }
        return this;
    }

    public CSG addCreationEventString(String thisline) {
        boolean dupLine = false;
        for (String s : this.groovyFileLines) {
            if (!s.contentEquals(thisline)) continue;
            dupLine = true;
            break;
        }
        if (!dupLine) {
            this.groovyFileLines.add(thisline);
        }
        return this;
    }

    public ArrayList<String> getCreationEventStackTraceList() {
        return this.groovyFileLines;
    }

    public CSG prepForManufacturing() {
        if (this.getManufacturing() == null) {
            return this;
        }
        return this.getManufacturing().prep(this);
    }

    public CSG prepMfg() {
        return this.prepForManufacturing();
    }

    public PrepForManufacturing getManufacturing() {
        return this.manufactuing;
    }

    public PrepForManufacturing getMfg() {
        return this.getManufacturing();
    }

    public CSG setMfg(PrepForManufacturing manufactuing) {
        return this.setManufacturing(manufactuing);
    }

    public CSG setManufacturing(PrepForManufacturing manufactuing) {
        this.manufactuing = manufactuing;
        return this;
    }

    @Deprecated
    public PrepForManufacturing getManufactuing() {
        return this.getManufacturing();
    }

    @Deprecated
    public CSG setManufactuing(PrepForManufacturing manufactuing) {
        return this.setManufacturing(manufactuing);
    }

    public CSG setParameter(Parameter w, IParametric function) {
        if (w == null) {
            return this;
        }
        if (CSGDatabase.get(w.getName()) == null) {
            CSGDatabase.set(w.getName(), w);
        }
        if (this.getMapOfparametrics().get(w.getName()) == null) {
            this.getMapOfparametrics().put(w.getName(), function);
        }
        return this;
    }

    public CSG setParameter(final Parameter w) {
        this.setParameter(w, new IParametric(){

            @Override
            public CSG change(CSG oldCSG, String parameterKey, Long newValue) {
                if (parameterKey.contentEquals(w.getName())) {
                    CSGDatabase.get(w.getName()).setValue(newValue);
                }
                return oldCSG;
            }
        });
        return this;
    }

    public CSG setParameter(String key, double defaultValue, double upperBound, double lowerBound, IParametric function) {
        ArrayList<Double> vals = new ArrayList<Double>();
        vals.add(upperBound);
        vals.add(lowerBound);
        this.setParameter(new LengthParameter(key, defaultValue, vals), function);
        return this;
    }

    public CSG setParameterIfNull(final String key) {
        if (this.getMapOfparametrics().get(key) == null) {
            this.getMapOfparametrics().put(key, new IParametric(){

                @Override
                public CSG change(CSG oldCSG, String parameterKey, Long newValue) {
                    CSGDatabase.get(key).setValue(newValue);
                    return oldCSG;
                }
            });
        }
        return this;
    }

    public Set<String> getParameters() {
        return this.getMapOfparametrics().keySet();
    }

    public CSG setParameterNewValue(String key, double newValue) {
        IParametric function = this.getMapOfparametrics().get(key);
        if (function != null) {
            return function.change(this, key, new Long((long)(newValue * 1000.0))).setManipulator(this.getManipulator()).setColor(this.getColor());
        }
        return this;
    }

    public CSG setRegenerate(IRegenerate function) {
        this.regenerate = function;
        return this;
    }

    public CSG regenerate() {
        this.markForRegeneration = false;
        if (this.regenerate == null) {
            return this;
        }
        return this.regenerate.regenerate(this).setManipulator(this.getManipulator()).setColor(this.getColor());
    }

    public HashMap<String, IParametric> getMapOfparametrics() {
        if (this.mapOfparametrics == null) {
            this.mapOfparametrics = new HashMap();
        }
        return this.mapOfparametrics;
    }

    public boolean isMarkedForRegeneration() {
        return this.markForRegeneration;
    }

    public void markForRegeneration() {
        this.markForRegeneration = true;
    }

    public boolean touching(CSG incoming) {
        CSG inter;
        return this.getMaxX() > incoming.getMinX() && this.getMinX() < incoming.getMaxX() && this.getMaxY() > incoming.getMinY() && this.getMinY() < incoming.getMaxY() && this.getMaxZ() > incoming.getMinZ() && this.getMinZ() < incoming.getMaxZ() && (inter = this.intersect(incoming)).getPolygons().size() > 0;
    }

    public static ICSGProgress getProgressMoniter() {
        return progressMoniter;
    }

    public static void setProgressMoniter(ICSGProgress progressMoniter) {
        CSG.progressMoniter = progressMoniter;
    }

    public static Color getDefaultColor() {
        return defaultcolor;
    }

    public static void setDefaultColor(Color defaultcolor) {
        CSG.defaultcolor = defaultcolor;
    }

    CSG getBoundingBox() {
        return new Cube(-this.getMinX() + this.getMaxX(), -this.getMinY() + this.getMaxY(), -this.getMinZ() + this.getMaxZ()).toCSG().toXMax().movex(this.getMaxX()).toYMax().movey(this.getMaxY()).toZMax().movez(this.getMaxZ());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        if (this.name == null) {
            return this.getColor().toString();
        }
        return this.getName() + " " + this.getColor().toString();
    }

    public ArrayList<Transform> getSlicePlanes() {
        return this.slicePlanes;
    }

    public void addSlicePlane(Transform slicePlane) {
        if (this.slicePlanes == null) {
            this.slicePlanes = new ArrayList();
        }
        this.slicePlanes.add(slicePlane);
    }

    public ArrayList<String> getExportFormats() {
        return this.exportFormats;
    }

    public void clearExportFormats() {
        if (this.exportFormats != null) {
            this.exportFormats.clear();
        }
    }

    public void addExportFormat(String exportFormat) {
        if (this.exportFormats == null) {
            this.exportFormats = new ArrayList();
        }
        for (String f : this.exportFormats) {
            if (!f.toLowerCase().contains(exportFormat.toLowerCase())) continue;
            return;
        }
        this.exportFormats.add(exportFormat.toLowerCase());
    }

    public static enum OptType {
        CSG_BOUND,
        POLYGON_BOUND,
        NONE;

    }
}

