/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.util.Objects;

public class Vertex {
    public Vector3d pos;
    public Vector3d normal;
    private double weight = 1.0;

    public Vertex(Vector3d pos, Vector3d normal) {
        this.pos = pos;
        this.normal = normal;
    }

    private Vertex(Vector3d pos, Vector3d normal, double weight) {
        this.pos = pos;
        this.normal = normal;
        this.weight = weight;
    }

    public Vertex clone() {
        return new Vertex(this.pos.clone(), this.normal.clone(), this.weight);
    }

    public void flip() {
        this.normal = this.normal.negated();
    }

    public Vertex interpolate(Vertex other, double t) {
        return new Vertex(this.pos.lerp(other.pos, t), this.normal.lerp(other.normal, t));
    }

    public String toStlString() {
        return "vertex " + this.pos.toStlString();
    }

    public StringBuilder toStlString(StringBuilder sb) {
        sb.append("vertex ");
        return this.pos.toStlString(sb);
    }

    public StringBuilder toObjString(StringBuilder sb) {
        sb.append("v ");
        return this.pos.toObjString(sb).append("\n");
    }

    public String toObjString() {
        return this.toObjString(new StringBuilder()).toString();
    }

    public Vertex transform(Transform transform) {
        this.pos = this.pos.transform(transform, this.weight);
        return this;
    }

    public Vertex transformed(Transform transform) {
        return this.clone().transform(transform);
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.pos);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vertex other = (Vertex)obj;
        return Objects.equals(this.pos, other.pos);
    }

    public String toString() {
        return this.pos.toString();
    }

    public double getX() {
        return this.pos.x;
    }

    public double getY() {
        return this.pos.y;
    }

    public double getZ() {
        return this.pos.z;
    }
}

