/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Cylinder;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Plane;
import eu.mihosoft.vrl.v3d.Sphere;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.UnityModifier;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.ZModifier;
import java.io.IOException;
import java.nio.file.Paths;

public class QuadrocopterArm {
    public CSG mainArm(int numInnerStructures, double length, double armThickness, double innerTubeOffset, double armCubeThickness) {
        double outerRadius = armThickness / 2.0;
        double wallThickness = 0.8;
        double structureRadius = 0.4;
        double maxXRot = 180.0;
        double maxYRot = 180.0;
        double maxZRot = 180.0;
        double maxXYOffset = outerRadius;
        double innerRadius = 5.1;
        double innerWallThickness = 0.8;
        double numPlates = 0.0;
        double plateThickness = 0.5;
        double shrinkFactorX = 0.65;
        double sideArmHight = length / 2.0;
        double sideArmGroundDist = 30.0;
        double sideArmRadius = armThickness / 6.0;
        double sideArmShrinkFactor = 0.6;
        CSG innerStructure = null;
        for (int i = 0; i < numInnerStructures; ++i) {
            CSG cyl = new Cylinder(structureRadius, outerRadius * 10.0, 8).toCSG();
            cyl = cyl.transformed(Transform.unity().scale(Math.max(0.5, Math.random() * 3.0), Math.max(0.5, Math.random() * 3.0), 1.0));
            cyl = cyl.transformed(Transform.unity().translateX(cyl.getBounds().getBounds().z / 2.0).rotY(90.0));
            cyl = cyl.transformed(Transform.unity().rot(Math.random() * maxXRot, Math.random() * maxYRot, Math.random() * maxZRot));
            cyl = cyl.transformed(Transform.unity().translate(-maxXYOffset / 2.0 + Math.random() * maxXYOffset, -maxXYOffset / 2.0 + Math.random() * maxXYOffset, innerTubeOffset + Math.random() * (length - innerTubeOffset)));
            innerStructure = innerStructure == null ? cyl : innerStructure.union(cyl);
        }
        if (innerStructure != null) {
            innerStructure = innerStructure.intersect(new Cylinder(outerRadius, length - innerTubeOffset, 16).toCSG().transformed(Transform.unity().scaleX(0.5).translateZ(innerTubeOffset)));
        }
        CSG outerCyl = QuadrocopterArm.outerCyl(outerRadius, length, wallThickness, shrinkFactorX, shrinkFactorX * 0.95);
        if (innerStructure != null) {
            outerCyl = outerCyl.union(innerStructure);
        }
        CSG innerCyl = new Cylinder(innerRadius, length - innerTubeOffset, 16).toCSG().transformed(Transform.unity().translateZ(innerTubeOffset));
        CSG finalGeometry = outerCyl.union(innerCyl);
        CSG plate = new Cylinder(outerRadius, plateThickness, 16).toCSG().transformed(Transform.unity().scaleX(shrinkFactorX));
        CSG endPlate = plate.transformed(Transform.unity().translateZ(innerTubeOffset));
        finalGeometry = finalGeometry.union(endPlate);
        CSG plates = null;
        if (numPlates > 0.0) {
            double dt = (length - innerTubeOffset) / numPlates;
            int i = 0;
            while ((double)i < numPlates) {
                CSG pl = plate.transformed(Transform.unity().translateZ(dt * (double)i));
                plates = plates == null ? pl : plates.union(pl);
                ++i;
            }
            finalGeometry = finalGeometry.union(plates);
        }
        CSG cube = new Cube(outerRadius * 2.0, outerRadius * 2.0, armCubeThickness).toCSG().difference(innerCyl).transformed(Transform.unity().translateZ(length - armCubeThickness / 2.0));
        finalGeometry = finalGeometry.union(cube);
        CSG sideArms = QuadrocopterArm.sideArms(sideArmGroundDist, sideArmHight, sideArmRadius, sideArmShrinkFactor, length, armCubeThickness, outerRadius);
        finalGeometry = finalGeometry.difference(new Cylinder(innerRadius - innerWallThickness, length, 16).toCSG());
        return finalGeometry;
    }

    public static CSG sideArms(double sideArmGroundDist, double sideArmHight, double sideArmRadius, double sideArmShrinkFactor, double length, double armCubeThickness, double outerRadius) {
        double sideArmLength = Math.sqrt(sideArmGroundDist * sideArmGroundDist + sideArmHight * sideArmHight);
        double alpha = Math.atan(sideArmGroundDist / sideArmHight) * 180.0 / Math.PI;
        CSG subCylinder = new Cylinder(sideArmRadius, sideArmLength + sideArmRadius, 16).toCSG().transformed(Transform.unity().rotY(90.0).scaleX(sideArmShrinkFactor)).transformed(Transform.unity().rotZ(alpha)).transformed(Transform.unity().translateX(-length + sideArmHight));
        subCylinder = subCylinder.difference(new Cube(new Vector3d(-length - sideArmRadius * 2.0, sideArmGroundDist), new Vector3d(sideArmRadius * 4.0, sideArmRadius * 4.0, sideArmRadius * 4.0)).toCSG());
        subCylinder = subCylinder.union(new Cube(new Vector3d(-length + armCubeThickness / 2.0, sideArmGroundDist, 0.0), new Vector3d(armCubeThickness, outerRadius * 2.0, outerRadius * 2.0)).toCSG());
        CSG sideArms = subCylinder.union(subCylinder.transformed(Transform.unity().mirror(Plane.XZ_PLANE))).transformed(Transform.unity().rotY(90.0).rotZ(180.0).rotX(90.0));
        return sideArms;
    }

    public static CSG sideArms(double sideArmGroundDist, double sideArmHight, double sideArmRadius, double sideArmShrinkFactor, double armCubeThickness, double outerRadius) {
        double sideArmLength = Math.sqrt(sideArmGroundDist * sideArmGroundDist + sideArmHight * sideArmHight);
        double alpha = Math.atan(sideArmGroundDist / sideArmHight) * 180.0 / Math.PI;
        CSG subCylinder = new Cylinder(sideArmRadius, sideArmLength + sideArmRadius, 16).toCSG().transformed(Transform.unity().rotY(90.0).scaleX(sideArmShrinkFactor)).transformed(Transform.unity().rotZ(alpha)).transformed(Transform.unity().translateX(sideArmHight));
        subCylinder = subCylinder.difference(new Cube(new Vector3d(0.0 - sideArmRadius * 2.0, sideArmGroundDist), new Vector3d(sideArmRadius * 4.0, sideArmRadius * 4.0, sideArmRadius * 4.0)).toCSG());
        subCylinder = subCylinder.union(new Cube(new Vector3d(0.0 + armCubeThickness / 2.0, sideArmGroundDist, 0.0), new Vector3d(armCubeThickness, outerRadius * 2.0, outerRadius * 2.0)).toCSG());
        CSG sideArms = subCylinder.union(subCylinder.transformed(Transform.unity().mirror(Plane.XZ_PLANE)));
        return sideArms;
    }

    public static CSG outerCyl(double outerRadius, double length, double wallThickness, double scaleOuter, double scaleInner) {
        return QuadrocopterArm.outerCyl(outerRadius, length, wallThickness, scaleOuter, scaleInner, false);
    }

    public static CSG outerCyl(double outerRadius, double length, double wallThickness, double scaleOuter, double scaleInner, boolean filled) {
        CSG outerCyl = new Cylinder(outerRadius, length, 32).toCSG().transformed(Transform.unity().scaleX(scaleOuter));
        if (!filled) {
            CSG outerCylInner = new Cylinder(outerRadius - wallThickness / scaleOuter, length, 32).toCSG().transformed(Transform.unity().scaleX(scaleInner));
            outerCyl = outerCyl.difference(outerCylInner);
        }
        return outerCyl;
    }

    public CSG toCSG() {
        CSG.setDefaultOptType(CSG.OptType.NONE);
        double engineRadius = 14.0;
        double screwDistanceBig = 9.5;
        double screwDistanceSmall = 8.0;
        double screwRadius = 1.6;
        double enginePlatformThickness = 2.0;
        double mainHoleRadius = 4.0;
        double washerWallThickness = 1.0;
        double washerHeight = 2.0;
        double armLength = 150.0;
        int numInnerStructures = 60;
        double armThickness = 18.0;
        double armCubeThickness = 4.0;
        double innerTubeOffset = engineRadius * 2.0 + 5.0;
        CSG mainArm = this.mainArm(numInnerStructures, armLength, armThickness, innerTubeOffset, armCubeThickness).transformed(Transform.unity().rotX(90.0).rotY(90.0));
        CSG enginePlatformSphere = new Sphere(engineRadius * 1.1, 64, 32).toCSG().transformed(Transform.unity().scaleX(2.0).translateZ(armThickness * 0.5));
        Transform engineTransform = Transform.unity().translateX(-mainHoleRadius).translateZ(-armThickness * 0.28).translateX(1.2);
        CSG mainHole = new Cylinder(mainHoleRadius, enginePlatformThickness, 16).toCSG().transformed(engineTransform);
        CSG enginePlatform = this.enginePlatform(engineRadius, enginePlatformThickness, mainHoleRadius, screwRadius, screwDistanceBig, screwDistanceSmall, washerWallThickness, washerHeight).transformed(engineTransform);
        mainArm = mainArm.difference(enginePlatformSphere).union(enginePlatform).difference(mainHole);
        return mainArm.transformed(Transform.unity().rotX(90.0).rotZ(90.0));
    }

    private CSG enginePlatform(double engineRadius, double enginePlatformThickness, double mainHoleRadius, double screwRadius, double screwDistanceBig, double screwDistanceSmall, double washerWallThickness, double washerHeight) {
        CSG enginePlatform = new Cylinder(engineRadius, enginePlatformThickness, 32).toCSG();
        CSG secondCyl = new Cylinder(engineRadius * 0.3, enginePlatformThickness, 3).toCSG().transformed(Transform.unity().translateX(-engineRadius * 2.7));
        enginePlatform = enginePlatform.union(secondCyl).hull();
        CSG mainHole = new Cylinder(mainHoleRadius, enginePlatformThickness * 5.0, 16).toCSG().transformed(Transform.unity().translateZ(-enginePlatformThickness));
        CSG screwHolePrototype = new Cylinder(screwRadius, enginePlatformThickness + washerHeight + 10.0, 16).toCSG().transformed(Transform.unity().translateZ(-5.0));
        CSG screwHole1 = screwHolePrototype.transformed(Transform.unity().translateX(screwDistanceBig)).transformed(Transform.unity().rotZ(-45.0));
        CSG screwHole2 = screwHolePrototype.transformed(Transform.unity().translateX(screwDistanceBig)).transformed(Transform.unity().rotZ(135.0));
        CSG screwHole3 = screwHolePrototype.transformed(Transform.unity().translateX(screwDistanceSmall)).transformed(Transform.unity().rotZ(45.0));
        CSG screwHole4 = screwHolePrototype.transformed(Transform.unity().translateX(screwDistanceSmall)).transformed(Transform.unity().rotZ(-135.0));
        CSG washerPrototype = new Cylinder(screwRadius + washerWallThickness, washerHeight, 16).toCSG();
        CSG washerHole = washerPrototype.clone();
        washerPrototype = washerPrototype.weighted(new ZModifier()).transformed(Transform.unity().scale(1.35, 1.35, 1.0)).weighted(new UnityModifier());
        washerPrototype = washerPrototype.difference(screwHolePrototype).transformed(Transform.unity().translateZ(-washerHeight));
        CSG washer1 = washerPrototype.transformed(Transform.unity().translateX(screwDistanceBig)).transformed(Transform.unity().rotZ(-45.0));
        CSG washer2 = washerPrototype.transformed(Transform.unity().translateX(screwDistanceBig)).transformed(Transform.unity().rotZ(135.0));
        CSG washer3 = washerPrototype.transformed(Transform.unity().translateX(screwDistanceSmall)).transformed(Transform.unity().rotZ(45.0));
        CSG washer4 = washerPrototype.transformed(Transform.unity().translateX(screwDistanceSmall)).transformed(Transform.unity().rotZ(-135.0));
        CSG washerHole1 = washerHole.transformed(Transform.unity().translateX(screwDistanceBig)).transformed(Transform.unity().rotZ(-45.0)).transformed(Transform.unity().translateZ(-washerHeight * 2.0));
        CSG washerHole2 = washerHole.transformed(Transform.unity().translateX(screwDistanceBig)).transformed(Transform.unity().rotZ(135.0)).transformed(Transform.unity().translateZ(-washerHeight * 2.0));
        CSG washerHole3 = washerHole.transformed(Transform.unity().translateX(screwDistanceSmall)).transformed(Transform.unity().rotZ(45.0)).transformed(Transform.unity().translateZ(-washerHeight * 2.0));
        CSG washerHole4 = washerHole.transformed(Transform.unity().translateX(screwDistanceSmall)).transformed(Transform.unity().rotZ(-135.0)).transformed(Transform.unity().translateZ(-washerHeight * 2.0));
        CSG hullCube = new Cylinder(3.0, 20.0, 16).toCSG().transformed(Transform.unity().rotY(90.0)).transformed(Transform.unity().translate(0.0, 0.0, -2.0));
        enginePlatform = enginePlatform.union(hullCube).hull().difference(washerHole1, washerHole2, washerHole3, washerHole4);
        enginePlatform = enginePlatform.difference(mainHole, screwHole1, screwHole2, screwHole3, screwHole4).union(washer1, washer2, washer3, washer4);
        return enginePlatform;
    }

    public static void main(String[] args) throws IOException {
        CSG result = new QuadrocopterArm().toCSG();
        FileUtil.write(Paths.get("quadrocopter-arm.stl", new String[0]), result.toStlString());
        result.toObj().toFiles(Paths.get("quadrocopter-arm.obj", new String[0]));
    }
}

