/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vvecmath;

import eu.mihosoft.vvecmath.ModifiableVector3d;
import eu.mihosoft.vvecmath.Transform;
import eu.mihosoft.vvecmath.Vector3dImpl;

public interface Vector3d {
    public static final Vector3d UNITY = new Vector3dImpl(1.0, 1.0, 1.0);
    public static final Vector3d X_ONE = new Vector3dImpl(1.0, 0.0, 0.0);
    public static final Vector3d Y_ONE = new Vector3dImpl(0.0, 1.0, 0.0);
    public static final Vector3d ZERO = new Vector3dImpl(0.0, 0.0, 0.0);
    public static final Vector3d Z_ONE = new Vector3dImpl(0.0, 0.0, 1.0);

    public double angle(Vector3d var1);

    public ModifiableVector3d asModifiable();

    public Vector3d clone();

    public Vector3d cross(Vector3d var1);

    public Vector3d dividedBy(double var1);

    public double dot(Vector3d var1);

    public boolean equals(Object var1);

    public double[] get();

    public double get(int var1);

    public double getX();

    public double getY();

    public double getZ();

    public int hashCode();

    public Vector3d lerp(Vector3d var1, double var2);

    public double magnitude();

    default public double magnitudeSq() {
        return this.dot(this);
    }

    public Vector3d minus(Vector3d var1);

    public Vector3d negated();

    public Vector3d normalized();

    public Vector3d orthogonal();

    public Vector3d plus(Vector3d var1);

    public Vector3d times(double var1);

    public Vector3d times(Vector3d var1);

    public String toObjString();

    public StringBuilder toObjString(StringBuilder var1);

    public String toStlString();

    public StringBuilder toStlString(StringBuilder var1);

    public String toString();

    public Vector3d transformed(Transform var1);

    public Vector3d transformed(Transform var1, double var2);

    public double x();

    public double y();

    public double z();

    public static Vector3d x(double x) {
        return new Vector3dImpl(x, 0.0, 0.0);
    }

    public static Vector3d y(double y) {
        return new Vector3dImpl(0.0, y, 0.0);
    }

    public static Vector3d z(double z) {
        return new Vector3dImpl(0.0, 0.0, z);
    }

    public static Vector3d xy(double x, double y) {
        return new Vector3dImpl(x, y);
    }

    public static Vector3d xyz(double x, double y, double z) {
        return new Vector3dImpl(x, y, z);
    }

    public static Vector3d yz(double y, double z) {
        return new Vector3dImpl(0.0, y, z);
    }

    public static Vector3d xz(double x, double z) {
        return new Vector3dImpl(x, 0.0, z);
    }

    public static Vector3d zero() {
        return new Vector3dImpl(0.0, 0.0, 0.0);
    }

    public static Vector3d unity() {
        return new Vector3dImpl(0.0, 0.0, 0.0);
    }

    public static Vector3d clone(Vector3d source) {
        return new Vector3dImpl(source.x(), source.y(), source.z());
    }
}

