/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.batik.util.gui.ExtendedGridBagConstraints;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceManager;

public class MemoryMonitor
extends JFrame
implements ActionMap {
    protected static final String RESOURCE = "org.apache.batik.util.gui.resources.MemoryMonitorMessages";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.util.gui.resources.MemoryMonitorMessages", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected Map listeners = new HashMap();
    protected Panel panel;

    public MemoryMonitor() {
        this(1000L);
    }

    public MemoryMonitor(long l) {
        super(resources.getString("Frame.title"));
        this.listeners.put("CollectButtonAction", new CollectButtonAction());
        this.listeners.put("CloseButtonAction", new CloseButtonAction());
        this.panel = new Panel(l);
        this.getContentPane().add(this.panel);
        this.panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("Frame.border_title")));
        JPanel jPanel = new JPanel(new FlowLayout(2));
        ButtonFactory buttonFactory = new ButtonFactory(bundle, this);
        jPanel.add(buttonFactory.createJButton("CollectButton"));
        jPanel.add(buttonFactory.createJButton("CloseButton"));
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                RepaintThread repaintThread = MemoryMonitor.this.panel.getRepaintThread();
                if (!repaintThread.isAlive()) {
                    repaintThread.start();
                } else {
                    repaintThread.safeResume();
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                MemoryMonitor.this.panel.getRepaintThread().safeSuspend();
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                MemoryMonitor.this.panel.getRepaintThread().safeResume();
            }

            public void windowIconified(WindowEvent windowEvent) {
                MemoryMonitor.this.panel.getRepaintThread().safeSuspend();
            }
        });
    }

    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    public static class RepaintThread
    extends Thread {
        protected long timeout;
        protected List components;
        protected Runtime runtime = Runtime.getRuntime();
        protected boolean suspended;

        public RepaintThread(long l, List list) {
            this.timeout = l;
            this.components = list;
            this.setPriority(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object;
                long l = this.runtime.freeMemory();
                long l2 = this.runtime.totalMemory();
                Iterator iterator = this.components.iterator();
                while (iterator.hasNext()) {
                    object = (Component)iterator.next();
                    ((MemoryChangeListener)object).memoryStateChanged(l2, l);
                    ((Component)object).repaint();
                }
                try {
                    RepaintThread.sleep(this.timeout);
                    object = this;
                    synchronized (object) {
                        while (this.suspended) {
                            this.wait();
                        }
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public synchronized void safeSuspend() {
            if (!this.suspended) {
                this.suspended = true;
            }
        }

        public synchronized void safeResume() {
            if (this.suspended) {
                this.suspended = false;
                this.notify();
            }
        }
    }

    public static interface MemoryChangeListener {
        public void memoryStateChanged(long var1, long var3);
    }

    public static class History
    extends JPanel
    implements MemoryChangeListener {
        public static final int PREFERRED_WIDTH = 200;
        public static final int PREFERRED_HEIGHT = 100;
        protected static final Stroke GRID_LINES_STROKE = new BasicStroke(1.0f);
        protected static final Stroke CURVE_STROKE = new BasicStroke(2.0f, 1, 1);
        protected static final Stroke BORDER_STROKE = new BasicStroke(2.0f);
        protected Color gridLinesColor = new Color(0, 130, 0);
        protected Color curveColor = Color.yellow;
        protected Color borderColor = Color.green;
        protected List data = new LinkedList();
        protected int xShift = 0;
        protected long totalMemory;
        protected long freeMemory;
        protected GeneralPath path = new GeneralPath();

        public History() {
            this.setBackground(Color.black);
            this.setPreferredSize(new Dimension(200, 100));
        }

        public void memoryStateChanged(long l, long l2) {
            this.totalMemory = l;
            this.freeMemory = l2;
            this.data.add(new Long(this.totalMemory - this.freeMemory));
            if (this.data.size() > 190) {
                this.data.remove(0);
                this.xShift = (this.xShift + 1) % 10;
            }
            Iterator iterator = this.data.iterator();
            GeneralPath generalPath = new GeneralPath();
            long l3 = (Long)iterator.next();
            generalPath.moveTo(5.0f, (float)(this.totalMemory - l3) / (float)this.totalMemory * 80.0f + 10.0f);
            int n = 6;
            while (iterator.hasNext()) {
                l3 = (Long)iterator.next();
                generalPath.lineTo(n, (float)(this.totalMemory - l3) / (float)this.totalMemory * 80.0f + 10.0f);
                ++n;
            }
            this.path = generalPath;
        }

        protected void paintComponent(Graphics graphics) {
            int n;
            int n2;
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Dimension dimension = this.getSize();
            double d = (double)dimension.width / 200.0;
            double d2 = (double)dimension.height / 100.0;
            graphics2D.transform(AffineTransform.getScaleInstance(d, d2));
            graphics2D.setPaint(this.gridLinesColor);
            graphics2D.setStroke(GRID_LINES_STROKE);
            for (n2 = 1; n2 < 20; ++n2) {
                n = n2 * 10 + 5 - this.xShift;
                graphics2D.draw(new Line2D.Double(n, 5.0, n, 95.0));
            }
            for (n2 = 1; n2 < 9; ++n2) {
                n = n2 * 10 + 5;
                graphics2D.draw(new Line2D.Double(5.0, n, 195.0, n));
            }
            graphics2D.setPaint(this.curveColor);
            graphics2D.setStroke(CURVE_STROKE);
            graphics2D.draw(this.path);
            graphics2D.setStroke(BORDER_STROKE);
            graphics2D.setPaint(this.borderColor);
            graphics2D.draw(new Rectangle2D.Double(5.0, 5.0, 190.0, 90.0));
        }
    }

    public static class Usage
    extends JPanel
    implements MemoryChangeListener {
        public static final int PREFERRED_WIDTH = 90;
        public static final int PREFERRED_HEIGHT = 100;
        protected static final String UNITS = resources.getString("Usage.units");
        protected static final String TOTAL = resources.getString("Usage.total");
        protected static final String USED = resources.getString("Usage.used");
        protected static final boolean POSTFIX = resources.getBoolean("Usage.postfix");
        protected static final int FONT_SIZE = 9;
        protected static final int BLOCK_MARGIN = 10;
        protected static final int BLOCKS = 15;
        protected static final double BLOCK_WIDTH = 70.0;
        protected static final double BLOCK_HEIGHT = 3.8666666666666667;
        protected static final int[] BLOCK_TYPE = new int[]{0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2};
        protected Color[] usedColors = new Color[]{Color.red, new Color(255, 165, 0), Color.green};
        protected Color[] freeColors = new Color[]{new Color(130, 0, 0), new Color(130, 90, 0), new Color(0, 130, 0)};
        protected Font font = new Font("SansSerif", 1, 9);
        protected Color textColor = Color.green;
        protected long totalMemory;
        protected long freeMemory;

        public Usage() {
            this.setBackground(Color.black);
            this.setPreferredSize(new Dimension(90, 100));
        }

        public void memoryStateChanged(long l, long l2) {
            this.totalMemory = l;
            this.freeMemory = l2;
        }

        public void setTextColor(Color color) {
            this.textColor = color;
        }

        public void setLowUsedMemoryColor(Color color) {
            this.usedColors[2] = color;
        }

        public void setMediumUsedMemoryColor(Color color) {
            this.usedColors[1] = color;
        }

        public void setHighUsedMemoryColor(Color color) {
            this.usedColors[0] = color;
        }

        public void setLowFreeMemoryColor(Color color) {
            this.freeColors[2] = color;
        }

        public void setMediumFreeMemoryColor(Color color) {
            this.freeColors[1] = color;
        }

        public void setHighFreeMemoryColor(Color color) {
            this.freeColors[0] = color;
        }

        protected void paintComponent(Graphics graphics) {
            String string;
            String string2;
            Rectangle2D.Double double_;
            int n;
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            double d = (double)dimension.width / 90.0;
            double d2 = (double)dimension.height / 100.0;
            graphics2D.transform(AffineTransform.getScaleInstance(d, d2));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n2 = (int)Math.round(15.0 * (double)this.freeMemory / (double)this.totalMemory);
            for (n = 0; n < n2; ++n) {
                double_ = new Rectangle2D.Double(10.0, (double)n * 3.8666666666666667 + (double)n + 9.0 + 5.0, 70.0, 3.8666666666666667);
                graphics2D.setPaint(this.freeColors[BLOCK_TYPE[n]]);
                graphics2D.fill(double_);
            }
            for (n = n2; n < 15; ++n) {
                double_ = new Rectangle2D.Double(10.0, (double)n * 3.8666666666666667 + (double)n + 9.0 + 5.0, 70.0, 3.8666666666666667);
                graphics2D.setPaint(this.usedColors[BLOCK_TYPE[n]]);
                graphics2D.fill(double_);
            }
            graphics2D.setPaint(this.textColor);
            graphics2D.setFont(this.font);
            long l = this.totalMemory / 1024L;
            long l2 = (this.totalMemory - this.freeMemory) / 1024L;
            if (POSTFIX) {
                string2 = l + UNITS + " " + TOTAL;
                string = l2 + UNITS + " " + USED;
            } else {
                string2 = TOTAL + " " + l + UNITS;
                string = USED + " " + l2 + UNITS;
            }
            graphics2D.drawString(string2, 10, 10);
            graphics2D.drawString(string, 10, 97);
        }
    }

    public static class Panel
    extends JPanel {
        protected RepaintThread repaintThread;

        public Panel() {
            this(1000L);
        }

        public Panel(long l) {
            super(new GridBagLayout());
            ExtendedGridBagConstraints extendedGridBagConstraints = new ExtendedGridBagConstraints();
            extendedGridBagConstraints.insets = new Insets(5, 5, 5, 5);
            ArrayList<Usage> arrayList = new ArrayList<Usage>();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
            JPanel jPanel2 = new Usage();
            jPanel.add(jPanel2);
            extendedGridBagConstraints.weightx = 0.3;
            extendedGridBagConstraints.weighty = 1.0;
            extendedGridBagConstraints.fill = 1;
            extendedGridBagConstraints.setGridBounds(0, 0, 1, 1);
            this.add((Component)jPanel, extendedGridBagConstraints);
            arrayList.add((Usage)jPanel2);
            jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
            jPanel2 = new History();
            jPanel.add(jPanel2);
            extendedGridBagConstraints.weightx = 0.7;
            extendedGridBagConstraints.setGridBounds(1, 0, 1, 1);
            this.add((Component)jPanel, extendedGridBagConstraints);
            arrayList.add((Usage)jPanel2);
            this.repaintThread = new RepaintThread(l, arrayList);
        }

        public RepaintThread getRepaintThread() {
            return this.repaintThread;
        }
    }

    protected class CloseButtonAction
    extends AbstractAction {
        protected CloseButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MemoryMonitor.this.panel.getRepaintThread().safeSuspend();
            MemoryMonitor.this.dispose();
        }
    }

    protected class CollectButtonAction
    extends AbstractAction {
        protected CollectButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.gc();
        }
    }
}

