/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.render.ps.PSResource;
import org.apache.fop.render.ps.PSState;

public class PSGenerator {
    public static final AtendIndicator ATEND = new AtendIndicator(){};
    public static final char LF = '\n';
    private OutputStream out;
    private boolean commentsEnabled = true;
    private Stack graphicsStateStack = new Stack();
    private PSState currentState;
    private DecimalFormat df3 = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
    private DecimalFormat df5 = new DecimalFormat("0.#####", new DecimalFormatSymbols(Locale.US));
    private StringBuffer tempBuffer = new StringBuffer(256);
    private Set documentSuppliedResources;
    private Set documentNeededResources;
    private Set pageResources;

    public PSGenerator(OutputStream out) {
        this.out = out;
        this.currentState = new PSState();
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public int getPSLevel() {
        return 2;
    }

    public Source resolveURI(String uri) {
        return new StreamSource(uri);
    }

    public final void newLine() throws IOException {
        this.out.write(10);
    }

    public String formatDouble(double value) {
        return this.df3.format(value);
    }

    public String formatDouble5(double value) {
        return this.df5.format(value);
    }

    public void write(String cmd) throws IOException {
        this.out.write(cmd.getBytes("US-ASCII"));
    }

    public void writeln(String cmd) throws IOException {
        this.write(cmd);
        this.newLine();
    }

    public void commentln(String comment) throws IOException {
        if (this.commentsEnabled) {
            this.writeln(comment);
        }
    }

    public void writeByteArr(byte[] cmd) throws IOException {
        this.out.write(cmd);
        this.newLine();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public static final void escapeChar(char c, StringBuffer target) {
        if (c > '\u007f') {
            target.append("\\");
            target.append(Integer.toOctalString(c));
        } else {
            switch (c) {
                case '\n': {
                    target.append("\\n");
                    break;
                }
                case '\r': {
                    target.append("\\r");
                    break;
                }
                case '\t': {
                    target.append("\\t");
                    break;
                }
                case '\b': {
                    target.append("\\b");
                    break;
                }
                case '\f': {
                    target.append("\\f");
                    break;
                }
                case '\\': {
                    target.append("\\\\");
                    break;
                }
                case '(': {
                    target.append("\\(");
                    break;
                }
                case ')': {
                    target.append("\\)");
                    break;
                }
                default: {
                    target.append(c);
                }
            }
        }
    }

    public static final String convertStringToDSC(String text) {
        return PSGenerator.convertStringToDSC(text, false);
    }

    public static final String convertStringToDSC(String text, boolean forceParentheses) {
        if (text == null || text.length() == 0) {
            return "()";
        }
        int initialSize = text.length();
        initialSize += initialSize / 2;
        StringBuffer sb = new StringBuffer(initialSize);
        if (Long.getLong(text) != null || text.indexOf(32) >= 0 || forceParentheses) {
            sb.append('(');
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                PSGenerator.escapeChar(c, sb);
                ++i;
            }
            sb.append(')');
            return sb.toString();
        }
        return text;
    }

    public void writeDSCComment(String name) throws IOException {
        this.writeln("%%" + name);
    }

    public void writeDSCComment(String name, Object param) throws IOException {
        this.writeDSCComment(name, new Object[]{param});
    }

    public void writeDSCComment(String name, Object[] params) throws IOException {
        this.tempBuffer.setLength(0);
        this.tempBuffer.append("%%");
        this.tempBuffer.append(name);
        if (params != null && params.length > 0) {
            this.tempBuffer.append(": ");
            int i = 0;
            while (i < params.length) {
                if (i > 0) {
                    this.tempBuffer.append(" ");
                }
                if (params[i] instanceof String) {
                    this.tempBuffer.append(PSGenerator.convertStringToDSC((String)params[i]));
                } else if (params[i] instanceof AtendIndicator) {
                    this.tempBuffer.append("(atend)");
                } else if (params[i] instanceof Double) {
                    this.tempBuffer.append(this.df3.format(params[i]));
                } else if (params[i] instanceof Number) {
                    this.tempBuffer.append(params[i].toString());
                } else if (params[i] instanceof Date) {
                    SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    this.tempBuffer.append(PSGenerator.convertStringToDSC(datef.format((Date)params[i])));
                } else if (params[i] instanceof PSResource) {
                    this.tempBuffer.append(((PSResource)params[i]).getResourceSpecification());
                } else {
                    throw new IllegalArgumentException("Unsupported parameter type: " + params[i].getClass().getName());
                }
                ++i;
            }
        }
        this.writeln(this.tempBuffer.toString());
    }

    public void saveGraphicsState() throws IOException {
        this.writeln("gsave");
        PSState state = new PSState(this.currentState, false);
        this.graphicsStateStack.push(this.currentState);
        this.currentState = state;
    }

    public boolean restoreGraphicsState() throws IOException {
        if (this.graphicsStateStack.size() > 0) {
            this.writeln("grestore");
            this.currentState = (PSState)this.graphicsStateStack.pop();
            return true;
        }
        return false;
    }

    public PSState getCurrentState() {
        return this.currentState;
    }

    public void concatMatrix(double a, double b, double c, double d, double e, double f) throws IOException {
        AffineTransform at = new AffineTransform(a, b, c, d, e, f);
        this.concatMatrix(at);
    }

    public void concatMatrix(double[] matrix) throws IOException {
        this.concatMatrix(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
    }

    public void concatMatrix(AffineTransform at) throws IOException {
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        this.getCurrentState().concatMatrix(at);
        this.writeln("[" + this.formatDouble5(matrix[0]) + " " + this.formatDouble5(matrix[1]) + " " + this.formatDouble5(matrix[2]) + " " + this.formatDouble5(matrix[3]) + " " + this.formatDouble5(matrix[4]) + " " + this.formatDouble5(matrix[5]) + "] concat");
    }

    public void defineRect(double x, double y, double w, double h) throws IOException {
        this.writeln(this.formatDouble(x) + " " + this.formatDouble(y) + " " + this.formatDouble(w) + " " + this.formatDouble(h) + " re");
    }

    public void useLineCap(int linecap) throws IOException {
        if (this.getCurrentState().useLineCap(linecap)) {
            this.writeln(linecap + " setlinecap");
        }
    }

    public void useLineWidth(double width) throws IOException {
        if (this.getCurrentState().useLineWidth(width)) {
            this.writeln(this.formatDouble(width) + " setlinewidth");
        }
    }

    public void useDash(String pattern) throws IOException {
        if (pattern == null) {
            pattern = "[] 0";
        }
        if (this.getCurrentState().useDash(pattern)) {
            this.writeln(pattern + " setdash");
        }
    }

    public void useRGBColor(Color col) throws IOException {
        if (col == null) {
            col = PSState.DEFAULT_RGB_COLOR;
        }
        if (this.getCurrentState().useColor(col)) {
            float[] comps = col.getColorComponents(null);
            this.writeln(this.formatDouble(comps[0]) + " " + this.formatDouble(comps[1]) + " " + this.formatDouble(comps[2]) + " setrgbcolor");
        }
    }

    public void useFont(String name, float size) throws IOException {
        if (this.getCurrentState().useFont(name, size)) {
            this.writeln(name + " " + this.formatDouble(size) + " F");
        }
    }

    public void notifyStartNewPage() {
        if (this.pageResources != null) {
            this.pageResources.clear();
        }
    }

    public void notifyResourceUsage(PSResource res, boolean needed) {
        if (this.pageResources == null) {
            this.pageResources = new HashSet();
        }
        this.pageResources.add(res);
        if (needed) {
            if (this.documentNeededResources == null) {
                this.documentNeededResources = new HashSet();
            }
            this.documentNeededResources.add(res);
        } else {
            if (this.documentSuppliedResources == null) {
                this.documentSuppliedResources = new HashSet();
            }
            this.documentSuppliedResources.add(res);
        }
    }

    public boolean isResourceSupplied(PSResource res) {
        return this.documentSuppliedResources.contains(res);
    }

    public void writeResources(boolean pageLevel) throws IOException {
        if (pageLevel) {
            this.writeResourceComment("PageResources", this.pageResources);
        } else {
            this.writeResourceComment("DocumentNeededResources", this.documentNeededResources);
            this.writeResourceComment("DocumentSuppliedResources", this.documentSuppliedResources);
        }
    }

    private void writeResourceComment(String name, Set resources) throws IOException {
        if (resources == null || resources.size() == 0) {
            return;
        }
        this.tempBuffer.setLength(0);
        this.tempBuffer.append("%%");
        this.tempBuffer.append(name);
        this.tempBuffer.append(" ");
        boolean first = true;
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            if (!first) {
                this.writeln(this.tempBuffer.toString());
                this.tempBuffer.setLength(0);
                this.tempBuffer.append("%%+ ");
            }
            PSResource res = (PSResource)i.next();
            this.tempBuffer.append(res.getResourceSpecification());
            first = false;
        }
        this.writeln(this.tempBuffer.toString());
    }

    private static interface AtendIndicator {
    }
}

