/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.math;

import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.math.MathUtils;

public class TransformContext {
    private double[][] transformMatrix;
    private double rotationAngle = 0.0;
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private double scaleZ = 1.0;
    private Vector translation = new Vector(1.0, 1.0, 1.0);

    public TransformContext() {
        this.transformMatrix = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    }

    public TransformContext(double[][] dArray) throws IllegalArgumentException {
        if (dArray.length != 4 && dArray[0].length != 4) {
            throw new IllegalArgumentException("Not a valid tranformation matrix.");
        }
        this.transformMatrix = dArray;
    }

    public double getRotationZAxis() {
        return this.rotationAngle;
    }

    public void setRotationZAxis(double d) {
        this.rotationAngle = d;
    }

    public void setScale(double d) {
        this.setScale(d, d, d);
    }

    public void setScale(double d, double d2, double d3) {
        this.scaleX = d;
        this.scaleY = d2;
        this.scaleZ = d3;
        double[][] dArrayArray = new double[][]{{d, 0.0, 0.0, 0.0}, {0.0, d2, 0.0, 0.0}, {0.0, 0.0, d3, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.transformMatrix = MathUtils.multiplyMatrixByMatrix(this.transformMatrix, dArrayArray);
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(double d) {
        this.setScale(d, 1.0, 1.0);
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(double d) {
        this.setScale(1.0, d, 1.0);
    }

    public double getScaleZ() {
        return this.scaleZ;
    }

    public void setScaleZ(double d) {
        this.setScale(1.0, 1.0, d);
    }

    public double[][] getTransformMatrix() {
        return this.transformMatrix;
    }

    public void setTransformMatrix(double[][] dArray) {
        this.transformMatrix = dArray;
    }

    public Vector getTranslation() {
        return this.translation;
    }

    public void setTranslation(Vector vector) {
        this.translation = vector;
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0, vector.getX()}, {0.0, 1.0, 0.0, vector.getY()}, {0.0, 0.0, 1.0, vector.getZ()}, {0.0, 0.0, 0.0, 1.0}};
        this.transformMatrix = MathUtils.multiplyMatrixByMatrix(this.transformMatrix, dArrayArray);
    }

    public Point transform(Point point) {
        double[] dArray = new double[]{point.getX(), point.getY(), point.getZ(), 1.0};
        dArray = MathUtils.multiplyMatrixByVector(this.transformMatrix, dArray);
        Point point2 = new Point(dArray[0], dArray[1], dArray[2]);
        return point2;
    }
}

