/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFCircle;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFCircleHandler
extends AbstractEntityHandler {
    public static final String ENTITY_NAME = "CIRCLE";
    public static final int RADIUS = 40;
    private DXFCircle circle;

    public void endDXFEntity() {
    }

    public DXFEntity getDXFEntity() {
        return this.circle;
    }

    public String getDXFEntityName() {
        return ENTITY_NAME;
    }

    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 10: {
                this.circle.getCenterPoint().setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.circle.getCenterPoint().setY(dXFValue.getDoubleValue());
                break;
            }
            case 40: {
                this.circle.setRadius(dXFValue.getDoubleValue());
                break;
            }
            default: {
                super.parseCommonProperty(n, dXFValue, this.circle);
            }
        }
    }

    public void startDXFEntity() {
        this.circle = new DXFCircle();
        this.circle.setCenterPoint(new Point());
        this.circle.setDXFDocument(this.doc);
    }

    public boolean isFollowSequence() {
        return false;
    }
}

