/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.action;

import de.miethxml.toolkit.ui.UIUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.action.CanvasUpdateManager;
import org.kabeja.svg.action.CanvasUpdateRunnable;
import org.kabeja.svg.action.GroupActionUnSelector;
import org.kabeja.svg.action.Messages;
import org.kabeja.svg.action.SVGDocumentAction;
import org.kabeja.ui.PropertiesEditor;
import org.kabeja.ui.PropertiesListener;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGMatrix;

public class SelectionAction
extends AbstractAction
implements SVGDocumentAction,
EventListener,
PropertiesEditor,
ItemListener,
CanvasUpdateRunnable,
GroupActionUnSelector {
    protected boolean selecting = false;
    protected boolean dragging = false;
    protected Element selectionRectangle;
    protected float startX = 0.0f;
    protected float startY = 0.0f;
    protected SVGMatrix matrix;
    protected Map properties = new HashMap();
    protected List listeners = new ArrayList();
    float lastX;
    float lastY;
    protected boolean process = false;
    protected boolean state = false;
    protected CanvasUpdateManager updateManager;
    static /* synthetic */ Class class$org$kabeja$svg$action$SelectionAction;

    public SelectionAction() {
        super("Selection", new ImageIcon(UIUtils.resourceToBytes(class$org$kabeja$svg$action$SelectionAction == null ? (class$org$kabeja$svg$action$SelectionAction = SelectionAction.class$("org.kabeja.svg.action.SelectionAction")) : class$org$kabeja$svg$action$SelectionAction, "/icons/cut_edit.gif")));
        this.putValue("ShortDescription", Messages.getString("editor.action.cut.area"));
    }

    public void handleEvent(Event evt) {
        if (this.state) {
            MouseEvent event = (MouseEvent)evt;
            if (evt.getType().equals("click") && this.selecting) {
                this.selecting = false;
                this.removeSelectionRectangle();
            } else if (evt.getType().equals("mousedown") && !this.selecting) {
                this.matrix = ((SVGDocument)this.selectionRectangle.getOwnerDocument()).getRootElement().getScreenCTM().inverse();
                this.startX = this.matrix.getA() * (float)event.getClientX() + this.matrix.getC() * (float)event.getClientY() + this.matrix.getE();
                this.startY = this.matrix.getB() * (float)event.getClientX() + this.matrix.getD() * (float)event.getClientY() + this.matrix.getF();
                this.changePosition(this.startX, this.startY, event.getClientX(), event.getClientX());
                this.selectionRectangle.setAttributeNS(null, "visibility", "visible");
                this.selecting = true;
            } else if (evt.getType().equals("mousemove") && this.selecting) {
                if (Math.abs(this.lastX - (float)event.getScreenX()) > 1.0f || Math.abs(this.lastY - (float)event.getScreenY()) > 1.0f) {
                    this.changePosition(this.startX, this.startY, event.getClientX(), event.getClientY());
                    this.lastX = event.getScreenX();
                    this.lastY = event.getScreenY();
                }
            } else if (evt.getType().equals("mouseup") && this.selecting) {
                this.selecting = false;
                this.process = true;
                this.changePosition(this.startX, this.startY, event.getClientX(), event.getClientY());
                this.firePropertiesUpdated();
            }
        }
    }

    protected void removeSelectionRectangle() {
        this.selectionRectangle.setAttributeNS(null, "visibility", "hidden");
        this.process = false;
        this.firePropertiesUpdated();
    }

    protected void changePosition(float x, float y, float endX, float endY) {
        this.selectionRectangle.setAttributeNS(null, "y", "" + y);
        float width = this.matrix.getA() * endX + this.matrix.getC() * endY + this.matrix.getE() - x;
        float height = this.matrix.getB() * endX + this.matrix.getD() * endY + this.matrix.getF() - y;
        if (width < 0.0f) {
            this.selectionRectangle.setAttributeNS(null, "x", "" + SVGUtils.formatNumberAttribute(x + width));
            this.selectionRectangle.setAttributeNS(null, "width", "" + SVGUtils.formatNumberAttribute(Math.abs(width)));
        } else {
            this.selectionRectangle.setAttributeNS(null, "x", "" + SVGUtils.formatNumberAttribute(x));
            this.selectionRectangle.setAttributeNS(null, "width", "" + SVGUtils.formatNumberAttribute(width));
        }
        if (height < 0.0f) {
            this.selectionRectangle.setAttributeNS(null, "y", "" + SVGUtils.formatNumberAttribute(y + height));
            this.selectionRectangle.setAttributeNS(null, "height", "" + SVGUtils.formatNumberAttribute(Math.abs(height)));
        } else {
            this.selectionRectangle.setAttributeNS(null, "y", "" + y);
            this.selectionRectangle.setAttributeNS(null, "height", "" + SVGUtils.formatNumberAttribute(height));
        }
    }

    public void setDocument(SVGDocument doc) {
        Element el = doc.getElementById("draft");
        String svgNS = "http://www.w3.org/2000/svg";
        String s = doc.getDocumentElement().getAttribute("viewBox");
        String[] data = s.split("\\s+");
        Element rectangle = doc.createElementNS(svgNS, "rect");
        double x = Double.parseDouble(data[0]);
        double y = Double.parseDouble(data[1]);
        double width = Double.parseDouble(data[2]);
        double height = Double.parseDouble(data[3]);
        rectangle.setAttributeNS(null, "x", SVGUtils.formatNumberAttribute(x - width / 2.0));
        rectangle.setAttributeNS(null, "y", SVGUtils.formatNumberAttribute(y - height / 2.0));
        rectangle.setAttributeNS(null, "width", SVGUtils.formatNumberAttribute(width * 2.0));
        rectangle.setAttributeNS(null, "height", SVGUtils.formatNumberAttribute(height * 2.0));
        rectangle.setAttributeNS(null, "style", "fill:blue;opacity:0.0;");
        EventTarget t = (EventTarget)((Object)rectangle);
        t.addEventListener("click", this, false);
        t.addEventListener("mousedown", this, false);
        t.addEventListener("mouseup", this, false);
        t.addEventListener("mousemove", this, false);
        this.selectionRectangle = doc.createElementNS(svgNS, "rect");
        this.selectionRectangle.setAttributeNS(null, "x", data[0]);
        this.selectionRectangle.setAttributeNS(null, "y", data[1]);
        this.selectionRectangle.setAttributeNS(null, "width", data[2]);
        this.selectionRectangle.setAttributeNS(null, "height", data[3]);
        this.selectionRectangle.setAttributeNS(null, "style", "fill:blue;fill-opacity:0.10;stroke:black;stroke-width:0.10%;stroke-opacity:1.0");
        this.selectionRectangle.setAttributeNS(null, "visibility", "hidden");
        doc.getDocumentElement().insertBefore(rectangle, doc.getDocumentElement().getFirstChild());
        doc.getDocumentElement().insertBefore(this.selectionRectangle, rectangle);
    }

    public void addPropertiesListener(PropertiesListener listener) {
        this.listeners.add(listener);
    }

    public Map getProperties() {
        return this.properties;
    }

    public void removePropertiesListener(PropertiesListener listener) {
        this.listeners.remove(listener);
    }

    public void setProperties(Map properties) {
    }

    protected void firePropertiesUpdated() {
        double height = Double.parseDouble(this.selectionRectangle.getAttribute("height"));
        this.properties.put("boundsfilter.x", this.selectionRectangle.getAttribute("x"));
        this.properties.put("boundsfilter.y", "" + (-1.0 * Double.parseDouble(this.selectionRectangle.getAttribute("y")) - height));
        this.properties.put("boundsfilter.width", this.selectionRectangle.getAttribute("width"));
        this.properties.put("boundsfilter.height", "" + height);
        this.properties.put("boundsfilter.process", Boolean.toString(this.process));
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            PropertiesListener listener = (PropertiesListener)i.next();
            listener.propertiesChanged(this.properties);
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.state = true;
        } else {
            this.state = false;
            this.removeSelectionRectangle();
        }
    }

    public void setCanvasUpdateManager(CanvasUpdateManager manager) {
        this.updateManager = manager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

