/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.Map;
import org.kabeja.dxf.DXF3DFace;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVG3DFaceGenerator
extends AbstractSVGSAXGenerator {
    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        DXF3DFace face = (DXF3DFace)entity;
        DXFDocument doc = face.getDXFDocument();
        if (doc.getDXFHeader().hasVariable("$SPLFRAME") && doc.getDXFHeader().getVariable("$SPLFRAME").getIntegerValue("70") == 1 || face.getFlags() == 0) {
            AttributesImpl attr = new AttributesImpl();
            StringBuffer points = new StringBuffer();
            Point point1 = face.getPoint1();
            points.append(point1.getX());
            points.append(",");
            points.append(point1.getY());
            points.append(" ");
            Point point2 = face.getPoint2();
            points.append(point2.getX());
            points.append(",");
            points.append(point2.getY());
            points.append(" ");
            Point point3 = face.getPoint3();
            points.append(point3.getX());
            points.append(",");
            points.append(point3.getY());
            points.append(" ");
            Point point4 = face.getPoint4();
            points.append(point4.getX());
            points.append(",");
            points.append(point4.getY());
            points.append(" ");
            SVGUtils.addAttribute(attr, "points", points.toString());
            super.setCommonAttributes(attr, svgContext, face);
            SVGUtils.emptyElement(handler, "polygon", attr);
        } else {
            int flag = face.getFlags();
            if ((flag & 1) == 0) {
                this.edgeToSAX(handler, face.getPoint1(), face.getPoint2(), svgContext, face);
            }
            if ((flag & 2) == 0) {
                this.edgeToSAX(handler, face.getPoint2(), face.getPoint3(), svgContext, face);
            }
            if ((flag & 4) == 0) {
                this.edgeToSAX(handler, face.getPoint3(), face.getPoint4(), svgContext, face);
            }
            if ((flag & 8) == 0) {
                this.edgeToSAX(handler, face.getPoint4(), face.getPoint1(), svgContext, face);
            }
        }
    }

    protected void edgeToSAX(ContentHandler handler, Point p1, Point p2, Map svgContext, DXF3DFace face) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        SVGUtils.addAttribute(attr, "x1", "" + p1.getX());
        double value = p1.getY();
        SVGUtils.addAttribute(attr, "y1", "" + value);
        SVGUtils.addAttribute(attr, "x2", "" + p2.getX());
        value = p2.getY();
        SVGUtils.addAttribute(attr, "y2", "" + value);
        super.setCommonAttributes(attr, svgContext, face);
        SVGUtils.emptyElement(handler, "line", attr);
    }
}

