/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.Map;
import org.kabeja.dxf.DXFEllipse;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGPathBoundaryGenerator;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGEllipseGenerator
extends AbstractSVGSAXGenerator
implements SVGPathBoundaryGenerator {
    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        DXFEllipse ellipse = (DXFEllipse)entity;
        AttributesImpl attr = new AttributesImpl();
        super.setCommonAttributes(attr, svgContext, ellipse);
        if (ellipse.getStartParameter() == 0.0 && ellipse.getEndParameter() == Math.PI * 2) {
            SVGUtils.addAttribute(attr, "cx", SVGUtils.formatNumberAttribute(ellipse.getCenterPoint().getX()));
            SVGUtils.addAttribute(attr, "cy", SVGUtils.formatNumberAttribute(ellipse.getCenterPoint().getY()));
            double major = ellipse.getHalfMajorAxisLength();
            double minor = ellipse.getRatio() * major;
            SVGUtils.addAttribute(attr, "rx", SVGUtils.formatNumberAttribute(major));
            SVGUtils.addAttribute(attr, "ry", SVGUtils.formatNumberAttribute(minor));
            double angle = ellipse.getRotationAngle();
            if (angle != 0.0) {
                StringBuffer buf = new StringBuffer();
                buf.append("rotate(");
                buf.append(SVGUtils.formatNumberAttribute(Math.toDegrees(angle)));
                buf.append(' ');
                buf.append(SVGUtils.formatNumberAttribute(ellipse.getCenterPoint().getX()));
                buf.append(' ');
                buf.append(SVGUtils.formatNumberAttribute(ellipse.getCenterPoint().getY()));
                buf.append(')');
                SVGUtils.addAttribute(attr, "transform", buf.toString());
            }
            SVGUtils.emptyElement(handler, "ellipse", attr);
        } else {
            SVGUtils.addAttribute(attr, "d", this.getSVGPath(ellipse));
            SVGUtils.emptyElement(handler, "path", attr);
        }
    }

    public String getSVGPath(DXFEntity entity) {
        DXFEllipse ellipse = (DXFEllipse)entity;
        StringBuffer buf = new StringBuffer();
        Point start = ellipse.getPointAt(ellipse.getStartParameter());
        Point end = ellipse.getPointAt(ellipse.getEndParameter());
        buf.append("M ");
        buf.append(SVGUtils.formatNumberAttribute(start.getX()));
        buf.append(' ');
        buf.append(SVGUtils.formatNumberAttribute(start.getY()));
        double major = ellipse.getMajorAxisDirection().getLength();
        double angle = ellipse.getRotationAngle();
        buf.append(" A ");
        buf.append(SVGUtils.formatNumberAttribute(major));
        buf.append(' ');
        buf.append(SVGUtils.formatNumberAttribute(major * ellipse.getRatio()));
        buf.append(' ');
        buf.append(SVGUtils.formatNumberAttribute(Math.toDegrees(angle)));
        if (ellipse.getStartParameter() == 0.0 && ellipse.getEndParameter() == Math.PI * 2) {
            buf.append(" 1 1 ");
            buf.append(SVGUtils.formatNumberAttribute(end.getX()));
            buf.append(' ');
            buf.append(SVGUtils.formatNumberAttribute(end.getY()));
            buf.append(" A ");
            buf.append(SVGUtils.formatNumberAttribute(major));
            buf.append(' ');
            buf.append(SVGUtils.formatNumberAttribute(major * ellipse.getRatio()));
            buf.append(' ');
            buf.append(SVGUtils.formatNumberAttribute(Math.toDegrees(angle)));
            buf.append(" 1 1 ");
            buf.append(SVGUtils.formatNumberAttribute(start.getX()));
            buf.append(' ');
            buf.append(SVGUtils.formatNumberAttribute(start.getY()));
        } else {
            buf.append(' ');
            if (ellipse.getEndParameter() - ellipse.getStartParameter() >= Math.PI) {
                buf.append(1);
            } else {
                buf.append(0);
            }
            buf.append(' ');
            buf.append(" 1 ");
            buf.append(SVGUtils.formatNumberAttribute(end.getX()));
            buf.append(' ');
            buf.append(SVGUtils.formatNumberAttribute(end.getY()));
        }
        return buf.toString();
    }
}

