/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.ui.impl;

import de.miethxml.toolkit.ui.PanelFactory;
import de.miethxml.toolkit.ui.UIUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import org.kabeja.processing.ProcessingManager;
import org.kabeja.ui.model.ProcessingTreeModelPresenter;

public class ProcessingTreeViewBuilder {
    protected ProcessingManager manager;
    protected JTree tree;

    public ProcessingTreeViewBuilder(ProcessingManager processingManager) {
        this.manager = processingManager;
    }

    public JComponent getView() {
        JSplitPane jSplitPane = PanelFactory.createOneTouchSplitPane();
        this.tree = new JTree(new ProcessingTreeModelPresenter(this.manager));
        this.tree.setEditable(true);
        this.tree.setDragEnabled(true);
        this.tree.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.tree.setRowHeight(0);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel = PanelFactory.createTitledPanel(jScrollPane, "ProcessingTree", "Options", this.createBorderMenu());
        jPanel.setPreferredSize(new Dimension(150, 350));
        jSplitPane.setLeftComponent(jPanel);
        JPanel jPanel2 = PanelFactory.createTitledPanel((JComponent)new JPanel(), (String)"Property Editor");
        jPanel2.setPreferredSize(new Dimension(150, 70));
        jSplitPane.setRightComponent(jPanel2);
        return jSplitPane;
    }

    private JPopupMenu createBorderMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Expand All", new ImageIcon(UIUtils.resourceToBytes(this.getClass(), "/icons/expand_all.gif")));
        jMenuItem.setMnemonic('E');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < ProcessingTreeViewBuilder.this.tree.getRowCount(); ++i) {
                    ProcessingTreeViewBuilder.this.tree.expandRow(i);
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Collapse All", new ImageIcon(UIUtils.resourceToBytes(this.getClass(), "/icons/collapse_all.gif")));
        jMenuItem.setMnemonic('C');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = ProcessingTreeViewBuilder.this.tree.getRowCount() - 1; i > 0; --i) {
                    ProcessingTreeViewBuilder.this.tree.collapseRow(i);
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }
}

