/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.ui.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.kabeja.processing.ProcessingManager;
import org.kabeja.ui.model.PropertyTreeNode;

public abstract class AbstractProcessingTreeNode
implements TreeNode {
    protected ProcessingManager manager;
    protected TreeNode parent;
    protected List children = new ArrayList();
    protected String label;

    public AbstractProcessingTreeNode(TreeNode treeNode, String string) {
        this.parent = treeNode;
        this.label = string;
    }

    public void setProcessorManager(ProcessingManager processingManager) {
        this.manager = processingManager;
        this.initializeChildren();
    }

    public TreeNode getParent() {
        return this.parent;
    }

    protected void addChild(AbstractProcessingTreeNode abstractProcessingTreeNode) {
        abstractProcessingTreeNode.setProcessorManager(this.manager);
        this.children.add(abstractProcessingTreeNode);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        return this.children.indexOf(treeNode);
    }

    public TreeNode getChildAt(int n) {
        return (TreeNode)this.children.get(n);
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    protected abstract void initializeChildren();

    public String toString() {
        return this.getLabel();
    }

    protected void propertiesToChildren(Map map) {
        if (map == null) {
            System.out.println("huuuuuuuuu=" + this.getClass());
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            this.addChild(new PropertyTreeNode(this, map, (String)iterator.next()));
        }
    }

    protected String getLabel() {
        return this.label;
    }
}

