@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  JavaCad startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

@rem Add default JVM options here. You can also use JAVA_OPTS and JAVA_CAD_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windowz variants

if not "%OS%" == "Windows_NT" goto win9xME_args
if "%@eval[2+2]" == "4" goto 4NT_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*
goto execute

:4NT_args
@rem Get arguments from the 4NT Shell from JP Software
set CMD_LINE_ARGS=%$

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\JavaCad-0.13.6.jar;%APP_HOME%\lib\batik-all.jar;%APP_HOME%\lib\miethxml-ui.jar;%APP_HOME%\lib\kabeja-0.4.jar;%APP_HOME%\lib\xml-apis.jar;%APP_HOME%\lib\pdf-transcoder.jar;%APP_HOME%\lib\kabeja-svg-0.4.jar;%APP_HOME%\lib\xml-apis-ext.jar;%APP_HOME%\lib\kabeja-xslt.jar;%APP_HOME%\lib\js.jar;%APP_HOME%\lib\miethxml-toolkit.jar;%APP_HOME%\lib\commons-io-2.4.jar;%APP_HOME%\lib\json-simple-1.1.jar;%APP_HOME%\lib\gson-2.5.jar;%APP_HOME%\lib\vvecmath-0.3.2.jar;%APP_HOME%\lib\vecmath-1.3.1.jar;%APP_HOME%\lib\slf4j-simple-1.6.1.jar;%APP_HOME%\lib\batik-svggen-1.7.jar;%APP_HOME%\lib\slf4j-api-1.6.1.jar;%APP_HOME%\lib\batik-awt-util-1.7.jar;%APP_HOME%\lib\batik-util-1.7.jar;%APP_HOME%\lib\xml-apis-1.3.04.jar

@rem Execute JavaCad
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %JAVA_CAD_OPTS%  -classpath "%CLASSPATH%" eu.mihosoft.vrl.v3d.Main %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable JAVA_CAD_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%JAVA_CAD_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
