/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.slideshow;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JWindow;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class Main
extends JComponent {
    StaticRenderer renderer;
    UserAgent userAgent;
    DocumentLoader loader;
    BridgeContext ctx;
    BufferedImage image;
    BufferedImage display;
    File[] files;
    static int duration = 3000;
    static int frameDelay = duration + 7000;
    boolean done = false;
    volatile Thread transitionThread = null;
    long startLastTransition = 0L;
    volatile boolean paused = false;

    public Main(File[] fileArray, Dimension dimension) {
        this.setBackground(Color.black);
        this.files = fileArray;
        UserAgentAdapter userAgentAdapter = new UserAgentAdapter();
        this.renderer = new StaticRenderer();
        this.userAgent = userAgentAdapter;
        this.loader = new DocumentLoader(this.userAgent);
        this.ctx = new BridgeContext(this.userAgent, this.loader);
        userAgentAdapter.setBridgeContext(this.ctx);
        if (dimension == null) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
        }
        this.setPreferredSize(dimension);
        this.setDoubleBuffered(false);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (Main.this.done) {
                    System.exit(0);
                } else {
                    Main.this.togglePause();
                }
            }
        });
        dimension.width += 2;
        dimension.height += 2;
        this.display = new BufferedImage(dimension.width, dimension.height, 4);
        RenderThread renderThread = new RenderThread();
        renderThread.start();
        JWindow jWindow = new JWindow();
        jWindow.setBackground(Color.black);
        jWindow.getContentPane().setBackground(Color.black);
        jWindow.getContentPane().add(this);
        jWindow.pack();
        jWindow.setLocation(new Point(-1, -1));
        jWindow.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransition(BufferedImage bufferedImage) {
        Main main = this;
        synchronized (main) {
            while (this.transitionThread != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.transitionThread = new TransitionThread(bufferedImage);
            this.transitionThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void togglePause() {
        Main main = this;
        synchronized (main) {
            Cursor cursor;
            boolean bl = this.paused = !this.paused;
            if (this.paused) {
                cursor = new Cursor(3);
            } else {
                cursor = new Cursor(0);
                if (this.transitionThread != null) {
                    Thread thread = this.transitionThread;
                    synchronized (thread) {
                        this.transitionThread.notifyAll();
                    }
                }
            }
            this.setCursor(cursor);
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.display == null) {
            return;
        }
        graphics2D.drawImage(this.display, null, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFileList(String string, List list) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Unable to open file-list: " + string);
            return;
        }
        try {
            String string2;
            URL uRL = new File(string).toURL();
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3 = string2;
                int n = string3.indexOf(35);
                if (n != -1) {
                    string3 = string3.substring(0, n);
                }
                if ((string3 = string3.trim()).length() == 0) continue;
                try {
                    URL uRL2 = new URL(uRL, string3);
                    list.add(uRL2.getFile());
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("Can't make sense of line:\n  " + string2);
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Error while reading file-list: " + string);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void main(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Dimension dimension = null;
        if (stringArray.length == 0) {
            Main.showUsage();
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-h") || stringArray[i].equals("-help") || stringArray[i].equals("--help")) {
                Main.showUsage();
                return;
            }
            if (stringArray[i].equals("--")) {
                ++i;
                while (i < stringArray.length) {
                    arrayList.add(stringArray[i++]);
                }
                break;
            }
            if (stringArray[i].equals("-fl") || stringArray[i].equals("--file-list")) {
                if (i + 1 == stringArray.length) {
                    System.err.println("Must provide name of file list file after " + stringArray[i]);
                    break;
                }
                Main.readFileList(stringArray[i + 1], arrayList);
                ++i;
                continue;
            }
            if (stringArray[i].equals("-ft") || stringArray[i].equals("--frame-time")) {
                if (i + 1 == stringArray.length) {
                    System.err.println("Must provide time in millis after " + stringArray[i]);
                    break;
                }
                try {
                    frameDelay = Integer.decode(stringArray[i + 1]);
                    ++i;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't parse frame time: " + stringArray[i + 1]);
                }
                continue;
            }
            if (stringArray[i].equals("-tt") || stringArray[i].equals("--transition-time")) {
                if (i + 1 == stringArray.length) {
                    System.err.println("Must provide time in millis after " + stringArray[i]);
                    break;
                }
                try {
                    duration = Integer.decode(stringArray[i + 1]);
                    ++i;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't parse transition time: " + stringArray[i + 1]);
                }
                continue;
            }
            if (stringArray[i].equals("-ws") || stringArray[i].equals("--window-size")) {
                if (i + 1 == stringArray.length) {
                    System.err.println("Must provide window size [w,h] after " + stringArray[i]);
                    break;
                }
                try {
                    int n;
                    int n2;
                    int n3 = stringArray[i + 1].indexOf(44);
                    if (n3 == -1) {
                        n = n2 = Integer.decode(stringArray[i + 1]).intValue();
                    } else {
                        String string = stringArray[i + 1].substring(0, n3);
                        String string2 = stringArray[i + 1].substring(n3 + 1);
                        n = Integer.decode(string);
                        n2 = Integer.decode(string2);
                    }
                    dimension = new Dimension(n, n2);
                    ++i;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't parse window size: " + stringArray[i + 1]);
                }
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        File[] fileArray = new File[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                fileArray[i] = new File((String)arrayList.get(i));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        new Main(fileArray, dimension);
    }

    public static void showUsage() {
        System.out.println("Options:\n                                 -- : Remaining args are file names\n                         -fl <file>\n                 --file-list <file> : file contains list of images to\n                                      show one per line\n             -ws <width>[,<height>]\n    -window-size <width>[,<height>] : Set the size of slideshow window\n                                      defaults to full screen\n                          -ft <int>\n                 --frame-time <int> : Amount of time in millisecs to\n                                      show each frame.\n                                      Includes transition time.\n                          -tt <int>\n            --transition-time <int> : Amount of time in millisecs to\n                                      transition between frames.\n                             <file> : SVG file to display");
    }

    class TransitionThread
    extends Thread {
        BufferedImage src;
        int blockw = 75;
        int blockh = 75;

        public TransitionThread(BufferedImage bufferedImage) {
            this.src = bufferedImage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = (Main.this.display.getWidth() + this.blockw - 1) / this.blockw;
            int n2 = (Main.this.display.getHeight() + this.blockh - 1) / this.blockh;
            int n3 = n * n2;
            int n4 = duration / n3;
            Point[] pointArray = new Point[n3];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    pointArray[i * n + j] = new Point(j, i);
                }
            }
            Graphics2D graphics2D = Main.this.display.createGraphics();
            graphics2D.setColor(Color.black);
            long l = System.currentTimeMillis();
            while (l - Main.this.startLastTransition < (long)frameDelay) {
                try {
                    long l2 = (long)frameDelay - (l - Main.this.startLastTransition);
                    if (l2 > 500L) {
                        System.gc();
                        l = System.currentTimeMillis();
                        l2 = (long)frameDelay - (l - Main.this.startLastTransition);
                    }
                    if (l2 > 0L) {
                        TransitionThread.sleep(l2);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l = System.currentTimeMillis();
            }
            TransitionThread transitionThread = this;
            synchronized (transitionThread) {
                while (Main.this.paused) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            long l3 = Main.this.startLastTransition = System.currentTimeMillis();
            for (int i = 0; i < pointArray.length; ++i) {
                int n5 = (int)(Math.random() * (double)(pointArray.length - i));
                Point point = pointArray[n5];
                System.arraycopy(pointArray, n5 + 1, pointArray, n5 + 1 - 1, pointArray.length - i - n5 + 1);
                int n6 = point.x * this.blockw;
                int n7 = point.y * this.blockh;
                int n8 = this.blockw;
                int n9 = this.blockh;
                if (n6 + n8 > this.src.getWidth()) {
                    n8 = this.src.getWidth() - n6;
                }
                if (n7 + n9 > this.src.getHeight()) {
                    n9 = this.src.getHeight() - n7;
                }
                BufferedImage bufferedImage = Main.this.display;
                synchronized (bufferedImage) {
                    graphics2D.fillRect(n6, n7, n8, n9);
                    BufferedImage bufferedImage2 = this.src.getSubimage(n6, n7, n8, n9);
                    graphics2D.drawImage(bufferedImage2, null, n6, n7);
                }
                Main.this.repaint(n6, n7, n8, n9);
                long l4 = System.currentTimeMillis();
                try {
                    long l5 = l4 - l3;
                    if (l5 < (long)n4) {
                        TransitionThread.sleep((long)n4 - l5);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l3 = l4;
            }
            Main main = Main.this;
            synchronized (main) {
                Main.this.transitionThread = null;
                Main.this.notifyAll();
            }
        }
    }

    class RenderThread
    extends Thread {
        RenderThread() {
        }

        public void run() {
            Main.this.renderer.setDoubleBuffered(true);
            for (int i = 0; i < Main.this.files.length; ++i) {
                GraphicsNode graphicsNode = null;
                GVTBuilder gVTBuilder = new GVTBuilder();
                try {
                    System.out.println("Reading: " + Main.this.files[i]);
                    Document document = Main.this.loader.loadDocument(Main.this.files[i].toURL().toString());
                    System.out.println("Building: " + Main.this.files[i]);
                    graphicsNode = gVTBuilder.build(Main.this.ctx, document);
                    System.out.println("Rendering: " + Main.this.files[i]);
                    Main.this.renderer.setTree(graphicsNode);
                    SVGSVGElement sVGSVGElement = ((SVGDocument)document).getRootElement();
                    Main.this.renderer.setTransform(ViewBox.getViewTransform(null, (Element)sVGSVGElement, Main.this.display.getWidth(), Main.this.display.getHeight(), Main.this.ctx));
                    Main.this.renderer.updateOffScreen(Main.this.display.getWidth(), Main.this.display.getHeight());
                    Rectangle rectangle = new Rectangle(0, 0, Main.this.display.getWidth(), Main.this.display.getHeight());
                    Main.this.renderer.repaint(rectangle);
                    System.out.println("Painting: " + Main.this.files[i]);
                    Main.this.image = Main.this.renderer.getOffScreen();
                    Main.this.setTransition(Main.this.image);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (Main.this.transitionThread != null) {
                try {
                    Main.this.transitionThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Main.this.done = true;
                Main.this.setCursor(new Cursor(3));
            }
        }
    }
}

