/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.SVGOMAnimatedPathData;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.parser.PathHandler;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPathSegArcRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothRel;
import org.w3c.dom.svg.SVGPathSegLinetoAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalRel;
import org.w3c.dom.svg.SVGPathSegLinetoRel;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalRel;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPathSegMovetoRel;

public abstract class SVGAnimatedPathDataSupport {
    public static final String D_DEFAULT_VALUE = "";

    public static SVGOMAnimatedPathData getAnimatedPathData(AbstractElement abstractElement) {
        SVGOMAnimatedPathData sVGOMAnimatedPathData = (SVGOMAnimatedPathData)abstractElement.getLiveAttributeValue(null, "d");
        if (sVGOMAnimatedPathData == null) {
            sVGOMAnimatedPathData = new SVGOMAnimatedPathData(abstractElement, null, "d", D_DEFAULT_VALUE);
            SVGOMDocument sVGOMDocument = (SVGOMDocument)abstractElement.getOwnerDocument();
            sVGOMAnimatedPathData.addAnimatedAttributeListener(sVGOMDocument.getAnimatedAttributeListener());
            abstractElement.putLiveAttributeValue(null, "d", sVGOMAnimatedPathData);
        }
        return sVGOMAnimatedPathData;
    }

    public static SVGPathSegList getPathSegList(AbstractElement abstractElement) {
        return SVGAnimatedPathDataSupport.getAnimatedPathData(abstractElement).getPathSegList();
    }

    public static SVGPathSegList getNormalizedPathSegList(AbstractElement abstractElement) {
        return SVGAnimatedPathDataSupport.getAnimatedPathData(abstractElement).getNormalizedPathSegList();
    }

    public static SVGPathSegList getAnimatedPathSegList(AbstractElement abstractElement) {
        return SVGAnimatedPathDataSupport.getAnimatedPathData(abstractElement).getAnimatedPathSegList();
    }

    public static SVGPathSegList getAnimatedNormalizedPathSegList(AbstractElement abstractElement) {
        return SVGAnimatedPathDataSupport.getAnimatedPathData(abstractElement).getAnimatedNormalizedPathSegList();
    }

    public static void handlePathSegList(SVGPathSegList sVGPathSegList, PathHandler pathHandler) {
        int n = sVGPathSegList.getNumberOfItems();
        pathHandler.startPath();
        block21: for (int i = 0; i < n; ++i) {
            SVGPathSeg sVGPathSeg = sVGPathSegList.getItem(i);
            switch (sVGPathSeg.getPathSegType()) {
                case 1: {
                    pathHandler.closePath();
                    continue block21;
                }
                case 2: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegMovetoAbs)sVGPathSeg;
                    pathHandler.movetoAbs(sVGPathSegMovetoAbs.getX(), sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 3: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegMovetoRel)sVGPathSeg;
                    pathHandler.movetoRel(sVGPathSegMovetoAbs.getX(), sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 4: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegLinetoAbs)sVGPathSeg;
                    pathHandler.linetoAbs(sVGPathSegMovetoAbs.getX(), sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 5: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegLinetoRel)sVGPathSeg;
                    pathHandler.linetoRel(sVGPathSegMovetoAbs.getX(), sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 6: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegCurvetoCubicAbs)sVGPathSeg;
                    pathHandler.curvetoCubicAbs(sVGPathSegMovetoAbs.getX1(), sVGPathSegMovetoAbs.getY1(), sVGPathSegMovetoAbs.getX2(), sVGPathSegMovetoAbs.getY2(), sVGPathSegMovetoAbs.getX(), sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 7: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegCurvetoCubicRel)sVGPathSeg;
                    pathHandler.curvetoCubicRel(sVGPathSegMovetoAbs.getX1(), sVGPathSegMovetoAbs.getY1(), sVGPathSegMovetoAbs.getX2(), sVGPathSegMovetoAbs.getY2(), sVGPathSegMovetoAbs.getX(), sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 8: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegCurvetoQuadraticAbs)sVGPathSeg;
                    pathHandler.curvetoQuadraticAbs(sVGPathSegMovetoAbs.getX1(), sVGPathSegMovetoAbs.getY1(), sVGPathSegMovetoAbs.getX(), sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 9: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegCurvetoQuadraticRel)sVGPathSeg;
                    pathHandler.curvetoQuadraticRel(sVGPathSegMovetoAbs.getX1(), sVGPathSegMovetoAbs.getY1(), sVGPathSegMovetoAbs.getX(), sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 10: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegArcAbs)sVGPathSeg;
                    pathHandler.arcAbs(sVGPathSegMovetoAbs.getR1(), sVGPathSegMovetoAbs.getR2(), sVGPathSegMovetoAbs.getAngle(), sVGPathSegMovetoAbs.getLargeArcFlag(), sVGPathSegMovetoAbs.getSweepFlag(), sVGPathSegMovetoAbs.getX(), sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 11: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegArcRel)sVGPathSeg;
                    pathHandler.arcRel(sVGPathSegMovetoAbs.getR1(), sVGPathSegMovetoAbs.getR2(), sVGPathSegMovetoAbs.getAngle(), sVGPathSegMovetoAbs.getLargeArcFlag(), sVGPathSegMovetoAbs.getSweepFlag(), sVGPathSegMovetoAbs.getX(), sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 12: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegLinetoHorizontalAbs)sVGPathSeg;
                    pathHandler.linetoHorizontalAbs(sVGPathSegMovetoAbs.getX());
                    continue block21;
                }
                case 13: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegLinetoHorizontalRel)sVGPathSeg;
                    pathHandler.linetoHorizontalRel(sVGPathSegMovetoAbs.getX());
                    continue block21;
                }
                case 14: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegLinetoVerticalAbs)sVGPathSeg;
                    pathHandler.linetoVerticalAbs(sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 15: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegLinetoVerticalRel)sVGPathSeg;
                    pathHandler.linetoVerticalRel(sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 16: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg;
                    pathHandler.curvetoCubicSmoothAbs(sVGPathSegMovetoAbs.getX2(), sVGPathSegMovetoAbs.getY2(), sVGPathSegMovetoAbs.getX(), sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 17: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg;
                    pathHandler.curvetoCubicSmoothRel(sVGPathSegMovetoAbs.getX2(), sVGPathSegMovetoAbs.getY2(), sVGPathSegMovetoAbs.getX(), sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 18: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegCurvetoQuadraticSmoothAbs)sVGPathSeg;
                    pathHandler.curvetoQuadraticSmoothAbs(sVGPathSegMovetoAbs.getX(), sVGPathSegMovetoAbs.getY());
                    continue block21;
                }
                case 19: {
                    SVGPathSegMovetoAbs sVGPathSegMovetoAbs = (SVGPathSegCurvetoQuadraticSmoothRel)sVGPathSeg;
                    pathHandler.curvetoQuadraticSmoothRel(sVGPathSegMovetoAbs.getX(), sVGPathSegMovetoAbs.getY());
                }
            }
        }
        pathHandler.endPath();
    }
}

