/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Color;
import org.apache.batik.ext.awt.image.AbstractLight;

public class SpotLight
extends AbstractLight {
    private double lightX;
    private double lightY;
    private double lightZ;
    private double pointAtX;
    private double pointAtY;
    private double pointAtZ;
    private double specularExponent;
    private double limitingConeAngle;
    private double limitingCos;
    private final double[] S = new double[3];

    public double getLightX() {
        return this.lightX;
    }

    public double getLightY() {
        return this.lightY;
    }

    public double getLightZ() {
        return this.lightZ;
    }

    public double getPointAtX() {
        return this.pointAtX;
    }

    public double getPointAtY() {
        return this.pointAtY;
    }

    public double getPointAtZ() {
        return this.pointAtZ;
    }

    public double getSpecularExponent() {
        return this.specularExponent;
    }

    public double getLimitingConeAngle() {
        return this.limitingConeAngle;
    }

    public SpotLight(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, Color color) {
        super(color);
        this.lightX = d;
        this.lightY = d2;
        this.lightZ = d3;
        this.pointAtX = d4;
        this.pointAtY = d5;
        this.pointAtZ = d6;
        this.specularExponent = d7;
        this.limitingConeAngle = d8;
        this.limitingCos = Math.cos(d8 * Math.PI / 180.0);
        this.S[0] = d4 - d;
        this.S[1] = d5 - d2;
        this.S[2] = d6 - d3;
        double d9 = 1.0 / Math.sqrt(this.S[0] * this.S[0] + this.S[1] * this.S[1] + this.S[2] * this.S[2]);
        this.S[0] = this.S[0] * d9;
        this.S[1] = this.S[1] * d9;
        this.S[2] = this.S[2] * d9;
    }

    public boolean isConstant() {
        return false;
    }

    public final double getLightBase(double d, double d2, double d3, double[] dArray) {
        double d4 = this.lightX - d;
        double d5 = this.lightY - d2;
        double d6 = this.lightZ - d3;
        double d7 = 1.0 / Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        double d8 = -((d4 *= d7) * this.S[0] + (d5 *= d7) * this.S[1] + (d6 *= d7) * this.S[2]);
        dArray[0] = d4;
        dArray[1] = d5;
        dArray[2] = d6;
        if (d8 <= this.limitingCos) {
            return 0.0;
        }
        double d9 = this.limitingCos / d8;
        d9 *= d9;
        d9 *= d9;
        d9 *= d9;
        d9 *= d9;
        d9 *= d9;
        d9 *= d9;
        d9 = 1.0 - d9;
        return d9 * Math.pow(d8, this.specularExponent);
    }

    public final void getLight(double d, double d2, double d3, double[] dArray) {
        double d4 = this.getLightBase(d, d2, d3, dArray);
        dArray[0] = dArray[0] * d4;
        dArray[1] = dArray[1] * d4;
        dArray[2] = dArray[2] * d4;
    }

    public final void getLight4(double d, double d2, double d3, double[] dArray) {
        dArray[3] = this.getLightBase(d, d2, d3, dArray);
    }

    public double[][] getLightRow4(double d, double d2, double d3, int n, double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = dArray2;
        if (dArray3 == null) {
            dArray3 = new double[n][4];
        }
        for (int i = 0; i < n; ++i) {
            this.getLight4(d, d2, dArray[i][3], dArray3[i]);
            d += d3;
        }
        return dArray3;
    }
}

