/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.Collections;
import java.util.Map;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.Typeface;

public class Font {
    public static final String DEFAULT_FONT = "any,normal,400";
    public static final int NORMAL = 400;
    public static final int BOLD = 700;
    private String fontName;
    private int fontSize;
    private FontMetrics metric;

    public Font(String key, FontMetrics met, int fontSize) {
        this.fontName = key;
        this.metric = met;
        this.fontSize = fontSize;
    }

    public int getAscender() {
        return this.metric.getAscender(this.fontSize) / 1000;
    }

    public int getCapHeight() {
        return this.metric.getCapHeight(this.fontSize) / 1000;
    }

    public int getDescender() {
        return this.metric.getDescender(this.fontSize) / 1000;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getXHeight() {
        return this.metric.getXHeight(this.fontSize) / 1000;
    }

    public Map getKerning() {
        Map ret = this.metric.getKerningInfo();
        if (ret != null) {
            return ret;
        }
        return Collections.EMPTY_MAP;
    }

    public int getWidth(int charnum) {
        return this.metric.getWidth(charnum, this.fontSize) / 1000;
    }

    public char mapChar(char c) {
        if (this.metric instanceof Typeface) {
            return ((Typeface)this.metric).mapChar(c);
        }
        char d = CodePointMapping.getMapping("WinAnsiEncoding").mapChar(c);
        c = d != '\u0000' ? d : (char)35;
        return c;
    }

    public boolean hasChar(char c) {
        if (this.metric instanceof Typeface) {
            return ((Typeface)this.metric).hasChar(c);
        }
        return CodePointMapping.getMapping("WinAnsiEncoding").mapChar(c) > '\u0000';
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(');
        sbuf.append(this.fontName);
        sbuf.append(',');
        sbuf.append(this.fontSize);
        sbuf.append(')');
        return sbuf.toString();
    }

    public int getCharWidth(char c) {
        int width;
        if (c == '\n' || c == '\r' || c == '\t' || c == '\u00a0') {
            width = this.getCharWidth(' ');
        } else {
            width = this.getWidth(this.mapChar(c));
            if (width <= 0) {
                int em = this.getWidth(this.mapChar('m'));
                int en = this.getWidth(this.mapChar('n'));
                if (em <= 0) {
                    em = 500 * this.getFontSize();
                }
                if (en <= 0) {
                    en = em - 10;
                }
                if (c == ' ') {
                    width = em;
                }
                if (c == '\u2000') {
                    width = en;
                }
                if (c == '\u2001') {
                    width = em;
                }
                if (c == '\u2002') {
                    width = em / 2;
                }
                if (c == '\u2003') {
                    width = this.getFontSize();
                }
                if (c == '\u2004') {
                    width = em / 3;
                }
                if (c == '\u2005') {
                    width = em / 4;
                }
                if (c == '\u2006') {
                    width = em / 6;
                }
                if (c == '\u2007') {
                    width = this.getCharWidth(' ');
                }
                if (c == '\u2008') {
                    width = this.getCharWidth('.');
                }
                if (c == '\u2009') {
                    width = em / 5;
                }
                if (c == '\u200a') {
                    width = 5;
                }
                if (c == '\u200b') {
                    width = 100;
                }
                if (c == '\u202f') {
                    width = this.getCharWidth(' ') / 2;
                }
                if (c == '\u3000') {
                    width = this.getCharWidth(' ') * 2;
                }
            }
        }
        return width;
    }

    public int getWordWidth(String word) {
        if (word == null) {
            return 0;
        }
        int wordLength = word.length();
        int width = 0;
        char[] characters = new char[wordLength];
        word.getChars(0, wordLength, characters, 0);
        int i = 0;
        while (i < wordLength) {
            width += this.getCharWidth(characters[i]);
            ++i;
        }
        return width;
    }
}

