/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFSubSetFile;
import org.apache.fop.fonts.type1.PFBData;
import org.apache.fop.fonts.type1.PFBParser;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFCIDFont;
import org.apache.fop.pdf.PDFCIDFontDescriptor;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEncoding;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFFontDescriptor;
import org.apache.fop.pdf.PDFFontNonBase14;
import org.apache.fop.pdf.PDFFontType0;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFGoTo;
import org.apache.fop.pdf.PDFGoToRemote;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFInternalLink;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFRectangle;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFT1Stream;
import org.apache.fop.pdf.PDFTTFStream;
import org.apache.fop.pdf.PDFUri;
import org.apache.fop.pdf.PDFWArray;

public class PDFFactory {
    private PDFDocument document;
    private Log log = LogFactory.getLog("org.apache.fop.pdf");

    public PDFFactory(PDFDocument document) {
        this.document = document;
    }

    public final PDFDocument getDocument() {
        return this.document;
    }

    public PDFRoot makeRoot(PDFPages pages) {
        PDFRoot pdfRoot = new PDFRoot(++this.document.objectcount, pages);
        this.getDocument().addTrailerObject(pdfRoot);
        return pdfRoot;
    }

    public PDFPages makePages() {
        PDFPages pdfPages = new PDFPages(++this.document.objectcount);
        this.getDocument().addTrailerObject(pdfPages);
        return pdfPages;
    }

    public PDFResources makeResources() {
        PDFResources pdfResources = new PDFResources(++this.document.objectcount);
        this.getDocument().addTrailerObject(pdfResources);
        return pdfResources;
    }

    protected PDFInfo makeInfo(String prod) {
        PDFInfo pdfInfo = new PDFInfo();
        pdfInfo.setProducer(prod);
        this.getDocument().registerObject(pdfInfo);
        return pdfInfo;
    }

    public PDFPage makePage(PDFResources resources, int pageWidth, int pageHeight, int pageIndex) {
        PDFPage page = new PDFPage(resources, pageWidth, pageHeight, pageIndex);
        this.getDocument().assignObjectNumber(page);
        this.getDocument().getPages().addPage(page);
        return page;
    }

    public PDFPage makePage(PDFResources resources, int pageWidth, int pageHeight) {
        return this.makePage(resources, pageWidth, pageHeight, -1);
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theSize, int theBitsPerSample, int theOrder, List theEncode, List theDecode, StringBuffer theFunctionDataStream, List theFilter) {
        PDFFunction function = new PDFFunction(theFunctionType, theDomain, theRange, theSize, theBitsPerSample, theOrder, theEncode, theDecode, theFunctionDataStream, theFilter);
        PDFFunction oldfunc = this.getDocument().findFunction(function);
        if (oldfunc == null) {
            this.getDocument().registerObject(function);
        } else {
            function = oldfunc;
        }
        return function;
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theCZero, List theCOne, double theInterpolationExponentN) {
        PDFFunction function = new PDFFunction(theFunctionType, theDomain, theRange, theCZero, theCOne, theInterpolationExponentN);
        PDFFunction oldfunc = this.getDocument().findFunction(function);
        if (oldfunc == null) {
            this.getDocument().registerObject(function);
        } else {
            function = oldfunc;
        }
        return function;
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theFunctions, List theBounds, List theEncode) {
        PDFFunction function = new PDFFunction(theFunctionType, theDomain, theRange, theFunctions, theBounds, theEncode);
        PDFFunction oldfunc = this.getDocument().findFunction(function);
        if (oldfunc == null) {
            this.getDocument().registerObject(function);
        } else {
            function = oldfunc;
        }
        return function;
    }

    public PDFFunction makeFunction(int theNumber, int theFunctionType, List theDomain, List theRange, StringBuffer theFunctionDataStream) {
        PDFFunction function = new PDFFunction(theFunctionType, theDomain, theRange, theFunctionDataStream);
        PDFFunction oldfunc = this.getDocument().findFunction(function);
        if (oldfunc == null) {
            this.getDocument().registerObject(function);
        } else {
            function = oldfunc;
        }
        return function;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, List theDomain, List theMatrix, PDFFunction theFunction) {
        PDFShading shading = new PDFShading(theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theDomain, theMatrix, theFunction);
        PDFShading oldshad = this.getDocument().findShading(shading);
        if (oldshad == null) {
            this.getDocument().registerObject(shading);
        } else {
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.getDocument().getResources().addShading(shading);
        }
        return shading;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, List theCoords, List theDomain, PDFFunction theFunction, List theExtend) {
        PDFShading shading = new PDFShading(theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theCoords, theDomain, theFunction, theExtend);
        PDFShading oldshad = this.getDocument().findShading(shading);
        if (oldshad == null) {
            this.getDocument().registerObject(shading);
        } else {
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.getDocument().getResources().addShading(shading);
        }
        return shading;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, int theBitsPerCoordinate, int theBitsPerComponent, int theBitsPerFlag, List theDecode, PDFFunction theFunction) {
        PDFShading shading = new PDFShading(theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theBitsPerCoordinate, theBitsPerComponent, theBitsPerFlag, theDecode, theFunction);
        PDFShading oldshad = this.getDocument().findShading(shading);
        if (oldshad == null) {
            this.getDocument().registerObject(shading);
        } else {
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.getDocument().getResources().addShading(shading);
        }
        return shading;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, int theBitsPerCoordinate, int theBitsPerComponent, List theDecode, int theVerticesPerRow, PDFFunction theFunction) {
        PDFShading shading = new PDFShading(theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theBitsPerCoordinate, theBitsPerComponent, theDecode, theVerticesPerRow, theFunction);
        PDFShading oldshad = this.getDocument().findShading(shading);
        if (oldshad == null) {
            this.getDocument().registerObject(shading);
        } else {
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.getDocument().getResources().addShading(shading);
        }
        return shading;
    }

    public PDFPattern makePattern(PDFResourceContext res, int thePatternType, PDFResources theResources, int thePaintType, int theTilingType, List theBBox, double theXStep, double theYStep, List theMatrix, List theXUID, StringBuffer thePatternDataStream) {
        PDFPattern pattern = new PDFPattern(theResources, 1, thePaintType, theTilingType, theBBox, theXStep, theYStep, theMatrix, theXUID, thePatternDataStream);
        PDFPattern oldpatt = this.getDocument().findPattern(pattern);
        if (oldpatt == null) {
            this.getDocument().registerObject(pattern);
        } else {
            pattern = oldpatt;
        }
        if (res != null) {
            res.getPDFResources().addPattern(pattern);
        } else {
            this.getDocument().getResources().addPattern(pattern);
        }
        return pattern;
    }

    public PDFPattern makePattern(PDFResourceContext res, int thePatternType, PDFShading theShading, List theXUID, StringBuffer theExtGState, List theMatrix) {
        PDFPattern pattern = new PDFPattern(2, theShading, theXUID, theExtGState, theMatrix);
        PDFPattern oldpatt = this.getDocument().findPattern(pattern);
        if (oldpatt == null) {
            this.getDocument().registerObject(pattern);
        } else {
            pattern = oldpatt;
        }
        if (res != null) {
            res.getPDFResources().addPattern(pattern);
        } else {
            this.getDocument().getResources().addPattern(pattern);
        }
        return pattern;
    }

    public PDFPattern makeGradient(PDFResourceContext res, boolean radial, PDFColorSpace theColorspace, List theColors, List theBounds, List theCoords, List theMatrix) {
        PDFShading myShad;
        double interpolation = 1.0;
        ArrayList<PDFFunction> theFunctions = new ArrayList<PDFFunction>();
        int lastPosition = theColors.size() - 1;
        int currentPosition = 0;
        while (currentPosition < lastPosition) {
            PDFColor currentColor = (PDFColor)theColors.get(currentPosition);
            PDFColor nextColor = (PDFColor)theColors.get(currentPosition + 1);
            if (this.getDocument().getColorSpace() != currentColor.getColorSpace()) {
                currentColor.setColorSpace(this.getDocument().getColorSpace());
            }
            if (this.getDocument().getColorSpace() != nextColor.getColorSpace()) {
                nextColor.setColorSpace(this.getDocument().getColorSpace());
            }
            List theCzero = currentColor.getVector();
            List theCone = nextColor.getVector();
            PDFFunction myfunc = this.makeFunction(2, null, null, theCzero, theCone, interpolation);
            theFunctions.add(myfunc);
            ++currentPosition;
        }
        PDFFunction myfunky = this.makeFunction(3, null, null, theFunctions, theBounds, null);
        if (radial) {
            if (theCoords.size() == 6) {
                myShad = this.makeShading(res, 3, this.getDocument().getPDFColorSpace(), null, null, false, theCoords, null, myfunky, null);
            } else {
                ArrayList newCoords = new ArrayList();
                newCoords.add(theCoords.get(0));
                newCoords.add(theCoords.get(1));
                newCoords.add(theCoords.get(2));
                newCoords.add(theCoords.get(0));
                newCoords.add(theCoords.get(1));
                newCoords.add(new Double(0.0));
                myShad = this.makeShading(res, 3, this.getDocument().getPDFColorSpace(), null, null, false, newCoords, null, myfunky, null);
            }
        } else {
            myShad = this.makeShading(res, 2, this.getDocument().getPDFColorSpace(), null, null, false, theCoords, null, myfunky, null);
        }
        PDFPattern myPattern = this.makePattern(res, 2, myShad, null, null, theMatrix);
        return myPattern;
    }

    public PDFLink makeLink(Rectangle2D rect, String page, String dest) {
        PDFLink link = new PDFLink(rect);
        this.getDocument().registerObject(link);
        PDFGoTo gt = new PDFGoTo(page);
        gt.setDestination(dest);
        this.getDocument().addTrailerObject(gt);
        PDFInternalLink internalLink = new PDFInternalLink(gt.referencePDF());
        link.setAction(internalLink);
        return link;
    }

    public PDFLink makeLink(Rectangle2D rect, String destination, int linkType, float yoffset) {
        PDFLink link = new PDFLink(rect);
        if (linkType == 0) {
            if (destination.startsWith("http://")) {
                PDFUri uri = new PDFUri(destination);
                link.setAction(uri);
            } else if (destination.endsWith(".pdf")) {
                PDFGoToRemote remote = this.getGoToPDFAction(destination, null, -1);
                link.setAction(remote);
            } else {
                int index = destination.indexOf(".pdf#page=");
                if (index > 0) {
                    int page = Integer.parseInt(destination.substring(index + 10));
                    PDFGoToRemote remote = this.getGoToPDFAction(destination, null, page);
                    link.setAction(remote);
                } else {
                    index = destination.indexOf(".pdf#dest=");
                    if (index > 0) {
                        String dest = destination.substring(index + 10);
                        PDFGoToRemote remote = this.getGoToPDFAction(destination, dest, -1);
                        link.setAction(remote);
                    } else {
                        PDFUri uri = new PDFUri(destination);
                        link.setAction(uri);
                    }
                }
            }
        } else {
            String goToReference = this.getGoToReference(destination, yoffset);
            PDFInternalLink internalLink = new PDFInternalLink(goToReference);
            link.setAction(internalLink);
        }
        PDFLink oldlink = this.getDocument().findLink(link);
        if (oldlink == null) {
            this.getDocument().registerObject(link);
        } else {
            link = oldlink;
        }
        return link;
    }

    private String getGoToReference(String destination, float yoffset) {
        String goToReference = null;
        PDFGoTo gt = new PDFGoTo(destination);
        gt.setYPosition(yoffset);
        PDFGoTo oldgt = this.getDocument().findGoTo(gt);
        if (oldgt == null) {
            this.getDocument().assignObjectNumber(gt);
            this.getDocument().addTrailerObject(gt);
        } else {
            gt = oldgt;
        }
        goToReference = gt.referencePDF();
        return goToReference;
    }

    private PDFGoToRemote getGoToPDFAction(String file, String dest, int page) {
        PDFFileSpec fileSpec = new PDFFileSpec(file);
        PDFFileSpec oldspec = this.getDocument().findFileSpec(fileSpec);
        if (oldspec == null) {
            this.getDocument().registerObject(fileSpec);
        } else {
            fileSpec = oldspec;
        }
        PDFGoToRemote remote = dest == null && page == -1 ? new PDFGoToRemote(fileSpec) : (dest != null ? new PDFGoToRemote(fileSpec, dest) : new PDFGoToRemote(fileSpec, page));
        PDFGoToRemote oldremote = this.getDocument().findGoToRemote(remote);
        if (oldremote == null) {
            this.getDocument().registerObject(remote);
        } else {
            remote = oldremote;
        }
        return remote;
    }

    public PDFOutline makeOutline(PDFOutline parent, String label, String destination, float yoffset, boolean showSubItems) {
        String goToRef = this.getGoToReference(destination, yoffset);
        PDFOutline obj = new PDFOutline(label, goToRef, showSubItems);
        if (parent != null) {
            parent.addOutline(obj);
        }
        this.getDocument().registerObject(obj);
        return obj;
    }

    public PDFEncoding makeEncoding(String encodingName) {
        PDFEncoding encoding = new PDFEncoding(encodingName);
        this.getDocument().registerObject(encoding);
        return encoding;
    }

    public PDFFont makeFont(String fontname, String basefont, String encoding, FontMetrics metrics, FontDescriptor descriptor) {
        PDFFont preRegisteredfont = this.getDocument().findFont(fontname);
        if (preRegisteredfont != null) {
            return preRegisteredfont;
        }
        if (descriptor == null) {
            PDFFont font = new PDFFont(fontname, FontType.TYPE1, basefont, encoding);
            this.getDocument().registerObject(font);
            return font;
        }
        FontType fonttype = metrics.getFontType();
        PDFFontDescriptor pdfdesc = this.makeFontDescriptor(descriptor);
        PDFFontNonBase14 font = null;
        font = fonttype == FontType.TYPE0 ? (PDFFontNonBase14)PDFFont.createFont(fontname, fonttype, basefont, "Identity-H") : (PDFFontNonBase14)PDFFont.createFont(fontname, fonttype, basefont, encoding);
        this.getDocument().registerObject(font);
        font.setDescriptor(pdfdesc);
        if (fonttype == FontType.TYPE0) {
            CIDFont cidMetrics = metrics instanceof LazyFont ? (CIDFont)((LazyFont)metrics).getRealFont() : (CIDFont)metrics;
            PDFCIDSystemInfo sysInfo = new PDFCIDSystemInfo(cidMetrics.getRegistry(), cidMetrics.getOrdering(), cidMetrics.getSupplement());
            PDFCIDFont cidFont = new PDFCIDFont(basefont, cidMetrics.getCIDType(), cidMetrics.getDefaultWidth(), this.getSubsetWidths(cidMetrics), sysInfo, (PDFCIDFontDescriptor)pdfdesc);
            this.getDocument().registerObject(cidFont);
            ((PDFFontType0)font).setDescendantFonts(cidFont);
        } else {
            int firstChar = 0;
            int lastChar = 255;
            if (metrics instanceof CustomFont) {
                CustomFont cf = (CustomFont)metrics;
                firstChar = cf.getFirstChar();
                lastChar = cf.getLastChar();
            }
            font.setWidthMetrics(firstChar, lastChar, this.makeArray(metrics.getWidths()));
        }
        return font;
    }

    public PDFWArray getSubsetWidths(CIDFont cidFont) {
        PDFWArray warray = new PDFWArray();
        int[] tmpWidth = new int[cidFont.usedGlyphsCount];
        int i = 0;
        while (i < cidFont.usedGlyphsCount) {
            Integer nw = (Integer)cidFont.usedGlyphsIndex.get(new Integer(i));
            int nwx = nw == null ? 0 : nw;
            tmpWidth[i] = cidFont.width[nwx];
            ++i;
        }
        warray.addEntry(0, tmpWidth);
        return warray;
    }

    public PDFFontDescriptor makeFontDescriptor(FontDescriptor desc) {
        AbstractPDFStream stream;
        PDFFontDescriptor descriptor = null;
        descriptor = desc.getFontType() == FontType.TYPE0 ? new PDFCIDFontDescriptor(desc.getFontName(), desc.getFontBBox(), desc.getCapHeight(), desc.getFlags(), desc.getItalicAngle(), desc.getStemV(), null) : new PDFFontDescriptor(desc.getFontName(), desc.getAscender(), desc.getDescender(), desc.getCapHeight(), desc.getFlags(), new PDFRectangle(desc.getFontBBox()), desc.getStemV(), desc.getItalicAngle());
        this.getDocument().registerObject(descriptor);
        if (desc.isEmbeddable() && (stream = this.makeFontFile(desc)) != null) {
            descriptor.setFontFile(desc.getFontType(), stream);
            this.getDocument().registerObject(stream);
        }
        return descriptor;
    }

    public AbstractPDFStream makeFontFile(FontDescriptor desc) {
        if (desc.getFontType() == FontType.OTHER) {
            throw new IllegalArgumentException("Trying to embed unsupported font type: " + desc.getFontType());
        }
        Typeface tempFont = desc instanceof LazyFont ? ((LazyFont)desc).getRealFont() : (Typeface)((Object)desc);
        if (!(tempFont instanceof CustomFont)) {
            throw new IllegalArgumentException("FontDescriptor must be instance of CustomFont, but is a " + desc.getClass().getName());
        }
        CustomFont font = (CustomFont)tempFont;
        InputStream in = null;
        try {
            AbstractPDFStream abstractPDFStream;
            if (font.getEmbedFileName() != null) {
                try {
                    in = this.getDocument().resolveURI(font.getEmbedFileName());
                }
                catch (Exception e) {
                    this.log.error("Failed to embed fontfile: " + font.getEmbedFileName() + "(" + e.getMessage() + ")");
                }
            }
            if (in == null && font.getEmbedResourceName() != null) {
                try {
                    in = new BufferedInputStream(this.getClass().getResourceAsStream(font.getEmbedResourceName()));
                }
                catch (Exception e) {
                    this.log.error("Failed to embed fontresource: " + font.getEmbedResourceName() + "(" + e.getMessage() + ")");
                }
            }
            if (in == null) {
                return null;
            }
            try {
                AbstractPDFStream embeddedFont;
                if (desc.getFontType() == FontType.TYPE0) {
                    MultiByteFont mbfont = (MultiByteFont)font;
                    FontFileReader reader = new FontFileReader(in);
                    TTFSubSetFile subset = new TTFSubSetFile();
                    byte[] subsetFont = subset.readFont(reader, mbfont.getTTCName(), mbfont.getUsedGlyphs());
                    embeddedFont = new PDFTTFStream(subsetFont.length);
                    ((PDFTTFStream)embeddedFont).setData(subsetFont, subsetFont.length);
                } else if (desc.getFontType() == FontType.TYPE1) {
                    PFBParser parser = new PFBParser();
                    PFBData pfb = parser.parsePFB(in);
                    embeddedFont = new PDFT1Stream();
                    ((PDFT1Stream)embeddedFont).setData(pfb);
                } else {
                    byte[] file = IOUtils.toByteArray(in);
                    embeddedFont = new PDFTTFStream(file.length);
                    ((PDFTTFStream)embeddedFont).setData(file, file.length);
                }
                abstractPDFStream = embeddedFont;
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return abstractPDFStream;
        }
        catch (IOException ioe) {
            this.log.error("Failed to embed font [" + desc + "] " + desc.getFontName(), ioe);
            return null;
        }
    }

    public PDFStream makeStream(String type, boolean add) {
        PDFStream obj = new PDFStream();
        obj.setDocument(this.getDocument());
        obj.getFilterList().addDefaultFilters(this.getDocument().getFilterMap(), type);
        if (add) {
            this.getDocument().registerObject(obj);
        }
        return obj;
    }

    public PDFICCStream makePDFICCStream() {
        PDFICCStream iccStream = new PDFICCStream();
        iccStream.getFilterList().addDefaultFilters(this.getDocument().getFilterMap(), "content");
        this.getDocument().registerObject(iccStream);
        return iccStream;
    }

    public PDFArray makeArray(int[] values) {
        PDFArray array = new PDFArray(values);
        this.getDocument().registerObject(array);
        return array;
    }

    public PDFGState makeGState(Map settings, PDFGState current) {
        PDFGState wanted = new PDFGState();
        wanted.addValues(PDFGState.DEFAULT);
        wanted.addValues(settings);
        PDFGState existing = this.getDocument().findGState(wanted, current);
        if (existing != null) {
            return existing;
        }
        PDFGState gstate = new PDFGState();
        gstate.addValues(settings);
        this.getDocument().registerObject(gstate);
        return gstate;
    }

    public PDFAnnotList makeAnnotList() {
        PDFAnnotList obj = new PDFAnnotList();
        this.getDocument().assignObjectNumber(obj);
        return obj;
    }
}

