/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.gui.help;

import de.miethxml.toolkit.cache.Cacheable;
import de.miethxml.toolkit.conf.ConfigManager;
import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.gui.LocaleButton;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpBrowser
implements ActionListener,
HyperlinkListener,
Cacheable {
    JFrame frame;
    JEditorPane pane;
    Stack back;
    Stack forward;
    String url;
    String last;
    String home;

    public HelpBrowser() {
        this.frame = new JFrame("Help");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                HelpBrowser.this.dispose();
            }
        });
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add("North", this.createJToolBar());
        this.pane = new JEditorPane();
        this.init();
        String fs = System.getProperty("file.separator");
        String initPage = "file:" + ConfigManager.getInstance().getProperty("help.path") + fs + ConfigManager.getInstance().getProperty("lang") + fs + "index.html";
        this.setHomePage(initPage);
        this.goHome();
        this.pane.setEditable(false);
        this.pane.addHyperlinkListener(this);
        JScrollPane scroll = new JScrollPane(this.pane);
        this.frame.getContentPane().add("Center", scroll);
        this.frame.pack();
        this.frame.setSize(500, 400);
        this.frame.setLocation(0, 20);
        this.last = "";
        this.url = "";
    }

    public HelpBrowser(JDesktopPane parent) {
        JInternalFrame iframe = new JInternalFrame(LocaleImpl.getInstance().getString("HelpBrowser.Title"), true, true, true, true);
        iframe.getContentPane().setLayout(new BorderLayout());
        iframe.getContentPane().add("North", this.createJToolBar());
        this.pane = new JEditorPane();
        this.init();
        String fs = System.getProperty("file.separator");
        String initPage = "file:" + ConfigManager.getInstance().getProperty("help.path") + fs + ConfigManager.getInstance().getProperty("lang") + fs + "index.html";
        this.setHomePage(initPage);
        this.goHome();
        this.pane.setEditable(false);
        this.pane.addHyperlinkListener(this);
        JScrollPane scroll = new JScrollPane(this.pane);
        iframe.getContentPane().add("Center", scroll);
        iframe.pack();
        iframe.setSize(500, 400);
        iframe.setLocation(0, 20);
        iframe.setVisible(true);
        this.last = "";
        this.url = "";
        parent.add(iframe);
        iframe.toFront();
    }

    public static void main(String[] args) {
        HelpBrowser browser = new HelpBrowser();
        browser.setHomePage(args[0]);
        browser.goHome();
    }

    private JToolBar createJToolBar() {
        JToolBar toolbar = new JToolBar();
        ImageIcon backicon = new ImageIcon("icons/back.gif");
        LocaleButton backbutton = new LocaleButton("common.button.back", backicon, false);
        backbutton.addActionListener(this);
        backbutton.setActionCommand("goback");
        toolbar.add(backbutton);
        ImageIcon homeicon = new ImageIcon("icons/home.gif");
        LocaleButton homebutton = new LocaleButton("common.button.home", homeicon, false);
        homebutton.addActionListener(this);
        homebutton.setActionCommand("gohome");
        toolbar.add(homebutton);
        ImageIcon forwardicon = new ImageIcon("icons/forward.gif");
        LocaleButton forwardbutton = new LocaleButton("common.button.forward", forwardicon, false);
        forwardbutton.addActionListener(this);
        forwardbutton.setActionCommand("goforward");
        toolbar.add(forwardbutton);
        return toolbar;
    }

    public void setHomePage(String homepage) {
        this.home = homepage;
    }

    public void goHome() {
        if (this.home != null) {
            this.back.push(this.url);
            this.last = this.url;
            this.setPage(this.home);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("goback") && !this.last.equals(this.url) && !this.back.empty()) {
            this.last = this.url;
            this.url = (String)this.back.pop();
            if (this.url != null) {
                this.setPage(this.url);
                this.forward.push(this.last);
            }
        }
        if (e.getActionCommand().equals("goforward") && !this.last.equals(this.url) && !this.forward.empty()) {
            this.last = this.url;
            this.url = (String)this.forward.pop();
            if (this.url != null) {
                this.setPage(this.url);
                this.back.push(this.last);
            }
        }
        if (e.getActionCommand().equals("gohome")) {
            this.goHome();
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.back.push(this.url);
            this.last = this.url;
            this.url = e.getURL().toExternalForm();
            this.setPage(this.url);
        }
    }

    public void setPage(String go) {
        if (go != null && go.length() > 0) {
            try {
                this.url = go;
                this.pane.setPage(this.url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void exit() {
        this.frame.dispose();
        System.exit(0);
    }

    private void init() {
        this.back = new Stack();
        this.forward = new Stack();
        this.url = "";
    }

    public void show() {
        this.frame.show();
    }

    public void dispose() {
        this.frame.dispose();
    }

    public void destroy() {
        this.frame = null;
        this.pane = null;
    }
}

