/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui;

import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.locale.LocaleChangeListener;
import de.miethxml.toolkit.locale.LocaleService;
import de.miethxml.toolkit.repository.Reloadable;
import de.miethxml.toolkit.repository.RepositoryModelImpl;
import de.miethxml.toolkit.repository.RepositorySelectionListener;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

public class ArchivAction
extends AbstractAction
implements LocaleChangeListener,
RepositorySelectionListener {
    private RepositoryModelImpl model;
    private FileModel file;
    private String[] zipextension = new String[]{".zip", ".sxw", ".sxc", ".sxi", ".sxd", ".sxg"};
    private String[] extensions = new String[]{".zip", ".jar", ".bz2", ".gz", ".sxw", ".sxc", ".sxi", ".sxd", ".sxg"};
    private boolean archivShowing = false;
    private FileModel oldBase;
    private String archivURL;
    private LocaleService locale;

    public ArchivAction(RepositoryModelImpl model, LocaleService locale) {
        super(locale.getString("view.context.popupmenu.open.archiv", "Open Archive"));
        this.putValue("ShortDescription", locale.getString("view.context.popupmenu.open.archiv", "Open Archive"));
        locale.addLocaleChangeListener(this);
        this.model = model;
        model.addRepositorySelectionListener(this);
        this.locale = locale;
    }

    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    String baseURL = "";
                    if (!ArchivAction.this.archivShowing) {
                        FileModel base = ArchivAction.this.model.getBase();
                        baseURL = ArchivAction.this.getArchivURL(ArchivAction.this.file.getPath());
                        ArchivAction.this.model.setBase(baseURL);
                        ArchivAction.this.archivURL = ArchivAction.this.model.getBase().getPath();
                        ArchivAction.this.archivShowing = true;
                        ArchivAction.this.setLabelBack();
                        ArchivAction.this.oldBase = base;
                    } else {
                        ArchivAction.this.archivShowing = false;
                        if (ArchivAction.this.oldBase != null) {
                            baseURL = ArchivAction.this.oldBase.getPath();
                        }
                        ArchivAction.this.oldBase = null;
                        ArchivAction.this.setLabelOpenArchive();
                        ArchivAction.this.model.setBase(baseURL);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    public void localeChanged(LocaleService locale) {
        this.putValue("ShortDescription", locale.getString("view.context.popupmenu.open.archiv"));
        this.putValue("Name", locale.getString("view.context.popupmenu.open.archiv"));
    }

    public void directorySelected(Reloadable model, FileModel directory) {
        this.setEnabled(false);
    }

    public void fileSelected(Reloadable model, FileModel f) {
        this.file = f;
        Thread t = new Thread(new Runnable(){

            public void run() {
                String name = ArchivAction.this.file.getName();
                int i = 0;
                while (i < ArchivAction.this.extensions.length) {
                    if (name.endsWith(ArchivAction.this.extensions[i])) {
                        ArchivAction.this.setEnabled(true);
                        return;
                    }
                    ++i;
                }
                ArchivAction.this.setEnabled(false);
            }
        });
        t.start();
    }

    public void unselect() {
        if (!this.model.getBase().getPath().equals(this.archivURL)) {
            this.setLabelOpenArchive();
            this.oldBase = null;
            this.archivShowing = false;
        }
        this.setEnabled(false);
    }

    private String getArchivURL(String url) {
        if (url.endsWith(".jar")) {
            return "jar:" + url;
        }
        if (url.endsWith(".gz")) {
            return "gz:" + this.file.getPath();
        }
        if (url.endsWith(".bz2")) {
            return "bz2:" + this.file.getPath();
        }
        int i = 0;
        while (i < this.zipextension.length) {
            if (url.endsWith(this.zipextension[i])) {
                return "zip:" + this.file.getPath();
            }
            ++i;
        }
        return "";
    }

    private void setLabelOpenArchive() {
        this.putValue("ShortDescription", this.locale.getString("view.context.popupmenu.open.archiv"));
        this.putValue("Name", this.locale.getString("view.context.popupmenu.open.archiv"));
    }

    private void setLabelBack() {
        this.putValue("ShortDescription", this.locale.getString("view.context.popupmenu.open.archiv.back"));
        this.putValue("Name", this.locale.getString("view.context.popupmenu.open.archiv.back"));
        this.setEnabled(true);
    }

    public void setEnabled(boolean b) {
        if (b) {
            super.setEnabled(b);
        } else if (!this.archivShowing) {
            super.setEnabled(b);
        }
    }
}

