/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.action;

import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.io.FileModelException;
import de.miethxml.toolkit.repository.ui.action.FileModelAction;
import de.miethxml.toolkit.repository.ui.action.RepositoryAction;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class CreateDirectoryAction
implements RepositoryAction,
FileModelAction {
    public void doAction(String uri) {
        File f = new File(uri);
        if (f.isDirectory()) {
            f = new File(String.valueOf(f.getAbsolutePath()) + File.separator + "NewFolder");
            f.mkdir();
        } else {
            String path = String.valueOf(f.getParent()) + File.separator + "NewFolder";
            f = new File(path);
            f.mkdir();
        }
    }

    public Icon getIcon() {
        ImageIcon icon = new ImageIcon("icons/newdir.png");
        return icon;
    }

    public boolean isSupported(String extention) {
        return true;
    }

    public boolean isHandleDirectory() {
        return true;
    }

    public boolean isHandleFile() {
        return true;
    }

    public String getToolTip(String lang) {
        return "New Folder";
    }

    public void doAction(FileModel model) {
        try {
            String name = JOptionPane.showInputDialog(LocaleImpl.getInstance().getString("action.newfolder"));
            if (name != null && name.length() > 0) {
                model.createDirectory(name);
            }
        }
        catch (FileModelException e) {
            e.printStackTrace();
        }
    }
}

