/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.wizard.component;

import de.miethxml.toolkit.wizard.WizardException;
import de.miethxml.toolkit.wizard.component.AbstractWizardComponent;
import de.miethxml.toolkit.wizard.ui.ExtractUI;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public class UnpackComponent
extends AbstractWizardComponent {
    public static String FILES_LIST_KEY = "file.list";
    public static String DESTINATION_KEY = "unpack.destination";
    private ExtractUI unpacker = new ExtractUI();

    public String getTitle() {
        return this.resource.getString("wizard.component.unpack.title");
    }

    public JComponent getInstallUIComponent() {
        return this.unpacker.getView();
    }

    public void startWizardProcess() throws WizardException {
        List list = (List)this.conf.getValue(FILES_LIST_KEY);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            File source = new File((String)i.next());
            String dest = null;
            if (this.conf.hasValue(DESTINATION_KEY)) {
                dest = (String)this.conf.getValue(DESTINATION_KEY);
                File d = new File(dest);
                if (!d.exists()) {
                    d.mkdirs();
                }
                System.out.println("DESTINATION:" + d.getAbsolutePath());
            } else {
                dest = source.getParentFile().getAbsolutePath();
            }
            try {
                this.unpacker.extractArchiv(source.getAbsolutePath(), dest);
            }
            catch (Exception e) {
                throw new WizardException(e);
            }
        }
    }

    public void stopWizardProcess() {
        this.unpacker.interrupt();
    }

    public boolean isModifiable() {
        return false;
    }
}

