/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui.viewer;

import de.miethxml.hawron.ApplicationConstants;
import de.miethxml.hawron.xml.SAXExternalViewerBuilder;
import de.miethxml.hawron.xml.XMLExternalViewerWriter;
import de.miethxml.toolkit.repository.ui.viewer.ExternalViewer;
import java.io.File;
import java.util.ArrayList;

public class ExternalViewerManager {
    public static String CONFIGFILE = "conf" + File.separator + "viewers.xml";
    private ArrayList viewers = new ArrayList();
    private String userConfig;

    public void initialize() {
        File f = new File(String.valueOf(ApplicationConstants.USER_CONFIG_HOME) + File.separator + CONFIGFILE);
        if (f.exists()) {
            this.load(f);
        } else {
            this.load(new File(CONFIGFILE));
        }
    }

    public int getViewerCount() {
        return this.viewers.size();
    }

    public void addViewer(ExternalViewer viewer) {
        this.viewers.add(viewer);
        this.save();
    }

    public ExternalViewer getViewer(int index) {
        return (ExternalViewer)this.viewers.get(index);
    }

    public void removeViewer(int index) {
        if (index >= 0 && index < this.viewers.size()) {
            this.viewers.remove(index);
        }
        this.save();
    }

    private void load(File file) {
        if (file.exists() && file.isFile()) {
            SAXExternalViewerBuilder parser = new SAXExternalViewerBuilder();
            this.viewers = parser.build(file.getAbsolutePath());
        }
    }

    public void save() {
        String config;
        XMLExternalViewerWriter writer = new XMLExternalViewerWriter();
        File f = new File(ApplicationConstants.USER_CONFIG_HOME);
        if (f.exists()) {
            config = String.valueOf(f.getAbsolutePath()) + File.separator + CONFIGFILE;
            File dir = new File(config);
            if (!dir.getParentFile().exists()) {
                dir.getParentFile().mkdir();
            }
        } else {
            config = CONFIGFILE;
        }
        writer.write(this.viewers, config);
    }
}

