/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.ui;

import de.miethxml.toolkit.ui.SmallTriangleBorder;
import de.miethxml.toolkit.ui.SplineBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.plaf.basic.BasicButtonUI;

public class SelectorComponent {
    private JPopupMenu popupmenu = new JPopupMenu();
    private Hashtable actions = new Hashtable();
    private JButton popupButton;
    private JMenuItem selectedItem;
    private LinkedList items = new LinkedList();

    public JComponent getView() {
        JPanel panel = new JPanel(new FlowLayout());
        panel.setOpaque(false);
        panel.setBorder(new SplineBorder());
        JButton button = new JButton(new ImageIcon("icons/button-back.png"));
        button.setUI(new BasicButtonUI());
        button.setPreferredSize(new Dimension(12, 14));
        button.setHorizontalAlignment(0);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setFocusable(false);
        button.setOpaque(false);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SelectorComponent.this.items.size() > 0) {
                    int index = SelectorComponent.this.items.indexOf(SelectorComponent.this.selectedItem);
                    index = index > 0 ? --index : SelectorComponent.this.items.size() - 1;
                    JMenuItem item = (JMenuItem)SelectorComponent.this.items.get(index);
                    item.doClick();
                    SelectorComponent.this.setSelectedItem(item);
                }
            }
        });
        panel.add(button);
        this.popupButton = new JButton("   ");
        this.popupButton.setUI(new BasicButtonUI());
        this.popupButton.setFocusable(false);
        this.popupButton.setBorder(new SmallTriangleBorder());
        this.popupButton.setOpaque(false);
        this.popupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component c = (Component)e.getSource();
                SelectorComponent.this.popupmenu.show(c, 0, c.getHeight());
            }
        });
        panel.add(this.popupButton);
        button = new JButton(new ImageIcon("icons/button-next.png"));
        button.setUI(new BasicButtonUI());
        button.setPreferredSize(new Dimension(12, 14));
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setFocusable(false);
        button.setOpaque(false);
        panel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SelectorComponent.this.items.size() > 0) {
                    int index = SelectorComponent.this.items.indexOf(SelectorComponent.this.selectedItem);
                    index = index < SelectorComponent.this.items.size() - 1 ? ++index : 0;
                    JMenuItem item = (JMenuItem)SelectorComponent.this.items.get(index);
                    item.doClick();
                    SelectorComponent.this.setSelectedItem(item);
                }
            }
        });
        panel.setMaximumSize(panel.getPreferredSize());
        panel.setAlignmentX(1.0f);
        return panel;
    }

    public void addAction(Action action) {
        JMenuItem item = new JMenuItem(action);
        action.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Action a = (Action)evt.getSource();
                if (SelectorComponent.this.selectedItem.getAction() != a) {
                    SelectorComponent.this.setSelectedAction(a);
                }
            }
        });
        this.items.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                SelectorComponent.this.setSelectedItem(item);
            }
        });
        this.actions.put(item, action);
        this.popupmenu.add(item);
        if (this.items.size() == 1) {
            item.doClick();
            this.setSelectedItem(item);
        }
    }

    private void setSelectedItem(JMenuItem item) {
        Action action = (Action)this.actions.get(item);
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon != null) {
            this.popupButton.setIcon(icon);
            this.popupButton.setText(item.getText());
        } else {
            this.popupButton.setText(item.getText());
            this.popupButton.setIcon(null);
        }
        this.selectedItem = item;
    }

    private void setSelectedAction(Action action) {
        Enumeration e = this.actions.keys();
        while (e.hasMoreElements()) {
            JMenuItem item = (JMenuItem)e.nextElement();
            Action a = (Action)this.actions.get(item);
            if (a != action) continue;
            this.setSelectedItem(item);
        }
    }
}

